/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.report;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.FragmentManager;
import androidx.viewpager.widget.PagerAdapter;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.annotation.RouteDoc;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseDarkModeActivity;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.report.ReportFeedbackFragment;
import com.yy.mobile.ui.report.ReportPageTransformer;
import com.yy.mobile.ui.report.ReportPagerFragment;
import com.yy.mobile.ui.report.ReportSubmitFragment;
import com.yy.mobile.ui.report.ReportTypeFragment;
import com.yy.mobile.ui.report.ReportViewPager;
import com.yy.mobile.ui.report.listener.ReportViewPageChangedListener;
import com.yy.mobile.ui.report.module.ReportModule;
import com.yy.mobile.ui.report.module.ReportModuleListener;
import com.yy.mobile.ui.report.utils.ReportScreenShot;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.pager.FixedFragmentStatePagerAdapter;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.FileUtil;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.im.request.AddToBlackListAction;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Route(path="/Im/Report", name="\u8d70im\u7684\u4e3e\u62a5\u6d41\u7a0b")
@RouteDoc(desc="\u4e3e\u62a5", minVer="7.17.0", eg="yymobile://Im/Report")
public class ReportActivity
extends BaseDarkModeActivity {
    private static final String TAG = "ReportActivity";
    public static final String REPORT_STYLE = "report_style";
    public static final String REPORT_CONTENT = "report_content";
    public static final String VOICE_EVENT_ID = "56502";
    public static final String VOICE_LABEL_REPORT_SUCCESS = "0017";
    private int mStyle;
    private long mMineUid;
    private long mUserUid;
    private String mReportContent;
    private String mReportFilePath;
    private int source;
    private boolean mIsShielding = false;
    private SimpleTitleBar mTitleBar;
    private ReportViewPager mReportPager;
    private ImReportAdapter mReportAdapter;
    private ReportModule mReportModule;
    public List<ReportPagerFragment> mPageFragmentList = new ArrayList<ReportPagerFragment>();
    private ReportViewPageChangedListener mReportViewPageChangedListener = new ReportViewPageChangedListener(){

        @Override
        public void onReportViewPageChanged(int page, int style2) {
            ReportActivity.this.mStyle = style2;
            ReportActivity.this.changeReportViewPage(page);
        }

        @Override
        public void onReportViewPageSubmited(int page, boolean shielding, String reportDesc) {
            ReportActivity.this.mReportContent = reportDesc;
            ReportActivity.this.submitReport(shielding);
        }

        @Override
        public void onReportViewPageClosed() {
            FileUtil.delete((String)ReportActivity.this.mReportFilePath);
            ReportActivity.this.finish();
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getIntent() != null) {
            this.mMineUid = this.getIntent().getLongExtra("report_mine_uid", 0L);
            this.mUserUid = this.getIntent().getLongExtra("report_user_uid", 0L);
            this.mReportFilePath = this.getIntent().getStringExtra("report_file_path");
            this.source = this.getIntent().getIntExtra("source", 0);
        } else if (savedInstanceState != null) {
            this.mMineUid = savedInstanceState.getLong("report_mine_uid");
            this.mUserUid = savedInstanceState.getLong("report_user_uid");
            this.mStyle = savedInstanceState.getInt(REPORT_STYLE);
            this.mReportContent = savedInstanceState.getString(REPORT_CONTENT);
            this.mReportFilePath = savedInstanceState.getString("report_file_path");
        }
        MLog.info((Object)TAG, (String)"loginUid:%s anchorUid:%s screenShotPath:%s", (Object[])new Object[]{this.mMineUid, this.mUserUid, this.mReportFilePath});
        this.getWindow().getDecorView().setBackgroundColor(this.getResources().getColor(R.color.common_f1_color));
        this.setContentView(R.layout.activity_report);
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.im_report_title_bar);
        this.mTitleBar.setTitlte(this.getString(R.string.str_report_type));
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                if (ReportActivity.this.mReportPager != null && ReportActivity.this.mReportPager.getCurrentItem() == 1) {
                    ReportActivity.this.changeReportViewPage(0);
                    return;
                }
                FileUtil.delete((String)ReportActivity.this.mReportFilePath);
                ReportActivity.this.finish();
            }
        });
        this.registerPagerFragment();
        this.mReportPager = (ReportViewPager)this.findViewById(R.id.im_report_fragment_pager);
        this.mReportAdapter = new ImReportAdapter(this.getSupportFragmentManager());
        this.mReportPager.setAdapter((PagerAdapter)this.mReportAdapter);
        this.mReportPager.setPageTransformer(true, new ReportPageTransformer());
        this.mReportModule = new ReportModule(this.mMineUid, this.mUserUid);
        this.mReportModule.setImReportModuleListener(new ReportModuleListener(){

            public void reportSuccessed() {
                Property property = new Property();
                property.putString("key1", String.valueOf(LoginUtil.getUid()));
                property.putString("key2", String.valueOf(ReportActivity.this.mUserUid));
                property.putString("key3", "2");
                ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(ReportActivity.VOICE_EVENT_ID, ReportActivity.VOICE_LABEL_REPORT_SUCCESS, (Serializable)property);
                if (ReportActivity.this.mIsShielding) {
                    YYStore.INSTANCE.dispatch((ReqAction)new AddToBlackListAction(ReportActivity.this.mUserUid));
                }
                ReportActivity.this.changeReportViewPage(2);
            }

            public void reportFailed(int errCode) {
                if (errCode == -1) {
                    Toast.makeText((Context)ReportActivity.this.getContext(), (int)R.string.main_str_report_fail, (int)0).show();
                } else if (errCode == -2) {
                    Toast.makeText((Context)ReportActivity.this.getContext(), (int)R.string.str_report_exception, (int)0).show();
                } else if (errCode == 1) {
                    Toast.makeText((Context)ReportActivity.this.getContext(), (int)R.string.str_report_repeat, (int)0).show();
                }
            }
        });
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(REPORT_STYLE, this.mStyle);
        outState.putLong("report_mine_uid", this.mMineUid);
        outState.putLong("report_user_uid", this.mUserUid);
        outState.putString(REPORT_CONTENT, this.mReportContent);
        outState.putString("report_file_path", this.mReportFilePath);
    }

    public void onResume() {
        super.onResume();
        this.checkNetToast();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mReportModule != null) {
            this.mReportModule.destroy();
        }
    }

    private void registerPagerFragment() {
        this.mPageFragmentList.clear();
        this.mPageFragmentList.add(ReportTypeFragment.newInstance(this.source));
        this.mPageFragmentList.add(ReportSubmitFragment.newInstance(this.mUserUid));
        this.mPageFragmentList.add(ReportFeedbackFragment.newInstance(this.mUserUid));
    }

    private void changeReportViewPage(int page) {
        if (this.mReportPager != null) {
            this.mReportPager.setCurrentItem(page, true);
        }
        String strTitle = this.getString(R.string.str_report_type);
        if (page == 0) {
            strTitle = this.getString(R.string.str_report_type);
        } else if (page == 1) {
            strTitle = this.getString(R.string.str_report_cause);
        } else if (page == 2) {
            strTitle = this.getString(R.string.str_report_title);
        }
        if (this.mTitleBar != null) {
            this.mTitleBar.setTitlte(strTitle);
        }
    }

    private void submitReport(boolean shielding) {
        if (this.mReportModule != null) {
            if (TextUtils.isEmpty((CharSequence)this.mReportFilePath)) {
                this.mReportFilePath = ReportScreenShot.getScreenShot((Activity)this);
            }
            if (StringUtils.isEmptyString((String)this.mReportFilePath)) {
                Toast.makeText((Context)this.getContext(), (int)R.string.str_report_submit_photo_path_null, (int)0).show();
                return;
            }
            if (StringUtils.isEmptyString((String)this.mReportContent)) {
                Toast.makeText((Context)this.getContext(), (int)R.string.str_report_submit_desc_null, (int)0).show();
                return;
            }
            if (this.mReportContent.length() > 200) {
                Toast.makeText((Context)this.getContext(), (int)R.string.str_report_submit_desc_nums_limit, (int)0).show();
                return;
            }
            this.mIsShielding = shielding;
            this.mReportModule.submitReport(this.mStyle, this.mReportContent, this.mReportFilePath);
        }
    }

    public class ImReportAdapter
    extends FixedFragmentStatePagerAdapter {
        private final int count = 3;

        public ImReportAdapter(FragmentManager fm) {
            super(fm);
            this.count = 3;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
        }

        public CharSequence getPageTitle(int position) {
            return "";
        }

        public BaseLinkFragment getItem(int position) {
            if (ReportActivity.this.mPageFragmentList != null && ReportActivity.this.mPageFragmentList.size() > position) {
                ReportPagerFragment reportPagerFragment = ReportActivity.this.mPageFragmentList.get(position);
                if (reportPagerFragment != null) {
                    reportPagerFragment.setReportViewPageChangedListener(ReportActivity.this.mReportViewPageChangedListener);
                    return reportPagerFragment;
                }
                MLog.error((String)ReportActivity.TAG, (String)"ReportPagerFragment is null!");
            }
            return null;
        }

        public int getCount() {
            return 3;
        }

        public int getItemPosition(Object object) {
            return -2;
        }
    }
}

