/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.rechargebanner;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.webkit.WebView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.ui.rechargebanner.WebViewPopupController;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewEventListener;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewTitleFragmentInterface;
import com.yy.mobile.ylink.bridge.coreapi.WebViewFragmentApi;
import org.json.JSONException;
import org.json.JSONObject;

public class WebViewPopupComponent
extends PopupComponent
implements EventCompat {
    public static final String TAG = "WebViewPopupComponent";
    private static int landscapeWidth;
    private static int landscapeHeight;
    private static int landscapeDistanceX;
    private static int landscapeDistanceY;
    private static int portraitWidth;
    private static int portraitHeight;
    private static int portraitDistanceX;
    private static int portraitDistanceY;
    private static boolean isTitle;
    private static boolean resizeSoftInput;
    private static String url;
    private static MobileActTagInfo actTagInfo;
    private static WebViewPopupComponent component;
    private BaseLinkFragment commonTitleFragment;
    private IWebViewTitleFragmentInterface mWebViewTitleFragmentInterface;
    private WebViewPopupController.OperationReporter mOperationReporter;
    private BaseLinkFragment rootFragment;

    public BaseLinkFragment getRootFragment() {
        return this.rootFragment;
    }

    public static WebViewPopupComponent newInstance(JSONObject json) {
        WebViewPopupComponent.loadJson(json);
        component = new WebViewPopupComponent();
        return component;
    }

    public static boolean isScreenOriatationPortrait(Context context) {
        return context.getResources().getConfiguration().orientation == 1;
    }

    public static void loadJson(JSONObject json) {
        if (json != null) {
            try {
                String actId = json.getString("actId");
                url = json.getString("actUrl");
                actTagInfo = new MobileActTagInfo(TAG, actId);
                JSONObject portraitJson = json.getJSONObject("portrait");
                portraitDistanceX = portraitJson.getInt("x");
                portraitDistanceY = portraitJson.getInt("y");
                portraitWidth = portraitJson.getInt("width");
                portraitHeight = portraitJson.getInt("height");
                Log.d((String)TAG, (String)("portraitDistanceX:" + portraitDistanceX + " portraitDistanceY:" + portraitDistanceY + " portraitWidth:" + portraitWidth + " portraitHeight:" + portraitHeight));
                JSONObject landscapeJson = json.getJSONObject("landscape");
                landscapeDistanceX = landscapeJson.getInt("x");
                landscapeDistanceY = landscapeJson.getInt("y");
                landscapeWidth = landscapeJson.getInt("width");
                landscapeHeight = landscapeJson.getInt("height");
                isTitle = json.optBoolean("isTitle", false);
                resizeSoftInput = json.optBoolean("resizeSoftInput", false);
                MLog.info((String)TAG, (String)("landscapeDistanceX:" + landscapeDistanceX + " landscapeDistanceY:" + landscapeDistanceY + " landscapeWidth:" + landscapeWidth + " landscapeHeight:" + landscapeHeight + " isTitle:" + isTitle));
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Empty Catch on loadJson", (Throwable)e);
            }
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog.getWindow().setFlags(1024, 1024);
        if (!resizeSoftInput) {
            dialog.getWindow().getDecorView().setPadding(0, 0, 0, 0);
        }
        if (isTitle) {
            dialog.getWindow().setBackgroundDrawableResource(R.color.white);
        }
        this.setDialogPrepare(dialog);
        if (resizeSoftInput) {
            dialog.getWindow().setSoftInputMode(16);
        }
        return dialog;
    }

    public void setComponent(WebViewPopupController.OperationReporter wpc) {
        this.mOperationReporter = wpc;
    }

    public void onDestroy() {
        super.onDestroy();
        this.mOperationReporter = null;
        actTagInfo = null;
        component = null;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        BaseLinkFragment mWVFragment;
        View layout2 = inflater.inflate(R.layout.act_webview_dialog, container);
        RelativeLayout webLayout = (RelativeLayout)layout2.findViewById(R.id.webview_fragment);
        if (WebViewPopupComponent.isScreenOriatationPortrait((Context)this.getActivity())) {
            if (isTitle) {
                RelativeLayout.LayoutParams portraitParams = new RelativeLayout.LayoutParams((int)ResolutionUtils.convertDpToPixel((float)portraitWidth, (Context)this.getActivity()), (int)ResolutionUtils.convertDpToPixel((float)portraitHeight, (Context)this.getActivity()));
                portraitParams.addRule(3, R.id.web_title);
                webLayout.setLayoutParams((ViewGroup.LayoutParams)portraitParams);
            } else {
                webLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams((int)ResolutionUtils.convertDpToPixel((float)portraitWidth, (Context)this.getActivity()), (int)ResolutionUtils.convertDpToPixel((float)portraitHeight, (Context)this.getActivity())));
            }
        } else if (isTitle) {
            RelativeLayout.LayoutParams landParams = new RelativeLayout.LayoutParams((int)ResolutionUtils.convertDpToPixel((float)landscapeWidth, (Context)this.getActivity()), (int)ResolutionUtils.convertDpToPixel((float)landscapeHeight, (Context)this.getActivity()));
            landParams.addRule(3, R.id.web_title);
            webLayout.setLayoutParams((ViewGroup.LayoutParams)landParams);
        } else {
            webLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams((int)ResolutionUtils.convertDpToPixel((float)landscapeWidth, (Context)this.getActivity()), (int)ResolutionUtils.convertDpToPixel((float)landscapeHeight, (Context)this.getActivity())));
        }
        FragmentTransaction ft = this.getChildFragmentManager().beginTransaction();
        if (isTitle) {
            RelativeLayout fl = (RelativeLayout)layout2.findViewById(R.id.web_title);
            fl.setVisibility(0);
            this.commonTitleFragment = this.getOrCreateWebViewTitleFragment();
            this.mWebViewTitleFragmentInterface = ((WebViewFragmentApi)CoreApiManager.getInstance().getApi(WebViewFragmentApi.class)).getWebViewTitleFragmentMethod(this.commonTitleFragment);
            if (this.commonTitleFragment.isDetached()) {
                ft.attach((Fragment)this.commonTitleFragment);
            } else if (!this.commonTitleFragment.isAdded()) {
                ft.add(R.id.web_title, (Fragment)this.commonTitleFragment);
            }
        }
        this.rootFragment = mWVFragment = this.getOrCreatWebViewFragment(url, actTagInfo);
        if (mWVFragment.isDetached()) {
            ft.attach((Fragment)mWVFragment);
            ft.commitAllowingStateLoss();
        } else if (!mWVFragment.isAdded()) {
            ft.add(R.id.webview_fragment, (Fragment)mWVFragment);
            ft.commitAllowingStateLoss();
        }
        return layout2;
    }

    private BaseLinkFragment getOrCreatWebViewFragment(String url, MobileActTagInfo actInfo) {
        MyWebViewEventListener listener2 = new MyWebViewEventListener();
        BaseLinkFragment wvFragment = ((WebViewFragmentApi)CoreApiManager.getInstance().getApi(WebViewFragmentApi.class)).createWebViewFragment(url, true, (IWebViewEventListener)listener2, false);
        return wvFragment;
    }

    private BaseLinkFragment getOrCreateWebViewTitleFragment() {
        BaseLinkFragment wvTitleFragment = ((WebViewFragmentApi)CoreApiManager.getInstance().getApi(WebViewFragmentApi.class)).createWebViewTitleFragment();
        return wvTitleFragment;
    }

    private void setDialogPrepare(Dialog dialog) {
        Window win = dialog.getWindow();
        WindowManager.LayoutParams lp = win.getAttributes();
        if (WebViewPopupComponent.isScreenOriatationPortrait((Context)this.getActivity())) {
            lp.x = portraitDistanceX;
            lp.y = portraitDistanceY;
            lp.width = (int)ResolutionUtils.convertDpToPixel((float)portraitWidth, (Context)this.getActivity());
            lp.height = (int)ResolutionUtils.convertDpToPixel((float)portraitHeight, (Context)this.getActivity());
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"zjl", (String)TAG, (Object[])new Object[]{"portraitDistanceX:" + lp.x + " portraitDistanceY:" + lp.y + " portraitWidth:" + lp.width + " portraitHeight:" + lp.height});
            }
        } else {
            lp.x = landscapeDistanceX;
            lp.y = landscapeDistanceY;
            lp.width = (int)ResolutionUtils.convertDpToPixel((float)landscapeWidth, (Context)this.getActivity());
            lp.height = (int)ResolutionUtils.convertDpToPixel((float)landscapeHeight, (Context)this.getActivity());
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"zjl", (String)TAG, (Object[])new Object[]{"landscapeDistanceX:" + lp.x + " landscapeDistanceY:" + lp.y + " landscapeWidth:" + lp.width + " landscapeHeight:" + lp.height});
            }
        }
        win.setAttributes(lp);
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOperationReporter != null) {
            this.mOperationReporter.dismissedSelf(this);
        }
    }

    class MyWebViewEventListener
    implements IWebViewEventListener {
        MyWebViewEventListener() {
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        }

        public void onReceivedTitle(WebView view, String title) {
            if (isTitle && WebViewPopupComponent.this.commonTitleFragment != null && WebViewPopupComponent.this.mWebViewTitleFragmentInterface != null) {
                WebViewPopupComponent.this.mWebViewTitleFragmentInterface.setTitleText(title);
            }
        }

        public void handleBackAction() {
        }

        public void shouldOverrideUrlLoading(WebView view, String url) {
        }

        public void onActWebData(String param) {
        }

        public void onViewCreated(View view) {
        }

        public void onPageStarted(WebView view, String url, Bitmap favIcon) {
            if (isTitle && WebViewPopupComponent.this.commonTitleFragment != null && WebViewPopupComponent.this.mWebViewTitleFragmentInterface != null) {
                WebViewPopupComponent.this.mWebViewTitleFragmentInterface.setBackBtnEnableState(true);
                WebViewPopupComponent.this.mWebViewTitleFragmentInterface.setBackListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        WebViewPopupComponent.this.dismiss();
                    }
                });
            }
        }

        public void onPageFinished(WebView view, String url) {
        }

        public void changeHeight(int height) {
        }

        public Animation createAnim(int transit, boolean enter, int nextAnim) {
            return null;
        }
    }

    public static class MobileActTagInfo {
        public static final String TAG_MOBILE_ACT = "tag_ActName";
        public static final String TAG_ID = "tag_ActId";
        public String actTag;
        public String tagId;

        public MobileActTagInfo() {
        }

        public MobileActTagInfo(String actTag, String tagId) {
            this.actTag = actTag;
            this.tagId = tagId;
        }

        public String toString() {
            return "MobileActTagInfo{actTag='" + this.actTag + '\'' + ", tagId='" + this.tagId + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MobileActTagInfo that = (MobileActTagInfo)o;
            return this.actTag != null ? this.actTag.equals(that.actTag) : that.actTag == null;
        }

        public int hashCode() {
            int result = this.actTag != null ? this.actTag.hashCode() : 0;
            result = 31 * result + (this.tagId != null ? this.tagId.hashCode() : 0);
            return result;
        }
    }
}

