/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.view;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.profile.view.IBarragePlay;
import com.yy.mobile.ui.profile.view.ReplayViewBinder;
import com.yy.mobile.ui.utils.DimensUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;

public class HolderDetectorRecycleView
extends RecyclerView {
    private static final String TAG = "AutoPlaySubtitleRecycleView";
    private static final long START_DETECT_DELAY = 1000L;
    private int heightScreen;
    private int bottomViewTopLocation;
    private SpecialHolderDetector detector;
    private IBarragePlay curBarrageView;
    private RefreshLayout refreshLayout;

    public HolderDetectorRecycleView(Context context) {
        super(context);
        this.heightScreen = ScreenUtil.getInstance().getDisplayMetrics().heightPixels;
        this.bottomViewTopLocation = this.heightScreen - 137;
        this.detector = new SpecialHolderDetector();
    }

    public HolderDetectorRecycleView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.heightScreen = ScreenUtil.getInstance().getDisplayMetrics().heightPixels;
        this.bottomViewTopLocation = this.heightScreen - 137;
        this.detector = new SpecialHolderDetector();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.bottomViewTopLocation = this.heightScreen - DimensUtils.dip2pixel((Context)this.getContext(), (float)25.0f);
        this.setNestedScrollingEnabled(true);
        this.onCreate();
    }

    public void setRefreshLayout(RefreshLayout refreshLayout) {
        this.refreshLayout = refreshLayout;
    }

    private void onCreate() {
        this.detector.onCreate();
    }

    public void onVisibleChange(boolean visible) {
        MLog.info((String)TAG, (String)("visible change: " + visible));
        if (visible) {
            MLog.info((String)TAG, (String)"startDetectDelay");
            this.detector.startDetectDelay(1500L);
        }
    }

    public void startDetect() {
        this.detector.startDetectDelay(1500L);
    }

    public void stopDetect() {
        this.detector.stopDetect();
        if (this.curBarrageView != null) {
            this.curBarrageView.stopPlay();
            this.curBarrageView = null;
        }
    }

    public void onDestroy() {
        this.detector.onDestroy();
        if (this.curBarrageView != null) {
            this.curBarrageView.stopPlay();
            this.curBarrageView = null;
        }
    }

    private boolean allowDetect() {
        if (this.refreshLayout == null || this.refreshLayout.isRefreshing()) {
            return false;
        }
        return this.getAdapter() != null && this.getAdapter().getItemCount() > 0;
    }

    class SpecialHolderDetector
    extends RecyclerView.OnScrollListener {
        private Handler handler = new Handler(){

            public void handleMessage(Message msg) {
                if (!HolderDetectorRecycleView.this.allowDetect()) {
                    return;
                }
                ReplayViewBinder.ViewHolder holder = SpecialHolderDetector.this.getSpecialHolder();
                if (holder == null || holder.getBarragePlayView() == null) {
                    return;
                }
                IBarragePlay barrageView = holder.getBarragePlayView();
                if (barrageView != HolderDetectorRecycleView.this.curBarrageView && HolderDetectorRecycleView.this.curBarrageView != null) {
                    HolderDetectorRecycleView.this.curBarrageView.stopPlay();
                }
                HolderDetectorRecycleView.this.curBarrageView = barrageView;
                HolderDetectorRecycleView.this.curBarrageView.startPlay(holder.getItemData().liveId);
            }
        };

        SpecialHolderDetector() {
        }

        public void onCreate() {
            HolderDetectorRecycleView.this.addOnScrollListener(this);
        }

        public void onDestroy() {
            HolderDetectorRecycleView.this.removeOnScrollListener(this);
            this.handler.removeCallbacksAndMessages(null);
        }

        public void startDetectDelay(long delay) {
            this.handler.removeCallbacksAndMessages(null);
            this.handler.sendEmptyMessageDelayed(0, delay);
        }

        public void stopDetect() {
            this.handler.removeCallbacksAndMessages(null);
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            MLog.debug((String)HolderDetectorRecycleView.TAG, (String)("onScrollStateChanged newState: " + newState));
            if (HolderDetectorRecycleView.this.refreshLayout != null && HolderDetectorRecycleView.this.refreshLayout.isRefreshing()) {
                MLog.debug((String)HolderDetectorRecycleView.TAG, (String)"Refreshing disallow detect");
                return;
            }
            if (newState == 0) {
                this.handleBarrageStatus();
            } else if (HolderDetectorRecycleView.this.curBarrageView != null) {
                HolderDetectorRecycleView.this.curBarrageView.pausePlay();
            }
        }

        private void handleBarrageStatus() {
            ReplayViewBinder.ViewHolder holder = this.getSpecialHolder();
            if (holder == null) {
                return;
            }
            IBarragePlay barrageView = holder.getBarragePlayView();
            if (barrageView == HolderDetectorRecycleView.this.curBarrageView) {
                MLog.debug((String)HolderDetectorRecycleView.TAG, (String)"continuePlay");
                if (barrageView != null) {
                    barrageView.continuePlay();
                }
            } else {
                if (HolderDetectorRecycleView.this.curBarrageView != null) {
                    MLog.debug((String)HolderDetectorRecycleView.TAG, (String)"is Playing animStopPlay");
                    HolderDetectorRecycleView.this.curBarrageView.animStopPlay();
                }
                HolderDetectorRecycleView.this.curBarrageView = barrageView;
                MLog.debug((String)HolderDetectorRecycleView.TAG, (String)"startDetectDelay");
                this.startDetectDelay(1000L);
            }
        }

        private ReplayViewBinder.ViewHolder getSpecialHolder() {
            int[] limitPosition = this.getLimitPositionInScreen();
            int min = limitPosition[0];
            int max = limitPosition[1];
            MLog.info((Object)HolderDetectorRecycleView.TAG, (String)"detector range: [min = %d, max = %d]", (Object[])new Object[]{min, max});
            RecyclerView.ViewHolder viewHolderMax = null;
            float percentMax = 0.0f;
            for (int i = min; i <= max; ++i) {
                RecyclerView.ViewHolder viewHolder = HolderDetectorRecycleView.this.findViewHolderForAdapterPosition(i);
                float percentViewHolder = this.getPercentInScreen(viewHolder);
                MLog.info((Object)HolderDetectorRecycleView.TAG, (String)"i = %d, percent = %f", (Object[])new Object[]{i, Float.valueOf(percentViewHolder)});
                if (!(percentViewHolder > percentMax) || !(percentViewHolder >= 60.0f)) continue;
                viewHolderMax = viewHolder;
                break;
            }
            return (ReplayViewBinder.ViewHolder)viewHolderMax;
        }

        private float getPercentInScreen(RecyclerView.ViewHolder viewHolder) {
            if (viewHolder == null || viewHolder.itemView == null) {
                return 0.0f;
            }
            View view = viewHolder.itemView.findViewById(R.id.video_layout);
            if (view == null) {
                return 0.0f;
            }
            int[] holderLocation = new int[2];
            view.getLocationOnScreen(holderLocation);
            int viewHeight = view.getHeight();
            int viewTop = holderLocation[1];
            int viewBottom = holderLocation[1] + viewHeight;
            int[] topViewLocation = new int[2];
            HolderDetectorRecycleView.this.getLocationOnScreen(topViewLocation);
            int topViewBottomLocation = topViewLocation[1];
            if (viewTop >= topViewBottomLocation && viewBottom <= HolderDetectorRecycleView.this.bottomViewTopLocation) {
                return 100.0f;
            }
            if (viewTop < topViewBottomLocation && viewBottom > HolderDetectorRecycleView.this.bottomViewTopLocation) {
                return 100.0f;
            }
            if (viewTop < topViewBottomLocation && viewBottom <= HolderDetectorRecycleView.this.bottomViewTopLocation) {
                float percent = (float)(viewBottom - topViewBottomLocation) / (float)viewHeight * 100.0f;
                return percent < 0.0f ? 0.0f : percent;
            }
            if (viewTop >= topViewBottomLocation && viewBottom > HolderDetectorRecycleView.this.bottomViewTopLocation) {
                float percent = (float)(HolderDetectorRecycleView.this.bottomViewTopLocation - viewTop) / (float)viewHeight * 100.0f;
                return percent < 0.0f ? 0.0f : percent;
            }
            return 0.0f;
        }

        private int[] getLimitPositionInScreen() {
            int findFirstVisibleItemPosition = ((LinearLayoutManager)HolderDetectorRecycleView.this.getLayoutManager()).findFirstVisibleItemPosition();
            MLog.info((Object)HolderDetectorRecycleView.TAG, (String)"FirstVisibleItemPosition: %d", (Object[])new Object[]{findFirstVisibleItemPosition});
            int findLastVisibleItemPosition = ((LinearLayoutManager)HolderDetectorRecycleView.this.getLayoutManager()).findLastVisibleItemPosition();
            MLog.info((Object)HolderDetectorRecycleView.TAG, (String)"LastVisibleItemPosition: %d", (Object[])new Object[]{findLastVisibleItemPosition});
            int min = Math.min(findFirstVisibleItemPosition, findLastVisibleItemPosition);
            int max = Math.max(findFirstVisibleItemPosition, findLastVisibleItemPosition);
            return new int[]{min, max};
        }
    }
}

