/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.view;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnRefreshLoadmoreListener;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.profile.anchor.WorksFragment;
import com.yy.mobile.ui.profile.presenter.BaseRequestPresenter;
import com.yy.mobile.ui.profile.view.IRequestStatusView;
import com.yy.mobile.ui.profile.view.WorksSubPageNoDataFragment;
import com.yy.mobile.util.log.MLog;

public abstract class BaseRequestFragment<P extends BaseRequestPresenter<V>, V extends IRequestStatusView>
extends BaseLinkFragment<P, V>
implements OnRefreshLoadmoreListener,
IRequestStatusView {
    private static final String TAG = "BaseRequestFragment";
    protected SmartRefreshLayout refreshLayout;
    protected View rootView;
    protected long anchorUid;
    protected View contentView;
    protected View loadingView;
    protected int reqSizeOffset = 0;
    private boolean isFirstVisible = true;
    protected boolean visible = false;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.fetchArgs();
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.rootView = inflater.inflate(R.layout.fragment_base_layout, null);
        this.initView(this.rootView);
        this.showLoadingView(this.rootView);
        this.requestData();
        return this.rootView;
    }

    protected abstract String getErrorTipContent();

    protected abstract View getContentView();

    protected void requestData() {
        MLog.info((String)TAG, (String)("request data: " + this.getClass().getSimpleName()));
        ((BaseRequestPresenter)this.getPresenter()).requestData(this.anchorUid, true, this.reqSizeOffset);
    }

    public void showLoadingView(View view) {
        MLog.info((String)TAG, (String)(this.getClass().getSimpleName() + " showLoadingView"));
        this.showNoDataView();
    }

    @Override
    public void hideLoadingView() {
        MLog.info((String)TAG, (String)(this.getClass().getSimpleName() + " hideLoadingView"));
        this.refreshLayout.finishLoadmore();
    }

    @Override
    public void showNoDataView() {
        MLog.info((String)TAG, (String)(this.getClass().getSimpleName() + " showNoDataView"));
        WorksSubPageNoDataFragment fragment = WorksSubPageNoDataFragment.newInstance(this.getErrorTipContent());
        this.showFragment((Fragment)fragment);
    }

    private void initView(View rootView) {
        this.initRefreshLayout(rootView);
        this.contentView = this.getContentView();
        this.refreshLayout.addView(this.contentView);
    }

    private void initRefreshLayout(View rootView) {
        this.refreshLayout = (SmartRefreshLayout)rootView.findViewById(R.id.refresh_layout);
        this.refreshLayout.setOnRefreshLoadmoreListener((OnRefreshLoadmoreListener)this);
        this.refreshLayout.setEnableLoadmore(true);
        this.refreshLayout.setEnableRefresh(false);
        this.refreshLayout.setNestedScrollingEnabled(true);
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    @SuppressLint(value={"AutowiredUsage"})
    private void fetchArgs() {
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.anchorUid = bundle.getLong(WorksFragment.KEY_ANCHOR_UID);
            MLog.info((String)TAG, (String)("anchor uid: " + this.anchorUid));
        }
    }

    public void onLoadmore(RefreshLayout refreshlayout) {
        MLog.info((String)TAG, (String)"load next page");
        ((BaseRequestPresenter)this.getPresenter()).requestData(this.anchorUid, false, this.reqSizeOffset);
    }

    public void onRefresh(RefreshLayout refreshlayout) {
    }

    public void enableLoadMore(boolean enable) {
        if (this.refreshLayout != null) {
            this.refreshLayout.setEnableLoadmore(enable);
        }
    }

    public void onVisibleChange(boolean visible) {
        this.visible = visible;
        MLog.info((String)TAG, (String)(this.getClass().getSimpleName() + " onVisibleChange: " + visible));
        if (this.isFirstVisible && visible) {
            this.onFirstVisible();
        }
    }

    public void onFirstVisible() {
        MLog.info((String)TAG, (String)(this.getClass().getSimpleName() + " onFirstVisible"));
        this.isFirstVisible = false;
    }
}

