/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.view;

import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.profile.view.BarrageItemAnimator;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

public class BarrageView
extends RecyclerView {
    private static final String TAG = "SubtitleAutoPlayView";
    private List<CharSequence> data = new ArrayList<CharSequence>();
    private Adapter adapter;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            if (BarrageView.this.data.isEmpty()) {
                return;
            }
            BarrageView.this.data.remove(0);
            BarrageView.this.adapter.notifyItemRemoved(0);
            BarrageView.this.handler.sendEmptyMessageDelayed(0, 700L);
        }
    };

    public BarrageView(Context context) {
        super(context);
    }

    public BarrageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void animSubtitle(CharSequence content) {
        if (this.data.isEmpty()) {
            return;
        }
        this.data.remove(0);
        this.data.add(content);
        this.adapter.notifyItemRemoved(0);
        MLog.info((String)TAG, (String)("anim subtitle: " + content));
    }

    public void animHide() {
        this.handler.removeCallbacksAndMessages(null);
        this.handler.sendEmptyMessageDelayed(0, 700L);
    }

    public void hide() {
        this.data.clear();
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    public void init() {
        this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        BarrageItemAnimator animator = new BarrageItemAnimator();
        this.setItemAnimator((RecyclerView.ItemAnimator)animator);
        this.setBackgroundColor(Color.parseColor((String)"#00000000"));
        this.handler.removeCallbacksAndMessages(null);
        this.data.clear();
        this.data.add("");
        this.data.add("");
        this.data.add("");
        this.data.add("");
        this.adapter = new Adapter();
        this.setAdapter(this.adapter);
    }

    public void unInit() {
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        return false;
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        public TextView textView;

        ViewHolder(View itemView) {
            super(itemView);
            this.textView = (TextView)itemView.findViewById(R.id.text_view);
        }
    }

    class Adapter
    extends RecyclerView.Adapter<ViewHolder> {
        Adapter() {
        }

        @NonNull
        public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View itemView = LayoutInflater.from((Context)BarrageView.this.getContext()).inflate(R.layout.item_subtitle, parent, false);
            return new ViewHolder(itemView);
        }

        public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
            MLog.info((String)BarrageView.TAG, (String)("onBindViewHolder: " + position));
            CharSequence itemData = (CharSequence)BarrageView.this.data.get(position);
            holder.textView.setText(itemData);
            if (TextUtils.isEmpty((CharSequence)itemData)) {
                holder.textView.setBackgroundResource(0);
            } else {
                holder.textView.setBackgroundResource(R.drawable.subtitle_bg);
            }
        }

        public int getItemCount() {
            MLog.info((String)BarrageView.TAG, (String)("getItemCount: " + BarrageView.this.data.size()));
            return BarrageView.this.data.size();
        }
    }
}

