/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.view;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.Spannable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.richtext.RichTextManager;
import com.yy.mobile.ui.chatemotion.input.BarrageDateMrg;
import com.yy.mobile.ui.profile.view.BarrageView;
import com.yy.mobile.ui.profile.view.IBarragePlay;
import com.yy.mobile.ui.utils.DimensUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class BarragePlayView
extends RelativeLayout
implements IBarragePlay,
BarrageDateMrg.ResultListener {
    private static final String TAG = "BarragePlayView";
    public static final long ANIM_FREQUENCY = 700L;
    public static final int EMOTION_ICON_WIDTH = DimensUtils.dip2pixel((Context)BasicConfig.getInstance().getAppContext(), (float)17.0f);
    private Distributor distributor;
    private BarrageView barrageView;
    private boolean isStartedPlay = false;
    private RichTextManager richTextManager = new RichTextManager();
    private List<RichTextManager.Feature> features = new CopyOnWriteArrayList<RichTextManager.Feature>();
    private Pattern pattern = Pattern.compile("#\\d{2}");

    public BarragePlayView(Context context) {
        super(context);
    }

    public BarragePlayView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.barrage_recycleview, (ViewGroup)this);
        this.barrageView = (BarrageView)this.findViewById(R.id.barrage_recycle);
        this.features.add(RichTextManager.Feature.EMOTICON);
        this.features.add(RichTextManager.Feature.NOBLEEMOTION);
        this.features.add(RichTextManager.Feature.NOBLEGIFEMOTION);
    }

    @Override
    public void startPlay(String pid) {
        this.isStartedPlay = true;
        BarrageDateMrg.Companion.getInstance().requestData(pid, this);
    }

    @Override
    public void pausePlay() {
        if (this.distributor != null) {
            this.distributor.stop();
        }
    }

    @Override
    public void continuePlay() {
        if (this.distributor != null) {
            this.distributor.start(100L);
        }
    }

    @Override
    public void stopPlay() {
        this.isStartedPlay = false;
        if (this.distributor != null) {
            this.distributor.stop();
        }
        if (this.barrageView != null) {
            this.barrageView.hide();
        }
    }

    @Override
    public void animStopPlay() {
        this.isStartedPlay = false;
        if (this.distributor != null) {
            this.distributor.stop();
        }
        if (this.barrageView != null) {
            this.barrageView.animHide();
        }
    }

    @Override
    public boolean isPlaying() {
        return this.distributor != null && this.isStartedPlay && !this.distributor.isStop();
    }

    @Override
    public void onSubtitleReqResult(@NotNull List<String> data, String pid) {
        if (!this.isStartedPlay) {
            MLog.info((String)TAG, (String)"\u6570\u636e\u8bf7\u6c42\u6210\u529f\uff0c \u4f46\u5df2\u505c\u6b62\u64ad\u653e");
            return;
        }
        if (data.size() > 0) {
            MLog.info((String)TAG, (String)("\u6570\u636e\u8bf7\u6c42\u6210\u529f\uff0c \u5f00\u59cb\u64ad\u653e\u5f39\u5e55: " + data));
            if (this.distributor != null) {
                this.distributor.stop();
            }
            this.filterNobleEmotion(data);
            this.barrageView.init();
            this.distributor = new Distributor(data);
            this.distributor.start(0L);
            this.statisticBarrageShown();
        } else {
            MLog.info((String)TAG, (String)"\u6570\u636e\u8bf7\u6c42\u5931\u8d25");
            if (this.distributor != null) {
                this.distributor.stop();
            }
        }
    }

    private void filterNobleEmotion(List<String> data) {
        Iterator<String> iterator = data.iterator();
        while (iterator.hasNext()) {
            String item = iterator.next();
            Matcher matcher = this.pattern.matcher(item);
            if (!matcher.matches()) continue;
            iterator.remove();
        }
    }

    private void statisticBarrageShown() {
        MLog.debug((String)TAG, (String)"statisticBarrageShown");
        ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic("52504", "0008");
    }

    private class Distributor
    extends Handler {
        private List<String> data;
        private int index = 0;
        private boolean stop = true;

        Distributor(List<String> d2) {
            this.data = d2;
        }

        public void start(long delay) {
            this.stop = false;
            this.removeCallbacksAndMessages(null);
            this.sendEmptyMessageDelayed(0, delay);
        }

        public boolean isStop() {
            return this.stop;
        }

        public void stop() {
            this.removeCallbacksAndMessages(null);
            this.stop = true;
        }

        public void handleMessage(Message msg) {
            if (!this.stop) {
                if (this.index >= this.data.size() || this.index < 0) {
                    this.index = 0;
                }
                String content = this.data.get(this.index);
                Spannable span = BarragePlayView.this.richTextManager.getSpannableString(BarragePlayView.this.getContext(), (CharSequence)content, BarragePlayView.this.features, EMOTION_ICON_WIDTH);
                BarragePlayView.this.barrageView.animSubtitle((CharSequence)span);
                ++this.index;
                this.sendEmptyMessageDelayed(0, 700L);
            }
        }
    }
}

