/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewPropertyAnimator;
import android.view.animation.LinearInterpolator;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import java.util.ArrayList;
import java.util.List;

public class BarrageItemAnimator
extends SimpleItemAnimator {
    private static final int ANIMATOR_DURATION = 250;
    private static TimeInterpolator sDefaultInterpolator = new LinearInterpolator();
    private int pendingMoveDeltaY;
    private ArrayList<RecyclerView.ViewHolder> mPendingRemovals = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mPendingAdditions = new ArrayList();
    private ArrayList<MoveInfo> mPendingMoves = new ArrayList();
    ArrayList<ArrayList<RecyclerView.ViewHolder>> mAdditionsList = new ArrayList();
    ArrayList<ArrayList<MoveInfo>> mMovesList = new ArrayList();
    ArrayList<RecyclerView.ViewHolder> mAddAnimations = new ArrayList();
    ArrayList<RecyclerView.ViewHolder> mMoveAnimations = new ArrayList();
    ArrayList<RecyclerView.ViewHolder> mRemoveAnimations = new ArrayList();

    public void runPendingAnimations() {
        View view;
        boolean additionsPending;
        boolean removalsPending = !this.mPendingRemovals.isEmpty();
        boolean movesPending = !this.mPendingMoves.isEmpty();
        boolean bl = additionsPending = !this.mPendingAdditions.isEmpty();
        if (!(removalsPending || movesPending || additionsPending)) {
            return;
        }
        if (movesPending) {
            final ArrayList moves = new ArrayList();
            moves.addAll(this.mPendingMoves);
            this.mMovesList.add(moves);
            this.mPendingMoves.clear();
            Runnable mover = new Runnable(){

                @Override
                public void run() {
                    for (MoveInfo moveInfo : moves) {
                        BarrageItemAnimator.this.animateMoveImpl(moveInfo.holder, moveInfo.fromX, moveInfo.fromY, moveInfo.toX, moveInfo.toY);
                    }
                    moves.clear();
                    BarrageItemAnimator.this.mMovesList.remove(moves);
                }
            };
            if (removalsPending) {
                view = ((MoveInfo)moves.get((int)0)).holder.itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)mover, (long)0L);
            } else {
                mover.run();
            }
        }
        for (RecyclerView.ViewHolder holder : this.mPendingRemovals) {
            this.animateRemoveImpl(holder);
        }
        this.mPendingRemovals.clear();
        if (additionsPending) {
            final ArrayList<RecyclerView.ViewHolder> additions = new ArrayList<RecyclerView.ViewHolder>();
            additions.addAll(this.mPendingAdditions);
            this.mAdditionsList.add(additions);
            this.mPendingAdditions.clear();
            Runnable adder = new Runnable(){

                @Override
                public void run() {
                    for (RecyclerView.ViewHolder holder : additions) {
                        BarrageItemAnimator.this.animateAddImpl(holder);
                    }
                    additions.clear();
                    BarrageItemAnimator.this.mAdditionsList.remove(additions);
                }
            };
            if (removalsPending || movesPending) {
                view = ((RecyclerView.ViewHolder)additions.get((int)0)).itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)adder, (long)0L);
            } else {
                adder.run();
            }
        }
    }

    public boolean animateRemove(RecyclerView.ViewHolder holder) {
        this.resetAnimation(holder);
        this.mPendingRemovals.add(holder);
        return true;
    }

    private void animateRemoveImpl(final RecyclerView.ViewHolder holder) {
        final View view = holder.itemView;
        final ViewPropertyAnimator animation = view.animate();
        this.mRemoveAnimations.add(holder);
        animation.setDuration(250L).translationYBy((float)this.pendingMoveDeltaY).alpha(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                BarrageItemAnimator.this.dispatchRemoveStarting(holder);
            }

            public void onAnimationEnd(Animator animator) {
                animation.setListener(null);
                view.setAlpha(1.0f);
                view.setTranslationY(0.0f);
                BarrageItemAnimator.this.dispatchRemoveFinished(holder);
                BarrageItemAnimator.this.mRemoveAnimations.remove(holder);
                BarrageItemAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
    }

    public boolean animateAdd(RecyclerView.ViewHolder holder) {
        this.resetAnimation(holder);
        holder.itemView.setAlpha(0.0f);
        this.mPendingAdditions.add(holder);
        return true;
    }

    void animateAddImpl(final RecyclerView.ViewHolder holder) {
        final View view = holder.itemView;
        final ViewPropertyAnimator animation = view.animate();
        this.mAddAnimations.add(holder);
        animation.alpha(1.0f).setDuration(250L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                BarrageItemAnimator.this.dispatchAddStarting(holder);
            }

            public void onAnimationCancel(Animator animator) {
                view.setAlpha(1.0f);
            }

            public void onAnimationEnd(Animator animator) {
                animation.setListener(null);
                BarrageItemAnimator.this.dispatchAddFinished(holder);
                BarrageItemAnimator.this.mAddAnimations.remove(holder);
                BarrageItemAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
    }

    public boolean animateMove(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        View view = holder.itemView;
        this.resetAnimation(holder);
        int deltaX = toX - (fromX += (int)holder.itemView.getTranslationX());
        int deltaY = toY - (fromY += (int)holder.itemView.getTranslationY());
        if (deltaX == 0 && deltaY == 0) {
            this.dispatchMoveFinished(holder);
            return false;
        }
        if (deltaX != 0) {
            view.setTranslationX((float)(-deltaX));
        }
        if (deltaY != 0) {
            view.setTranslationY((float)(-deltaY));
        }
        this.pendingMoveDeltaY = deltaY;
        this.mPendingMoves.add(new MoveInfo(holder, fromX, fromY, toX, toY));
        return true;
    }

    public boolean animateChange(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder, int fromLeft, int fromTop, int toLeft, int toTop) {
        return false;
    }

    void animateMoveImpl(final RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        final View view = holder.itemView;
        final int deltaX = toX - fromX;
        final int deltaY = toY - fromY;
        if (deltaX != 0) {
            view.animate().translationX(0.0f);
        }
        if (deltaY != 0) {
            view.animate().translationY(0.0f);
        }
        final ViewPropertyAnimator animation = view.animate();
        this.mMoveAnimations.add(holder);
        animation.setDuration(250L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                BarrageItemAnimator.this.dispatchMoveStarting(holder);
            }

            public void onAnimationCancel(Animator animator) {
                if (deltaX != 0) {
                    view.setTranslationX(0.0f);
                }
                if (deltaY != 0) {
                    view.setTranslationY(0.0f);
                }
            }

            public void onAnimationEnd(Animator animator) {
                animation.setListener(null);
                BarrageItemAnimator.this.dispatchMoveFinished(holder);
                BarrageItemAnimator.this.mMoveAnimations.remove(holder);
                BarrageItemAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
    }

    public void endAnimation(RecyclerView.ViewHolder item) {
        int i;
        View view = item.itemView;
        view.animate().cancel();
        for (i = this.mPendingMoves.size() - 1; i >= 0; --i) {
            MoveInfo moveInfo = this.mPendingMoves.get(i);
            if (moveInfo.holder != item) continue;
            view.setTranslationY(0.0f);
            view.setTranslationX(0.0f);
            this.dispatchMoveFinished(item);
            this.mPendingMoves.remove(i);
        }
        if (this.mPendingRemovals.remove(item)) {
            view.setAlpha(1.0f);
            this.dispatchRemoveFinished(item);
        }
        if (this.mPendingAdditions.remove(item)) {
            view.setAlpha(1.0f);
            this.dispatchAddFinished(item);
        }
        block1: for (i = this.mMovesList.size() - 1; i >= 0; --i) {
            ArrayList<MoveInfo> moves = this.mMovesList.get(i);
            for (int j = moves.size() - 1; j >= 0; --j) {
                MoveInfo moveInfo = moves.get(j);
                if (moveInfo.holder != item) continue;
                view.setTranslationY(0.0f);
                view.setTranslationX(0.0f);
                this.dispatchMoveFinished(item);
                moves.remove(j);
                if (!moves.isEmpty()) continue block1;
                this.mMovesList.remove(i);
                continue block1;
            }
        }
        for (i = this.mAdditionsList.size() - 1; i >= 0; --i) {
            ArrayList<RecyclerView.ViewHolder> additions = this.mAdditionsList.get(i);
            if (!additions.remove(item)) continue;
            view.setAlpha(1.0f);
            this.dispatchAddFinished(item);
            if (!additions.isEmpty()) continue;
            this.mAdditionsList.remove(i);
        }
        if (this.mRemoveAnimations.remove(item)) {
            throw new IllegalStateException("after animation is cancelled, item should not be in mRemoveAnimations list");
        }
        if (this.mAddAnimations.remove(item)) {
            throw new IllegalStateException("after animation is cancelled, item should not be in mAddAnimations list");
        }
        if (this.mMoveAnimations.remove(item)) {
            throw new IllegalStateException("after animation is cancelled, item should not be in mMoveAnimations list");
        }
        this.dispatchFinishedWhenDone();
    }

    private void resetAnimation(RecyclerView.ViewHolder holder) {
        if (sDefaultInterpolator == null) {
            sDefaultInterpolator = new ValueAnimator().getInterpolator();
        }
        holder.itemView.animate().setInterpolator(sDefaultInterpolator);
        this.endAnimation(holder);
    }

    public boolean isRunning() {
        return !this.mPendingAdditions.isEmpty() || !this.mPendingMoves.isEmpty() || !this.mPendingRemovals.isEmpty() || !this.mMoveAnimations.isEmpty() || !this.mRemoveAnimations.isEmpty() || !this.mAddAnimations.isEmpty() || !this.mMovesList.isEmpty() || !this.mAdditionsList.isEmpty();
    }

    void dispatchFinishedWhenDone() {
        if (!this.isRunning()) {
            this.dispatchAnimationsFinished();
        }
    }

    public void endAnimations() {
        int j;
        int i;
        MoveInfo item;
        int i2;
        int count = this.mPendingMoves.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            item = this.mPendingMoves.get(i2);
            View view = item.holder.itemView;
            view.setTranslationY(0.0f);
            view.setTranslationX(0.0f);
            this.dispatchMoveFinished(item.holder);
            this.mPendingMoves.remove(i2);
        }
        count = this.mPendingRemovals.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            item = this.mPendingRemovals.get(i2);
            this.dispatchRemoveFinished((RecyclerView.ViewHolder)item);
            this.mPendingRemovals.remove(i2);
        }
        count = this.mPendingAdditions.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            item = this.mPendingAdditions.get(i2);
            ((RecyclerView.ViewHolder)item).itemView.setAlpha(1.0f);
            this.dispatchAddFinished((RecyclerView.ViewHolder)item);
            this.mPendingAdditions.remove(i2);
        }
        if (!this.isRunning()) {
            return;
        }
        int listCount = this.mMovesList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<MoveInfo> moves = this.mMovesList.get(i);
            count = moves.size();
            for (j = count - 1; j >= 0; --j) {
                MoveInfo moveInfo = moves.get(j);
                RecyclerView.ViewHolder item2 = moveInfo.holder;
                View view = item2.itemView;
                view.setTranslationY(0.0f);
                view.setTranslationX(0.0f);
                this.dispatchMoveFinished(moveInfo.holder);
                moves.remove(j);
                if (!moves.isEmpty()) continue;
                this.mMovesList.remove(moves);
            }
        }
        listCount = this.mAdditionsList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<RecyclerView.ViewHolder> additions = this.mAdditionsList.get(i);
            count = additions.size();
            for (j = count - 1; j >= 0; --j) {
                RecyclerView.ViewHolder item3 = additions.get(j);
                View view = item3.itemView;
                view.setAlpha(1.0f);
                this.dispatchAddFinished(item3);
                additions.remove(j);
                if (!additions.isEmpty()) continue;
                this.mAdditionsList.remove(additions);
            }
        }
        this.cancelAll(this.mRemoveAnimations);
        this.cancelAll(this.mMoveAnimations);
        this.cancelAll(this.mAddAnimations);
        this.dispatchAnimationsFinished();
    }

    void cancelAll(List<RecyclerView.ViewHolder> viewHolders) {
        for (int i = viewHolders.size() - 1; i >= 0; --i) {
            viewHolders.get((int)i).itemView.animate().cancel();
        }
    }

    public boolean canReuseUpdatedViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, @NonNull List<Object> payloads) {
        return !payloads.isEmpty() || super.canReuseUpdatedViewHolder(viewHolder, payloads);
    }

    private static class MoveInfo {
        public RecyclerView.ViewHolder holder;
        public int fromX;
        public int fromY;
        public int toX;
        public int toY;

        MoveInfo(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
            this.holder = holder;
            this.fromX = fromX;
            this.fromY = fromY;
            this.toX = toX;
            this.toY = toY;
        }
    }
}

