/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.user;

import android.content.Context;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ScrollView;
import android.widget.TextView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshScrollView;
import com.trello.rxlifecycle3.android.FragmentEvent;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onDeleteMobileLiveReplayHistories_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveLinkClient_onGetReplayNum_EventArgs;
import com.yy.mobile.plugin.main.events.IProfileClient_onRequestProfile_EventArgs;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestDetailUserInfo_EventArgs;
import com.yy.mobile.plugin.main.events.IUserInfoClient_onGalleryInfoRsp_EventArgs;
import com.yy.mobile.plugin.main.events.IUserInfoClient_onQupaiInfoRsp_EventArgs;
import com.yy.mobile.plugin.main.events.IUserInfoClient_onShenquInfoRsp_EventArgs;
import com.yy.mobile.plugin.main.events.IUserInfoClient_onTieziInfoRsp_EventArgs;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.profile.user.UserInfoFragment$$EventBinder;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.widget.NoBrTextView;
import com.yy.mobile.ui.widget.extend.RxViewExt;
import com.yy.mobile.ui.widget.headerviewpager.ScrollViewDelegate;
import com.yy.mobile.ui.widget.headerviewpager.ScrollableListener;
import com.yy.mobile.ui.widget.headerviewpager.ViewDelegate;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreError;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.moment.MomentCategory;
import com.yymobile.core.moment.request.MomentCountQueryAction;
import com.yymobile.core.profile.EntUserInfo;
import com.yymobile.core.profile.IProfileCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.user.IUserInfoCore;
import com.yymobile.core.user.UserInfo;
import com.yyproto.db.DCImpl;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.util.Map;

public class UserInfoFragment
extends BaseLinkFragment
implements ScrollableListener<ScrollView>,
View.OnClickListener {
    public static final String UID = "EXTRA_UID";
    private static final String TAG = "UserInfoFragment";
    private View view;
    private ScrollViewDelegate mViewDelegate = new ScrollViewDelegate();
    private PullToRefreshScrollView docScrollView;
    private View qupaiLayout;
    private View mPhotoCenter;
    private View mMomentLayout;
    private TextView qupaiNum;
    private TextView mPhotoCenterNum;
    private TextView mMomentNum;
    private View liveReplayLayout;
    private TextView liveReplayNum;
    private View tieziLayout;
    private TextView tieziNum;
    private View shenquLayout;
    private TextView shenquNum;
    private NoBrTextView signatureTxt;
    private long userId = 0L;
    private String qupaiUrl = "";
    private String tieziUrl = "";
    private String shenquUrl = "";
    private String galleryUrl = "";
    private int shenquCount = 0;
    private boolean isAnchor = false;
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();
    private EventBinder mEventBinder;

    public static UserInfoFragment newInstance(long uid) {
        UserInfoFragment fragment = new UserInfoFragment();
        Bundle bundle = new Bundle();
        bundle.putLong(UID, uid);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.userId = this.getArguments().getLong(UID);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.view = inflater.inflate(R.layout.fragment_user_info, container, false);
        this.initView();
        return this.view;
    }

    private void initView() {
        EntUserInfo userInfo;
        this.docScrollView = (PullToRefreshScrollView)this.view.findViewById(R.id.userinfo_scrollview);
        this.docScrollView.setMode(PullToRefreshBase.Mode.DISABLED);
        this.signatureTxt = (NoBrTextView)this.view.findViewById(R.id.signature);
        this.mMomentLayout = this.view.findViewById(R.id.moment_layout);
        this.mMomentNum = (TextView)this.view.findViewById(R.id.moment_num);
        RxViewExt.safelyClicks((View)this.mMomentLayout, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                if (UserInfoFragment.this.isAnchor) {
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50601", "0001");
                } else {
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50701", "0001");
                }
                NavigationUtils.toMomentListActivity((Context)UserInfoFragment.this.getActivity(), MomentCategory.MOMENT_SINGLE_LIST((long)UserInfoFragment.this.userId));
            }
        });
        this.mPhotoCenter = this.view.findViewById(R.id.photocenter_layout);
        this.mPhotoCenterNum = (TextView)this.view.findViewById(R.id.photocenter_num);
        this.mPhotoCenter.setOnClickListener((View.OnClickListener)this);
        this.qupaiLayout = this.view.findViewById(R.id.qupai_layout);
        this.qupaiNum = (TextView)this.view.findViewById(R.id.qupai_num);
        RxViewExt.safelyClicks((View)this.qupaiLayout, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1701", "0003");
                if (!StringUtils.isEmpty((String)UserInfoFragment.this.qupaiUrl).booleanValue()) {
                    ARouter.getInstance().build(Uri.parse((String)UserInfoFragment.this.qupaiUrl)).navigation((Context)UserInfoFragment.this.getActivity());
                }
            }
        });
        this.liveReplayLayout = this.view.findViewById(R.id.live_replay_layout);
        this.liveReplayNum = (TextView)this.view.findViewById(R.id.live_replay_num);
        RxViewExt.safelyClicks((View)this.liveReplayLayout, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1701", "0010");
                NavigationUtils.toMobileLivePersonalReplayActivity(UserInfoFragment.this.getContext(), UserInfoFragment.this.userId);
            }
        });
        this.tieziLayout = this.view.findViewById(R.id.tiezi_layout);
        this.tieziLayout.setVisibility(8);
        this.tieziNum = (TextView)this.view.findViewById(R.id.tiezi_num);
        RxViewExt.safelyClicks((View)this.tieziLayout, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                if (!StringUtils.isEmpty((String)UserInfoFragment.this.tieziUrl).booleanValue()) {
                    ARouter.getInstance().build(Uri.parse((String)UserInfoFragment.this.tieziUrl)).navigation((Context)UserInfoFragment.this.getActivity());
                }
            }
        });
        this.shenquLayout = this.view.findViewById(R.id.shenqu_layout);
        this.shenquNum = (TextView)this.view.findViewById(R.id.shenqu_num);
        RxViewExt.safelyClicks((View)this.shenquLayout, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                if (!StringUtils.isEmpty((String)UserInfoFragment.this.shenquUrl).booleanValue()) {
                    if (UserInfoFragment.this.shenquCount > 0) {
                        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("0211", "0001");
                    }
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("1701", "0002");
                    ARouter.getInstance().build(Uri.parse((String)UserInfoFragment.this.shenquUrl)).navigation((Context)UserInfoFragment.this.getActivity());
                }
            }
        });
        ((IUserInfoCore)CoreManager.getCore(IUserInfoCore.class)).requestQupaiInfo(this.userId);
        ((IUserInfoCore)CoreManager.getCore(IUserInfoCore.class)).requestTieziInfo(this.userId);
        ((IUserInfoCore)CoreManager.getCore(IUserInfoCore.class)).requestShenquInfo(this.userId);
        ((IUserInfoCore)CoreManager.getCore(IUserInfoCore.class)).requesetGalleryInfo(this.userId);
        ((IMobileLiveCore)CoreManager.getCore(IMobileLiveCore.class)).getReplayNum(this.userId);
        UserInfo mCacheInfo = CoreManager.getUserCore().getCacheUserInfoByUid(this.userId);
        if (mCacheInfo != null) {
            this.onQueryUserInfo(this.userId, mCacheInfo, true, null);
        }
        if ((userInfo = ((IProfileCore)CoreManager.getCore(IProfileCore.class)).getCachedProfileInfo(this.userId)) == null) {
            ((IProfileCore)CoreManager.getCore(IProfileCore.class)).requestProfile(this.userId);
        } else {
            this.isAnchor = userInfo.userType == 1;
        }
    }

    public void onResume() {
        super.onResume();
        YYStore.INSTANCE.dispatchWithError((ReqAction)new MomentCountQueryAction(DCImpl.getUserId())).flatMap((Function)new Function<Single<Integer>, SingleSource<Integer>>(){

            public SingleSource<Integer> apply(Single<Integer> integerSingle) throws Exception {
                return integerSingle;
            }
        }).compose((SingleTransformer)this.bindUntilEvent(FragmentEvent.DESTROY)).subscribe((Consumer)new Consumer<Integer>(){

            public void accept(Integer integer) throws Exception {
                UserInfoFragment.this.mMomentNum.setText((CharSequence)("(" + integer + ")"));
            }
        }, RxUtils.errorConsumer((String)TAG));
    }

    @BusEvent
    public void onRequestDetailUserInfo(IUserClient_onRequestDetailUserInfo_EventArgs busEventArgs) {
        long userid = busEventArgs.getUserId();
        UserInfo info = busEventArgs.getInfo();
        boolean isLocalData = busEventArgs.getIsLocalData();
        CoreError error = busEventArgs.getError();
        this.onQueryUserInfo(userid, info, isLocalData, error);
    }

    private void onQueryUserInfo(long uid, UserInfo info, boolean isLocalData, CoreError error) {
        if (this.userId != uid || info == null || error != null) {
            MLog.error((String)TAG, (String)("onQueryUserInfo error=" + error));
            return;
        }
        if (StringUtils.isEmpty((String)info.signature).booleanValue()) {
            info.signature = "\u65e0";
        }
        this.signatureTxt.setTextSpanColor(0, 6, Color.parseColor((String)"#8A000000"));
        this.signatureTxt.setText((CharSequence)("\u4e2a\u6027\u7b7e\u540d:  " + info.signature));
    }

    @BusEvent
    public void onQupaiInfoRsp(IUserInfoClient_onQupaiInfoRsp_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long uid = busEventArgs.getUid();
        String url = busEventArgs.getUrl();
        Map contentInfo = busEventArgs.getContentInfo();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("\u77ed\u7247\u6570\u67e5\u8be2\u7ed3\u679c: " + contentInfo));
        }
        if (this.userId == uid && result == 0) {
            this.qupaiUrl = url;
            if (contentInfo != null && contentInfo.containsKey("count")) {
                String countStr = (String)contentInfo.get("count");
                int count = 0;
                if (!StringUtils.isEmpty((String)countStr).booleanValue()) {
                    count = Integer.parseInt(countStr);
                }
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((String)TAG, (String)("\u77ed\u62cd\u6570: " + count));
                }
                this.qupaiNum.setText((CharSequence)("(" + count + ")"));
            }
        }
    }

    @BusEvent
    public void onTieziInfoRsp(IUserInfoClient_onTieziInfoRsp_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long uid = busEventArgs.getUid();
        String url = busEventArgs.getUrl();
        Map contentInfo = busEventArgs.getContentInfo();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("\u5e16\u5b50\u6570\u67e5\u8be2\u7ed3\u679c: " + contentInfo));
        }
        if (this.userId == uid && result == 0) {
            this.tieziUrl = url;
            if (contentInfo != null && contentInfo.containsKey("count")) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((String)TAG, (String)("\u5e16\u5b50\u6570: " + (String)contentInfo.get("count")));
                }
                this.tieziNum.setText((CharSequence)("(" + (String)contentInfo.get("count") + ")"));
            }
        }
    }

    @BusEvent
    public void onShenquInfoRsp(IUserInfoClient_onShenquInfoRsp_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long uid = busEventArgs.getUid();
        String url = busEventArgs.getUrl();
        Map contentInfo = busEventArgs.getContentInfo();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("\u795e\u66f2\u6570\u67e5\u8be2\u7ed3\u679c: " + contentInfo));
        }
        if (this.isResumed() && this.userId == uid && result == 0) {
            this.shenquUrl = url;
            if (contentInfo != null && contentInfo.containsKey("count")) {
                String countStr = (String)contentInfo.get("count");
                if (!StringUtils.isEmpty((String)countStr).booleanValue()) {
                    this.shenquCount = Integer.parseInt(countStr);
                }
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((String)TAG, (String)("\u795e\u66f2\u6570: " + this.shenquCount));
                }
                this.shenquNum.setText((CharSequence)("(" + this.shenquCount + ")"));
            }
        }
    }

    @BusEvent
    public void onGalleryInfoRsp(IUserInfoClient_onGalleryInfoRsp_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long uid = busEventArgs.getUid();
        String url = busEventArgs.getUrl();
        Map contentInfo = busEventArgs.getContentInfo();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("\u76f8\u518c\u6570\u67e5\u8be2\u7ed3\u679c: " + contentInfo));
        }
        if (this.userId == uid && result == 0) {
            this.galleryUrl = url;
            if (contentInfo != null && contentInfo.containsKey("count")) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((String)TAG, (String)("\u76f8\u518c\u6570: " + (String)contentInfo.get("count")));
                }
                this.mPhotoCenterNum.setText((CharSequence)("(" + (String)contentInfo.get("count") + ")"));
            }
        }
    }

    public ViewDelegate<ScrollView> getViewDelegate() {
        return this.mViewDelegate;
    }

    public ScrollView getDelegateView() {
        return (ScrollView)this.docScrollView.getRefreshableView();
    }

    public void onClick(View v) {
        if (this.mTimeSlotTool.isProcessing()) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.photocenter_layout) {
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1701", "0009");
            if (!StringUtils.isEmpty((String)this.galleryUrl).booleanValue()) {
                ARouter.getInstance().build(Uri.parse((String)this.galleryUrl)).navigation((Context)this.getActivity());
            } else {
                long loginUserId = LoginUtil.getUid();
                if (this.userId != 0L && this.userId != loginUserId) {
                    if (this.isAnchor) {
                        NavigationUtils.toPersonPage((Context)this.getActivity(), this.userId, 3);
                    } else {
                        NavigationUtils.toUserGallery((Context)this.getActivity(), this.userId, false);
                    }
                } else if (LoginUtil.isLogined()) {
                    NavigationUtils.toUserGallery((Context)this.getActivity(), loginUserId, false);
                } else {
                    NavigationUtils.toLogin(this.getContext(), true, false);
                }
            }
        }
    }

    @BusEvent
    public void onRequestProfile(IProfileClient_onRequestProfile_EventArgs busEventArgs) {
        EntUserInfo info = busEventArgs.getInfo();
        if (info == null) {
            return;
        }
        this.isAnchor = info.userType == 1;
    }

    @BusEvent
    public void onGetReplayNum(IMobileLiveLinkClient_onGetReplayNum_EventArgs busEventArgs) {
        long uid = busEventArgs.getUid();
        int count = busEventArgs.getCount();
        if (uid == this.userId && this.liveReplayNum != null) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((String)TAG, (String)("\u56de\u653e\u6570: " + count));
            }
            this.liveReplayNum.setText((CharSequence)("(" + count + ")"));
        }
    }

    @BusEvent
    public void onDeleteMobileLiveReplayHistories(IMobileLiveClient_onDeleteMobileLiveReplayHistories_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        if (result == 0) {
            ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).getReplayNum(this.userId);
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new UserInfoFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

