/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.user;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import androidx.fragment.app.Fragment;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseDarkModeActivity;
import com.yy.mobile.ui.common.IBaseMethod;
import com.yy.mobile.ui.profile.anchor.AnchorGalleryFragment;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.util.log.MLog;

public class UserGalleryActivity
extends BaseDarkModeActivity
implements IBaseMethod {
    private static final String TAG = "UserGalleryActivity";
    private SimpleTitleBar simpleTitleBar;
    private long userId;
    private AnchorGalleryFragment mFragment;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_user_gallery);
        this.injectView();
        this.init();
        if (savedInstanceState == null) {
            this.mFragment = AnchorGalleryFragment.newInstance(this.userId);
            this.getSupportFragmentManager().beginTransaction().replace(R.id.user_gallery_framelayout, (Fragment)this.mFragment).commitAllowingStateLoss();
        }
        this.setListener();
    }

    public void injectView() {
        this.simpleTitleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
    }

    public void setListener() {
    }

    public void init() {
        this.initIntent();
        this.initTitleBar();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        MLog.info((String)TAG, (String)"onActivityResult");
        if (this.mFragment != null) {
            this.mFragment.onActivityResult(requestCode, resultCode, data);
        }
    }

    protected void onDestroy() {
        if (this.mFragment != null) {
            this.mFragment = null;
        }
        super.onDestroy();
    }

    public void initTitleBar() {
        if (this.userId != LoginUtil.getUid()) {
            this.simpleTitleBar.setTitlte("TA\u7684\u76f8\u518c");
        } else {
            this.simpleTitleBar.setTitlte("\u6211\u7684\u76f8\u518c");
        }
        this.simpleTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                UserGalleryActivity.this.finish();
            }
        });
    }

    private void initIntent() {
        if (this.getIntent() != null) {
            this.userId = this.getIntent().getLongExtra("userId", -1L);
        }
    }
}

