/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.user;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IArtistClient_onBatchQueryFansNumRsp_EventArgs;
import com.yy.mobile.plugin.main.events.ICommonsubscribeClient_onQueryCommonSubscribeListRsp_EventArgs;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestBasicUserInfo_EventArgs;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.profile.user.CommonPointAdapter;
import com.yy.mobile.ui.profile.user.CommonPointFragment$$EventBinder;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.BlankUtil;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.CoreError;
import com.yymobile.core.CoreManager;
import com.yymobile.core.artist.IArtistCore;
import com.yymobile.core.commonsubscribe.CommonsubscribeProtocol;
import com.yymobile.core.commonsubscribe.ICommonsubscribeCore;
import com.yymobile.core.user.IUserCore;
import com.yymobile.core.user.UserInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommonPointFragment
extends BaseLinkFragment {
    private static final String TAG = "CommonPointFragment";
    private View mRoot;
    private SimpleTitleBar titleBar;
    private StatusLayout statusLayout;
    private PullToRefreshListView mListView;
    private CommonPointAdapter mAdapter;
    private static final int TIME_OUT_MILLIS = 10000;
    private List<Long> uids = new ArrayList<Long>();
    private boolean isLastPage = false;
    private int pageSize = 20;
    private Map<Long, Uint32> authVMap = new HashMap<Long, Uint32>();
    private Map<Long, Integer> isLivingMap = new HashMap<Long, Integer>();
    private long mUid;
    private long objectUid;
    private EndlessListScrollListener mEndlessListScrollListener;
    private boolean shouldClear = false;
    private int pageNo = 1;
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();
    private Runnable checkRequestTimeoutTask = new Runnable(){

        @Override
        public void run() {
            CommonPointFragment.this.hideStatus();
            CommonPointFragment.this.mListView.onRefreshComplete();
            CommonPointFragment.this.mEndlessListScrollListener.onLoadComplete();
            if (FP.empty(CommonPointFragment.this.mAdapter.getData())) {
                CommonPointFragment.this.showReload(CommonPointFragment.this.mRoot, R.drawable.icon_error_newstyle, R.string.click_screen_reload);
            }
        }
    };
    AdapterView.OnItemClickListener onItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
            if (CommonPointFragment.this.mTimeSlotTool.isProcessing()) {
                return;
            }
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)"UserFansListFragment", (String)("position = " + position));
            }
            try {
                if (CommonPointFragment.this.mAdapter != null && CommonPointFragment.this.mListView != null && CommonPointFragment.this.mAdapter.getCount() > 0 && position > 0 && position - ((ListView)CommonPointFragment.this.mListView.getRefreshableView()).getHeaderViewsCount() >= 0) {
                    CommonPointFragment.this.showUserInfo(position - ((ListView)CommonPointFragment.this.mListView.getRefreshableView()).getHeaderViewsCount(), "\u6b63\u5728\u5904\u7406");
                }
            }
            catch (Throwable throwable) {
                MLog.error((Object)CommonPointFragment.TAG, (Throwable)throwable);
            }
        }
    };
    private EventBinder mEventBinder;

    public static CommonPointFragment newInstance() {
        CommonPointFragment fragment = new CommonPointFragment();
        return fragment;
    }

    public static CommonPointFragment newInstance(long uid, long objectUid) {
        CommonPointFragment fragment = new CommonPointFragment();
        Bundle args = new Bundle();
        args.putLong("uid", uid);
        args.putLong("objectUid", objectUid);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mUid = bundle.getLong("uid", 0L);
            this.objectUid = bundle.getLong("objectUid", 0L);
        }
        if (this.mUid <= 0L || this.objectUid <= 0L) {
            this.getActivity().finish();
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRoot = inflater.inflate(R.layout.fragment_common_point, container, false);
        if (!this.isNetworkAvailable()) {
            this.showReload(this.mRoot, R.drawable.icon_error_newstyle, R.string.click_screen_reload);
        } else {
            this.showLoading(this.mRoot, 0, 0);
            this.shouldClear = true;
            this.pageNo = 0;
        }
        this.initView();
        this.requestCommonSubscribe(this.mUid, this.objectUid, this.pageNo, this.pageSize);
        return this.mRoot;
    }

    void initView() {
        this.titleBar = (SimpleTitleBar)this.mRoot.findViewById(R.id.title_bar);
        this.titleBar.setTitlte("\u5171\u540c\u5173\u6ce8");
        this.titleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                CommonPointFragment.this.getActivity().finish();
            }
        });
        this.statusLayout = (StatusLayout)this.mRoot.findViewById(R.id.status_layout);
        this.mListView = (PullToRefreshListView)this.mRoot.findViewById(R.id.lv_list);
        this.mListView.setMode(PullToRefreshBase.Mode.PULL_FROM_START);
        this.mListView.setScrollingWhileRefreshingEnabled(true);
        this.mAdapter = new CommonPointAdapter((Activity)this.getActivity());
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        ((ListView)this.mListView.getRefreshableView()).setOnItemClickListener(this.onItemClickListener);
        this.mListView.setOnRefreshListener((PullToRefreshBase.OnRefreshListener2)new PullToRefreshBase.OnRefreshListener2<ListView>(){

            public void onPullDownToRefresh(PullToRefreshBase<ListView> refreshView) {
                if (!CommonPointFragment.this.checkNetToast()) {
                    CommonPointFragment.this.getHandler().post(CommonPointFragment.this.checkRequestTimeoutTask);
                } else {
                    CommonPointFragment.this.shouldClear = true;
                    CommonPointFragment.this.pageNo = 0;
                    CommonPointFragment.this.isLastPage = false;
                    CommonPointFragment.this.requestCommonSubscribe(CommonPointFragment.this.mUid, CommonPointFragment.this.objectUid, CommonPointFragment.this.pageNo, CommonPointFragment.this.pageSize);
                }
            }

            public void onPullUpToRefresh(PullToRefreshBase<ListView> refreshView) {
            }
        });
        this.mEndlessListScrollListener = new EndlessListScrollListener((StatusLayout)this.mRoot.findViewById(R.id.status_layout));
        this.mEndlessListScrollListener.setListener(new EndlessListScrollListener.EndlessListener(){

            public void onLoadData() {
                CommonPointFragment.this.shouldClear = false;
                CommonPointFragment.this.pageNo++;
                CommonPointFragment.this.requestCommonSubscribe(CommonPointFragment.this.mUid, CommonPointFragment.this.objectUid, CommonPointFragment.this.pageNo, CommonPointFragment.this.pageSize);
            }

            public boolean shouldLoadData() {
                if (CommonPointFragment.this.isLastPage || !CommonPointFragment.this.isNetworkAvailable()) {
                    CommonPointFragment.this.getHandler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            CommonPointFragment.this.mEndlessListScrollListener.onLoadComplete();
                        }
                    }, 500L);
                    return false;
                }
                return true;
            }
        });
        this.mListView.setOnScrollListener((AbsListView.OnScrollListener)this.mEndlessListScrollListener);
    }

    public boolean isNetworkAvailable() {
        return NetworkUtils.isNetworkStrictlyAvailable((Context)this.getContext());
    }

    @SuppressLint(value={"ToastUsage"})
    public boolean checkNetToast() {
        boolean falg = this.isNetworkAvailable();
        if (this.checkActivityValid() && !falg && this.getContext() != null) {
            Toast.makeText((Context)this.getContext(), (int)R.string.str_network_not_capable, (int)0).show();
        }
        return falg;
    }

    private void requestCommonSubscribe(long uid, long objectUid, int pageNo, int pageSize) {
        ((ICommonsubscribeCore)CoreManager.getCore(ICommonsubscribeCore.class)).queryCommonSubscribeList(uid, objectUid, pageNo, pageSize);
        this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        this.getHandler().postDelayed(this.checkRequestTimeoutTask, 10000L);
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onQueryCommonSubscribeListRsp(ICommonsubscribeClient_onQueryCommonSubscribeListRsp_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long uid = busEventArgs.getUid();
        long objectId = busEventArgs.getObjectId();
        List anchorList = busEventArgs.getAnchorList();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)"yangnanqing", (String)"onQueryCommonSubscribeListRsp");
        }
        if (uid == this.mUid && objectId == this.objectUid) {
            this.hideStatus();
            this.mListView.onRefreshComplete();
            this.mEndlessListScrollListener.onLoadComplete();
            this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
            if (result != 0) {
                if (this.mAdapter == null || this.mAdapter.getCount() <= 0) {
                    this.showReload(R.drawable.icon_error_newstyle, R.string.click_screen_reload);
                }
            } else if (BlankUtil.isBlank((Collection)anchorList)) {
                if (this.mAdapter.getData().size() == 0) {
                    this.showNoData(R.drawable.icon_no_anchors_newstyle, "\u4f60\u4eec\u6ca1\u6709\u5171\u540c\u5173\u6ce8");
                }
            } else {
                if (anchorList.size() < this.pageSize) {
                    this.isLastPage = true;
                }
                ArrayList<Long> uidStrList = new ArrayList<Long>();
                ArrayList<Uint32> uidList = new ArrayList<Uint32>();
                for (int i = 0; i < anchorList.size(); ++i) {
                    String uidStr = (String)((Map)anchorList.get(i)).get(CommonsubscribeProtocol.PCommonSubscribeRsp.ITEM_UID);
                    String anchorV = (String)((Map)anchorList.get(i)).get(CommonsubscribeProtocol.PCommonSubscribeRsp.ITEM_AUTH_V);
                    Integer isLiving = Integer.parseInt((String)((Map)anchorList.get(i)).get(CommonsubscribeProtocol.PCommonSubscribeRsp.ITEM_ISLIVING));
                    if (StringUtils.isEmpty((String)uidStr).booleanValue()) {
                        this.uids.add(0L);
                        uidStrList.add(0L);
                        this.isLivingMap.put(0L, isLiving);
                        uidList.add(new Uint32(0));
                    } else {
                        this.uids.add(Long.parseLong(uidStr));
                        uidStrList.add(Long.parseLong(uidStr));
                        this.isLivingMap.put(0L, isLiving);
                        uidList.add(new Uint32(uidStr));
                    }
                    if (StringUtils.isEmpty((String)anchorV).booleanValue()) continue;
                    this.authVMap.put(Long.parseLong(uidStr), new Uint32(anchorV));
                }
                ((IUserCore)CoreManager.getCore(IUserCore.class)).requestBasicUserInfo(uidStrList, false);
                ((IArtistCore)CoreManager.getCore(IArtistCore.class)).batchQueryFansNum(this.mUid, uidList);
            }
        }
    }

    @BusEvent
    public void onRequestBasicUserInfo(IUserClient_onRequestBasicUserInfo_EventArgs busEventArgs) {
        List userIdList = busEventArgs.getUserIdList();
        List userInfoList = busEventArgs.getUserInfoList();
        boolean isLocalData = busEventArgs.getIsLocalData();
        CoreError error = busEventArgs.getError();
        String ctx = busEventArgs.getCtx();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("onRequestBasicUserInfo userIdList = " + userIdList.size() + " userInfoList = " + userInfoList.size()));
        }
        if (error == null && this.isResumed() && this.uids.containsAll(userIdList)) {
            this.uids.removeAll(userIdList);
            this.updateData(userInfoList);
        }
    }

    @BusEvent
    public void onBatchQueryFansNumRsp(IArtistClient_onBatchQueryFansNumRsp_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long uid = busEventArgs.getUid();
        Map fansnumlist = busEventArgs.getFansnumlist();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("onBatchQueryFansNumRsp uid = " + uid + " fansnumlist = " + fansnumlist.toString()));
        }
        if (this.mUid == uid && result == 0) {
            this.mAdapter.fansnumlist = fansnumlist;
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private synchronized void updateData(List<UserInfo> userList) {
        this.mAdapter.isLivingmap = this.isLivingMap;
        this.mAdapter.authVMap = this.authVMap;
        if (this.shouldClear) {
            this.mAdapter.setData(userList);
        } else {
            this.mAdapter.addData(userList);
        }
        this.mListView.onRefreshComplete();
        this.mEndlessListScrollListener.onLoadComplete();
    }

    public void showUserInfo(int position, String text) {
        if (!this.checkNetToast() || !this.checkActivityValid()) {
            return;
        }
        UserInfo info = this.mAdapter.getItem(position);
        if (info == null) {
            return;
        }
        NavigationUtils.toPersonPage((Context)this.getActivity(), info.userId);
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new CommonPointFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

