/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.user;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.home.FaceHelperFactory;
import com.yy.mobile.util.FaceHelper;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.user.UserInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommonPointAdapter
extends BaseAdapter {
    private Activity context;
    private List<UserInfo> mData = new ArrayList<UserInfo>();
    public Map<Uint32, Uint32> fansnumlist = new HashMap<Uint32, Uint32>();
    public Map<Long, Uint32> authVMap = new HashMap<Long, Uint32>();
    public Map<Long, Integer> isLivingmap = new HashMap<Long, Integer>();

    public CommonPointAdapter(Activity context) {
        this.context = context;
    }

    public void addData(List<UserInfo> data) {
        if (data != null && data.size() > 0) {
            this.mData.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public void setData(List<UserInfo> data) {
        this.mData.clear();
        if (data != null && data.size() > 0) {
            this.mData.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public List<UserInfo> getData() {
        return this.mData;
    }

    public int getCount() {
        return this.mData.size();
    }

    public UserInfo getItem(int position) {
        return this.mData.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = LayoutInflater.from((Context)this.context).inflate(R.layout.layout_user_commonpoint_item, parent, false);
            holder.portraitIv = (CircleImageView)convertView.findViewById(R.id.iv_portrait_headIcon);
            holder.portraitAuthVIv = (CircleImageView)convertView.findViewById(R.id.iv_portrait_authVIcon);
            holder.nameTv = (TextView)convertView.findViewById(R.id.tv_name);
            holder.fansNumTv = (TextView)convertView.findViewById(R.id.fans_num_txt);
            holder.livingFlag = (ImageView)convertView.findViewById(R.id.iv_on_live);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        UserInfo info = this.getItem(position);
        if (info != null) {
            Uint32 anchorV;
            if (!StringUtils.isEmpty((String)info.nickName).booleanValue()) {
                holder.nameTv.setText((CharSequence)info.nickName);
            }
            FaceHelper.loadFace((String)info.iconUrl, (int)info.iconIndex, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)holder.portraitIv, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
            if (this.isLivingmap.get(info.userId) != null && this.isLivingmap.get(info.userId) == 1) {
                holder.livingFlag.setVisibility(0);
            } else {
                holder.livingFlag.setVisibility(8);
            }
            Uint32 fansNum = this.fansnumlist.get(Uint32.toUInt((long)info.userId));
            if (fansNum != null) {
                holder.fansNumTv.setText((CharSequence)("\u7c89\u4e1d\u6570\uff1a" + fansNum));
            }
            if ((anchorV = this.authVMap.get(info.userId)) != null) {
                if (anchorV.intValue() == 0) {
                    holder.portraitAuthVIv.setVisibility(8);
                } else if (anchorV.intValue() == 1) {
                    holder.portraitAuthVIv.setBackgroundResource(R.drawable.common_portrait_auth_v_1);
                    holder.portraitAuthVIv.setVisibility(0);
                } else if (anchorV.intValue() == 2) {
                    holder.portraitAuthVIv.setBackgroundResource(R.drawable.common_portrait_auth_v_10);
                    holder.portraitAuthVIv.setVisibility(0);
                }
            } else {
                holder.portraitAuthVIv.setVisibility(8);
            }
        }
        return convertView;
    }

    private static class ViewHolder {
        CircleImageView portraitIv;
        CircleImageView portraitAuthVIv;
        ImageView livingFlag;
        TextView nameTv;
        TextView fansNumTv;

        private ViewHolder() {
        }
    }
}

