/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.takephoto;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageUtil;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.ProgressDialog;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.dialog.DialogLinkManager;
import com.yy.mobile.ui.profile.takephoto.PictureTakerActivity;
import com.yy.mobile.util.BasicFileUtils;
import com.yy.mobile.util.MD5Utils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.YYImageUtils;
import com.yy.mobile.util.YYSchedulers;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TakePhotoController
implements PictureTakerActivity.IController {
    private static final String TAG = "TakePhotoController";
    public static final int IMAGE_SCALE_WIDTH = 1080;
    public static final int IMAGE_SCALE_HEIGHT = 1080;
    private static final int IM_MULTI_IMG = 2010;
    private static final int IM_CAMERA = 2011;
    private final PictureTakerActivity mAct;
    private View mContentView;
    private ImageView mIvPhoto;
    private TextView mTitleView;
    private TextView mOkView;
    private String[] mImageUrls;
    private DialogLinkManager mDialogLinkManager;
    private final List<File> mDeleteList = new ArrayList<File>();
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    boolean mCompress;

    public TakePhotoController(PictureTakerActivity act, boolean compress) {
        this.mAct = act;
        this.mCompress = compress;
    }

    @Override
    public View getContentView() {
        this.mContentView = LayoutInflater.from((Context)this.mAct).inflate(R.layout.mn_im_take_photo, null);
        this.mIvPhoto = (ImageView)this.mContentView.findViewById(R.id.iv_photo);
        this.mOkView = (TextView)this.mContentView.findViewById(R.id.btn_ok);
        this.mTitleView = (TextView)this.mContentView.findViewById(R.id.title);
        this.initListener();
        return this.mContentView;
    }

    @Override
    public void onResult(final String[] paths, final int requestCode, final int from) {
        MLog.info((String)TAG, (String)("onResult reqCode = " + requestCode));
        if (!this.validateImages(paths)) {
            return;
        }
        this.mContentView.setVisibility(4);
        this.showUploadDialog();
        YYSchedulers.io.scheduleDirect(new Runnable(){

            @Override
            public void run() {
                if (from == 2010 || from == 2011) {
                    TakePhotoController.this.handleCompressForIm(requestCode, paths);
                } else {
                    TakePhotoController.this.handleCompress(requestCode, paths);
                }
            }
        });
    }

    private void initListener() {
        this.mOkView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String imageUrl;
                TakePhotoController.this.removeTempFiles();
                if (TakePhotoController.this.mImageUrls != null && TakePhotoController.this.mImageUrls.length > 0 && !TextUtils.isEmpty((CharSequence)(imageUrl = TakePhotoController.this.mImageUrls[0]))) {
                    Intent data = new Intent();
                    data.putExtra("portrait_clip_key", imageUrl);
                    MLog.info((String)TakePhotoController.TAG, (String)("initListener#click value is " + imageUrl));
                    TakePhotoController.this.mAct.setResult(-1, data);
                    TakePhotoController.this.mAct.finish();
                }
            }
        });
        this.mContentView.findViewById(R.id.btn_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TakePhotoController.this.onCancel();
                TakePhotoController.this.mAct.finish();
            }
        });
    }

    private void showUploadDialog() {
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager((Context)this.mAct);
        }
        this.mDialogLinkManager.showDialog((IBaseDialog)new ProgressDialog(this.mAct.getString(R.string.str_tips_processing), true, true, 0, null));
    }

    private void hideUploadDialog() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
        this.mDialogLinkManager = null;
    }

    private void handleCompressForIm(final int requestCode, String[] paths) {
        MLog.info((String)TAG, (String)("handleCompressForIm reqCode = " + requestCode));
        final String[] localImageUrls = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String tempPath;
            String bmpPath = paths[i];
            String extension = YYFileUtils.getFileExtension((String)bmpPath);
            if (extension != null && extension.equalsIgnoreCase(".gif")) {
                localImageUrls[i] = this.copyFileToImageDir(bmpPath);
                continue;
            }
            if (this.mCompress) {
                String tempName = "resize_" + System.currentTimeMillis() + "_" + i + YYFileUtils.getFileName((String)bmpPath);
                File temp = YYFileUtils.getTempFile((Context)this.mAct, (String)tempName);
                tempPath = temp.getPath();
                YYFileUtils.copyFile((String)bmpPath, (String)tempPath);
                ImageConfig imageConfig = new ImageConfig(ImageConfig.ImagePrecision.Middle, ImageConfig.ImageTransparency.RGB_565);
                Rect r = YYImageUtils.decodeBmpSize((String)bmpPath);
                if (r.width() > 1080 || r.height() > 1080) {
                    YYImageUtils.fixPictureOrientation((String)tempPath, (boolean)true, (ImageConfig)imageConfig, (int)60);
                } else {
                    YYImageUtils.fixPictureOrientation((String)tempPath, (boolean)true, (ImageConfig)imageConfig, (int)85);
                }
            } else {
                int rotate = YYImageUtils.getCameraPhotoOrientation((String)bmpPath);
                if (rotate > 0) {
                    String tempName2 = "resize_" + System.currentTimeMillis() + "_" + i + YYFileUtils.getFileName((String)bmpPath);
                    File temp2 = YYFileUtils.getTempFile((Context)this.mAct, (String)tempName2);
                    tempPath = temp2.getPath();
                    YYFileUtils.copyFile((String)bmpPath, (String)tempPath);
                    ImageConfig imageConfig = new ImageConfig(ImageConfig.ImagePrecision.Full, ImageConfig.ImageTransparency.RGB_565);
                    YYImageUtils.fixPictureOrientation((String)tempPath, (boolean)true, (ImageConfig)imageConfig, (int)95);
                } else {
                    tempPath = bmpPath;
                }
            }
            localImageUrls[i] = this.copyFileToImageDir(tempPath);
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                TakePhotoController.this.hideUploadDialog();
                TakePhotoController.access$302(TakePhotoController.this, localImageUrls);
                switch (requestCode) {
                    case 1: {
                        TakePhotoController.this.removeTempFiles();
                        if (localImageUrls.length > 0) {
                            String imageUrl = localImageUrls[0];
                            if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
                                Intent data = new Intent();
                                data.putExtra("portrait_clip_key", new String[]{imageUrl});
                                TakePhotoController.this.mAct.setResult(-1, data);
                            } else {
                                TakePhotoController.this.mAct.setResult(0);
                            }
                        }
                        TakePhotoController.this.mAct.finish();
                        break;
                    }
                    case 3: {
                        TakePhotoController.this.removeTempFiles();
                        if (localImageUrls.length > 0) {
                            Intent data = new Intent();
                            data.putExtra("portrait_clip_key", localImageUrls);
                            TakePhotoController.this.mAct.setResult(-1, data);
                        } else {
                            TakePhotoController.this.mAct.setResult(0);
                        }
                        TakePhotoController.this.mAct.finish();
                        break;
                    }
                    default: {
                        String imageUrl = localImageUrls[0];
                        Bitmap bitmap = ImageUtil.decodeSampledBitmapFile((String)imageUrl, (ImageConfig)ImageConfig.fullImageConfig(), (boolean)true);
                        TakePhotoController.this.mIvPhoto.setImageBitmap(bitmap);
                        TakePhotoController.this.mContentView.setVisibility(0);
                    }
                }
            }
        });
    }

    private void handleCompress(final int requestCode, String[] paths) {
        final String[] localImageUrls = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String tempPath;
            String bmpPath = paths[i];
            String extension = YYFileUtils.getFileExtension((String)bmpPath);
            if (extension != null && extension.equalsIgnoreCase(".gif")) {
                localImageUrls[i] = this.copyFileToImageDir(bmpPath);
                continue;
            }
            if (this.mCompress) {
                String tempName = "resize_" + System.currentTimeMillis() + "_" + i + YYFileUtils.getFileName((String)bmpPath);
                File temp = YYFileUtils.getTempFile((Context)this.mAct, (String)tempName);
                tempPath = temp.getPath();
                YYFileUtils.copyFile((String)bmpPath, (String)tempPath);
                ImageConfig imageConfig = new ImageConfig(1080, 1080);
                Bitmap bp = YYImageUtils.fixPictureOrientation((String)tempPath, (boolean)true, (ImageConfig)imageConfig, (int)100);
                MLog.info((String)TAG, (String)("handleCompress size = " + bp.getByteCount()));
            } else {
                int rotate = YYImageUtils.getCameraPhotoOrientation((String)bmpPath);
                if (rotate > 0) {
                    String tempName2 = "resize_" + System.currentTimeMillis() + "_" + i + YYFileUtils.getFileName((String)bmpPath);
                    File temp2 = YYFileUtils.getTempFile((Context)this.mAct, (String)tempName2);
                    tempPath = temp2.getPath();
                    YYFileUtils.copyFile((String)bmpPath, (String)tempPath);
                    ImageConfig imageConfig = new ImageConfig(ImageConfig.ImagePrecision.Full, ImageConfig.ImageTransparency.RGB_565);
                    YYImageUtils.fixPictureOrientation((String)tempPath, (boolean)true, (ImageConfig)imageConfig, (int)100);
                } else {
                    tempPath = bmpPath;
                }
            }
            localImageUrls[i] = this.copyFileToImageDir(tempPath);
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                TakePhotoController.this.hideUploadDialog();
                TakePhotoController.access$302(TakePhotoController.this, localImageUrls);
                switch (requestCode) {
                    case 1: {
                        TakePhotoController.this.removeTempFiles();
                        if (localImageUrls.length > 0) {
                            String imageUrl = localImageUrls[0];
                            if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
                                Intent data = new Intent();
                                data.putExtra("portrait_clip_key", new String[]{imageUrl});
                                TakePhotoController.this.mAct.setResult(-1, data);
                            } else {
                                TakePhotoController.this.mAct.setResult(0);
                            }
                        }
                        TakePhotoController.this.mAct.finish();
                        break;
                    }
                    case 3: {
                        TakePhotoController.this.removeTempFiles();
                        if (localImageUrls.length > 0) {
                            Intent data = new Intent();
                            data.putExtra("portrait_clip_key", localImageUrls);
                            TakePhotoController.this.mAct.setResult(-1, data);
                        } else {
                            TakePhotoController.this.mAct.setResult(0);
                        }
                        TakePhotoController.this.mAct.finish();
                        break;
                    }
                    default: {
                        String imageUrl = localImageUrls[0];
                        Bitmap bitmap = ImageUtil.decodeSampledBitmapFile((String)imageUrl, (ImageConfig)ImageConfig.fullImageConfig(), (boolean)true);
                        TakePhotoController.this.mIvPhoto.setImageBitmap(bitmap);
                        TakePhotoController.this.mContentView.setVisibility(0);
                    }
                }
            }
        });
    }

    private boolean validateImages(String[] paths) {
        for (String path : paths) {
            if (YYImageUtils.isImage((String)path)) continue;
            return false;
        }
        return true;
    }

    private String copyFileToImageDir(String path) {
        String dstDir;
        String dstPath = YYFileUtils.getYYImageFileLocalPath((String)path);
        String dir = BasicFileUtils.getDirOfFilePath((String)path);
        if (!StringUtils.equal((String)dir, (String)(dstDir = BasicFileUtils.getDirOfFilePath((String)dstPath))) && !YYFileUtils.copyFile((String)path, (String)dstPath)) {
            dstPath = path;
        }
        File file = new File(dstPath);
        String md5FileName = this.createMd5FileName(file.length(), dstPath);
        String extenName = YYFileUtils.getFileExtension((String)path);
        if (extenName == null || "".equals(extenName)) {
            extenName = ".png";
        }
        dstPath = YYFileUtils.getDirOfFilePath((String)dstPath) + File.separator + md5FileName + extenName;
        MLog.info((String)TAG, (String)("copyFileToImageDir md5Name = " + md5FileName + ", dstPath = " + dstPath));
        File newDst = new File(dstPath);
        file.renameTo(newDst);
        if (YYFileUtils.isTempFile((Context)this.mAct, (String)path)) {
            this.mDeleteList.add(new File(path));
        }
        return dstPath;
    }

    private String createMd5FileName(long length, String path) {
        String fileMd5 = "";
        try {
            fileMd5 = MD5Utils.getFileMd5String((String)path);
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)"get file [%s] md5 failed", (Object[])new Object[]{path});
        }
        return length + "-" + fileMd5;
    }

    private void removeTempFiles() {
        for (File file : this.mDeleteList) {
            file.delete();
        }
    }

    public void setContentViewTitle(String title) {
        this.mTitleView.setText((CharSequence)title);
    }

    public void setContentViewOkText(String okText) {
        this.mOkView.setText((CharSequence)okText);
    }

    @Override
    public void onCancel() {
        this.removeTempFiles();
        this.mAct.setResult(0);
    }

    static /* synthetic */ String[] access$302(TakePhotoController x0, String[] x1) {
        x0.mImageUrls = x1;
        return x1;
    }
}

