/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.takephoto;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.widget.RelativeLayout;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.annotation.RouteDoc;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.AndPermission;
import com.yy.immersion.ImmersionBar;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.policy.dialog.IPerConstantKt;
import com.yy.mobile.policy.dialog.PermissionTips;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.profile.takephoto.GetImagePathUtil;
import com.yy.mobile.ui.profile.takephoto.PhotoEditController;
import com.yy.mobile.ui.profile.takephoto.TakePhotoController;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.utils.YYImageUtils;
import com.yy.mobile.ui.widget.photopicker.PhotoPickParamsBuilder;
import com.yy.mobile.ui.widget.photoselecter.YYSelectorActivity;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.YYSchedulers;
import com.yy.mobile.util.log.MLog;
import io.reactivex.Flowable;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Route(path="/Media/TakePhoto", name="\u62cd\u7167")
@RouteDoc(desc="\u62cd\u7167\u754c\u9762", minVer="7.16", eg="yymobile://Media/TakePhoto")
public class PictureTakerActivity
extends BaseActivity {
    private static final String TAG = "PictureTakerActivity";
    public static final String PHOTO_PATH = "edit_photo_path_key";
    public static final String TAKE_PHOTO_FILE_PATH = "take_photo_file_path";
    private static final String RESULT_KEY = "result_path_key";
    private static final String CAMERA_PREFIX = "picture_";
    public static final int RESULT_FAIL = 2;
    private IController mController;
    private ArrayList<String> mSelectedPaths;
    private int mStyle;
    private int mMethod;
    private int mReqCode;
    private int mAmount = 9;
    private int mMaxSize = Integer.MAX_VALUE;
    private String[] mResultPath;
    private String mCameraCapturingName;
    private final CompositeDisposable mDis = new CompositeDisposable();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle data = savedInstanceState != null ? savedInstanceState : this.getIntent().getExtras();
        if (data == null) {
            return;
        }
        String path = data.getString(PHOTO_PATH);
        this.mStyle = data.getInt("act_style_key", 1);
        this.mAmount = data.getInt("params_picture_amount", 9);
        this.mMaxSize = data.getInt("params_picture_max_size", Integer.MAX_VALUE);
        this.mReqCode = data.getInt("from_req_code", Integer.MAX_VALUE);
        MLog.info((String)TAG, (String)("onCreate savedInstanceState = " + savedInstanceState + ", path = " + path + ", mStyle = " + this.mStyle + ", mReqCode = " + this.mReqCode));
        this.mMethod = !StringUtils.isEmptyString((String)path) ? 0 : data.getInt("take_photo_method_key", 2);
        if (this.isTakePhotoController()) {
            boolean compress = this.isNeedCompress();
            this.mController = new TakePhotoController(this, compress);
            this.mSelectedPaths = data.getStringArrayList("act_extra_key_selected");
        } else {
            PhotoEditController ctrl = new PhotoEditController(this);
            if (this.mStyle == 4) {
                ctrl.enableClipPortrait(true);
            }
            this.mController = ctrl;
        }
        this.getWindow().setBackgroundDrawableResource(R.color.transparent);
        this.setContentView(this.mController.getContentView());
        if (this.mStyle == 5) {
            ((TakePhotoController)this.mController).setContentViewOkText("\u786e\u8ba4");
            ((TakePhotoController)this.mController).setContentViewTitle("\u786e\u8ba4\u56fe\u7247");
        }
        if (savedInstanceState != null) {
            final String[] result = savedInstanceState.getStringArray(RESULT_KEY);
            if (this.validateImages(result)) {
                this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        PictureTakerActivity.this.handleResult(result, PictureTakerActivity.this.mMethod);
                    }
                });
            }
            this.mCameraCapturingName = savedInstanceState.getString(TAKE_PHOTO_FILE_PATH);
        } else if (this.mMethod == 0) {
            this.mController.onResult(new String[]{path}, this.mMethod, this.mReqCode);
        } else {
            this.takePhoto();
        }
    }

    public void onBackPressed() {
        this.mController.onCancel();
        super.onBackPressed();
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("act_style_key", this.mStyle);
        outState.putStringArray(RESULT_KEY, this.mResultPath);
        outState.putString(TAKE_PHOTO_FILE_PATH, this.mCameraCapturingName);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mDis.dispose();
    }

    protected void onActivityResult(final int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        MLog.info((String)TAG, (String)("onActivityResult requestCode = " + requestCode + ", resultCode = " + resultCode + ", data = " + data));
        String[] paths = null;
        if (resultCode != -1) {
            this.finish();
            return;
        }
        switch (requestCode) {
            case 1: {
                File file = YYFileUtils.getTempFile((Context)this, (String)this.mCameraCapturingName);
                if (YYImageUtils.isImage(file)) {
                    paths = new String[]{file.getPath()};
                }
                if (this.validateImages(paths)) {
                    this.handleResult(paths, requestCode);
                    break;
                }
                this.finish();
                break;
            }
            case 3: {
                if (data != null) {
                    ArrayList pathList = data.getStringArrayListExtra("result_params_selected_paths");
                    paths = new String[pathList.size()];
                    pathList.toArray(paths);
                }
                if (this.validateImages(paths)) {
                    this.handleResult(paths, requestCode);
                    break;
                }
                this.finish();
                break;
            }
            default: {
                boolean isHavePermission = AndPermission.hasPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"});
                MLog.info((String)TAG, (String)("onActivityResult isHavePermission = " + isHavePermission));
                if (data == null || !isHavePermission) break;
                final Uri uri = data.getData();
                MLog.info((String)TAG, (String)("onActivityResult uri = " + uri));
                this.mDis.add(Flowable.just((Object)"").subscribeOn(YYSchedulers.io).map((Function)new Function<String, String[]>(){

                    public String[] apply(@NonNull String s) throws Exception {
                        return new String[]{GetImagePathUtil.getFilePathFromURI((Context)PictureTakerActivity.this, uri)};
                    }
                }).observeOn(YYSchedulers.mainThread).subscribe((Consumer)new Consumer<String[]>(){

                    public void accept(String[] paths) throws Exception {
                        MLog.info((String)PictureTakerActivity.TAG, (String)("onActivityResult paths size: " + paths.length));
                        if (PictureTakerActivity.this.validateImages(paths)) {
                            PictureTakerActivity.this.handleResult(paths, requestCode);
                        } else {
                            PictureTakerActivity.this.finish();
                        }
                    }
                }, RxUtils.errorConsumer((String)TAG)));
            }
        }
    }

    public void takePhoto() {
        MLog.info((String)TAG, (String)("takePhoto mMethod = " + this.mMethod));
        if (this.mMethod == 1 || this.mMethod == 0) {
            this.takePhotoFromCamera();
        } else if (this.mMethod == 2) {
            this.selectPhoto();
        } else if (this.mMethod == 3) {
            this.selectMultiPhoto();
        }
    }

    private void takePhotoFromCamera() {
        ArrayList<String> permission = new ArrayList<String>();
        permission.add("android.permission.CAMERA");
        IPerConstantKt.showPermissionTips((Context)this, (String)PermissionTips.INSTANCE.getCAMERA(), permission, (Action)new Action<List<String>>(){

            public void onAction(List<String> data) {
                PictureTakerActivity.this.realTakePhotoFromCamera();
            }
        }, (Action)new Action<List<String>>(){

            public void onAction(List<String> data) {
                MLog.info((String)PictureTakerActivity.TAG, (String)"takePhotoFromCamera deny permission");
            }
        }, (String)"");
    }

    private void realTakePhotoFromCamera() {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        this.mCameraCapturingName = CAMERA_PREFIX + System.currentTimeMillis() + ".jpg";
        File out = YYFileUtils.getTempFile((Context)this, (String)this.mCameraCapturingName);
        out.delete();
        Uri uri = AndPermission.getFileUri((Activity)this, (File)out);
        intent.putExtra("output", (Parcelable)uri);
        try {
            this.startActivityForResult(intent, 1);
        }
        catch (Exception e) {
            MLog.error((String)TAG, (String)("realTakePhotoFromCamera fail error msg " + e));
        }
    }

    private void selectPhoto() {
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.PICK");
        try {
            this.startActivityForResult(intent, 2);
        }
        catch (Exception e) {
            MLog.error((String)TAG, (String)("selectPhoto fail error msg " + e));
        }
    }

    private void selectMultiPhoto() {
        PhotoPickParamsBuilder builder = new PhotoPickParamsBuilder();
        builder.setAmount(this.mAmount);
        builder.setMaxSize(this.mMaxSize);
        builder.setCompleteButtonText("\u786e\u5b9a");
        if (this.mSelectedPaths != null && !this.mSelectedPaths.isEmpty()) {
            builder.setSelectedImagePaths(this.mSelectedPaths);
        }
        YYSelectorActivity.Companion.toIntent((Activity)this, 3, builder.build());
    }

    private void handleResult(String[] paths, int requestCode) {
        this.mResultPath = paths;
        this.mController.onResult(paths, requestCode, this.mReqCode);
    }

    private boolean validateImages(String[] paths) {
        if (paths == null || paths.length == 0) {
            return false;
        }
        for (String path : paths) {
            if (YYImageUtils.isImage(path)) continue;
            SingleToastUtil.showToast((String)"\u8be5\u56fe\u7247\u65e0\u6cd5\u83b7\u53d6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u56fe\u7247");
            return false;
        }
        return true;
    }

    private boolean isTakePhotoController() {
        MLog.info((String)TAG, (String)("isTakePhotoController mStyle = " + this.mStyle));
        return this.mStyle == 1 || this.mStyle == 2 || this.mStyle == 5;
    }

    private boolean isNeedCompress() {
        return this.mStyle != 2 && this.mStyle != 5;
    }

    protected boolean handleStatusBar() {
        ImmersionBar.with((Activity)this).statusBarColor(17170444).init();
        return true;
    }

    protected void configView() {
        View view = this.findViewById(R.id.title);
        if (view != null) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)view.getLayoutParams();
            lp.height += ScreenUtil.getStatusBarHeight();
        }
    }

    public static interface IController {
        public View getContentView();

        public void onResult(String[] var1, int var2, int var3);

        public void onCancel();
    }
}

