/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.takephoto;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageUtil;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.profile.takephoto.PictureTakerActivity;
import com.yy.mobile.ui.widget.cropper.CropImageView;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.TimeUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.log.MLog;
import java.io.File;

public class PhotoEditController
implements PictureTakerActivity.IController {
    private static final String TAG = "PhotoEditController";
    private static final String CLIP_NAME = "photo_clip_temp";
    private static final String JPG_EXT = ".jpg";
    private final Handler mHandler = new SafeDispatchHandler(Looper.getMainLooper());
    private final PictureTakerActivity mAct;
    private boolean mEnableClip;
    private CropImageView mEditView;
    private String bmpTmpPath;
    private final View.OnClickListener mRetakeClick = new View.OnClickListener(){

        public void onClick(View v) {
            PhotoEditController.this.mAct.takePhoto();
            PhotoEditController.this.deleteTempImage();
        }
    };
    private final View.OnClickListener mOkClick = new View.OnClickListener(){

        public void onClick(View v) {
            try {
                Bitmap bitmap = PhotoEditController.this.mEditView.getCroppedImage();
                if (bitmap != null) {
                    File clipTemp = YYFileUtils.getTempFile((Context)PhotoEditController.this.mAct, (String)(PhotoEditController.CLIP_NAME + TimeUtils.curSec() + PhotoEditController.JPG_EXT));
                    YYFileUtils.saveBitmapToJPG((Bitmap)bitmap, (String)clipTemp.getPath());
                    PhotoEditController.this.deleteTempImage();
                    Intent data = new Intent();
                    data.putExtra("portrait_clip_key", clipTemp.getPath());
                    PhotoEditController.this.mAct.setResult(-1, data);
                } else {
                    PhotoEditController.this.mAct.setResult(2);
                }
            }
            catch (Exception e) {
                MLog.error((Object)PhotoEditController.TAG, (Throwable)e);
                PhotoEditController.this.mAct.setResult(2);
            }
            PhotoEditController.this.mAct.finish();
        }
    };
    private final View.OnClickListener mRotateClick = new View.OnClickListener(){

        public void onClick(View v) {
            PhotoEditController.this.mEditView.rotateImage(90);
        }
    };

    public PhotoEditController(PictureTakerActivity act) {
        this.mAct = act;
    }

    public void enableClipPortrait(boolean enable) {
        this.mEnableClip = enable;
        if (this.mEditView != null) {
            this.mEditView.setEnabled(enable);
        }
    }

    @Override
    public View getContentView() {
        View v = LayoutInflater.from((Context)this.mAct).inflate(R.layout.mn_im_photo_edit, null);
        this.mEditView = (CropImageView)v.findViewById(R.id.photo_edit);
        this.mEditView.setEnabled(this.mEnableClip);
        this.mEditView.setFixedAspectRatio(true);
        v.findViewById(R.id.btn_use).setOnClickListener(this.mOkClick);
        v.findViewById(R.id.btn_retake).setOnClickListener(this.mRetakeClick);
        this.initTitleButton(v, R.id.btn_rotate, this.mRotateClick);
        v.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                PhotoEditController.this.mEditView.setAspectRatio(1, 1);
            }
        });
        return v;
    }

    private void initTitleButton(View v, int viewId, View.OnClickListener listener2) {
        ImageView button = (ImageView)v.findViewById(viewId);
        button.setOnClickListener(listener2);
    }

    private void finish() {
        if (this.mAct != null) {
            this.mAct.finish();
        }
    }

    @Override
    public void onResult(String[] paths, int requestCode, int from) {
        String bmpPath = null;
        if (paths.length > 0) {
            bmpPath = paths[0];
        }
        MLog.info((String)TAG, (String)("onResult bmpPath = " + bmpPath));
        if (FP.empty((CharSequence)bmpPath) || bmpPath.lastIndexOf(".") == -1) {
            MLog.error((String)TAG, (String)"onResult bmpPath is null");
            this.finish();
            return;
        }
        String suffix = YYFileUtils.getFileExtension((String)bmpPath);
        File tempFile = YYFileUtils.getTempFile((Context)this.mAct, (String)("avater" + System.currentTimeMillis() + suffix));
        String tmpPath = tempFile.getAbsolutePath();
        boolean copySucc = YYFileUtils.copyFile((String)bmpPath, (String)tmpPath);
        if (copySucc) {
            this.bmpTmpPath = tmpPath;
            Bitmap bitmap = ImageUtil.decodeSampledBitmapFile((String)this.bmpTmpPath, (ImageConfig)ImageConfig.defaultImageConfig(), (boolean)true);
            if (bitmap == null) {
                MLog.error((String)TAG, (String)("onResult decodeSampledBitmapFile not successful bmpPath = " + bmpPath));
                this.finish();
                return;
            }
            this.mEditView.setImageBitmap(bitmap);
        } else {
            MLog.error((String)TAG, (String)("onResult copy file not successful bmpPath = " + bmpPath));
            this.finish();
        }
    }

    @Override
    public void onCancel() {
        this.deleteTempImage();
        this.mAct.setResult(0);
    }

    public void deleteTempImage() {
        if (this.bmpTmpPath != null) {
            MLog.info((String)TAG, (String)("deleteTempImage path = " + this.bmpTmpPath));
            YYFileUtils.removeFile((String)this.bmpTmpPath);
            this.bmpTmpPath = null;
        }
    }
}

