/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.takephoto;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.yy.mobile.util.log.MLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GetImagePathUtil {
    private static final String TAG = "GetImagePathUtil";

    public static String getFilePathFromURI(Context context, Uri contentUri) throws IOException {
        MLog.info((String)TAG, (String)("getFilePathFromURI context = " + context + ", contentUri = " + contentUri));
        File rootDataDir = context.getFilesDir();
        String fileName = GetImagePathUtil.getFileName(contentUri);
        MLog.info((String)TAG, (String)("getFilePathFromURI fileName = " + fileName));
        if (!TextUtils.isEmpty((CharSequence)fileName)) {
            File copyFile = new File(rootDataDir + File.separator + fileName);
            GetImagePathUtil.copyFile(context, contentUri, copyFile);
            return copyFile.getAbsolutePath();
        }
        return null;
    }

    private static String getFileName(Uri uri) {
        if (uri == null) {
            return null;
        }
        String fileName = null;
        String path = uri.getPath();
        int cut = -1;
        if (path != null) {
            cut = path.lastIndexOf(47);
        }
        MLog.info((String)TAG, (String)("getFileName cut = " + cut));
        if (cut != -1) {
            fileName = path.substring(cut + 1);
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(Context context, Uri srcUri, File dstFile) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = context.getContentResolver().openInputStream(srcUri);
            if (inputStream == null) {
                return;
            }
            outputStream = new FileOutputStream(dstFile);
            GetImagePathUtil.copyStream(inputStream, outputStream);
        }
        catch (Exception e) {
            MLog.error((String)TAG, (String)("copyFile error msg: " + e.getMessage()));
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(InputStream input, OutputStream output) throws IOException {
        int bufferSize = 1024;
        byte[] buffer = new byte[1024];
        BufferedInputStream in = new BufferedInputStream(input, 1024);
        BufferedOutputStream out = new BufferedOutputStream(output, 1024);
        int flag = 0;
        try {
            int n;
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
                ++flag;
            }
            MLog.info((String)TAG, (String)("copyStream flag = " + flag));
        }
        finally {
            try {
                out.flush();
                out.close();
                in.close();
            }
            catch (IOException e) {
                MLog.error((String)TAG, (String)("copyStream close error: " + e.getMessage()));
            }
        }
    }
}

