/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.presenter;

import com.yy.mobile.ui.profile.presenter.BaseRequestPresenter;
import com.yy.mobile.ui.profile.view.IReplayView;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.channel.channelout.IChannelOutCore;
import com.yymobile.core.mobilelive.AnchorReplayInfo;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;

public class ReplayPresenter
extends BaseRequestPresenter<IReplayView> {
    private static String TAG = "BaseRequestFragment";
    private static int PAGE_SIZE = 10;

    @Override
    public void request(long uid, int offset) {
        ((IChannelOutCore)CoreFactory.getCore(IChannelOutCore.class)).requestReplayData(uid, offset, PAGE_SIZE).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<AnchorReplayInfo>(){

            public void accept(AnchorReplayInfo anchorReplayInfo) throws Exception {
                MLog.info((String)TAG, (String)("request data finish: " + anchorReplayInfo.replayList.size()));
                if (anchorReplayInfo.replayList.size() > 0) {
                    if (ReplayPresenter.this.getView() != null) {
                        ((IReplayView)ReplayPresenter.this.getView()).onRequestResult(anchorReplayInfo);
                    }
                    ReplayPresenter.this.onRequestFinish(true);
                } else {
                    MLog.info((String)TAG, (String)"request data empty");
                    ReplayPresenter.this.onRequestFinish(false);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.info((String)TAG, (String)("request data fail: " + throwable.getMessage()));
                ReplayPresenter.this.onRequestFinish(false);
            }
        });
    }
}

