/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.presenter;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.mvp.MvpPresenter;
import com.yy.mobile.ui.profile.view.IRequestStatusView;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.log.MLog;

public class BaseRequestPresenter<V extends IRequestStatusView>
extends MvpPresenter<V> {
    private static String TAG = "BaseRequestFragment";
    private static long REQUEST_TIMEOUT = 5000L;
    private boolean needShowErrorView = true;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            MLog.info((String)TAG, (String)"request data time out");
            BaseRequestPresenter.this.onRequestFinish(false);
        }
    };

    public void requestData(long uid, boolean showErrorViewWhenDataEmpty, int offset) {
        this.needShowErrorView = showErrorViewWhenDataEmpty;
        if (this.allowRequest()) {
            MLog.info((String)TAG, (String)"request data");
            this.request(uid, offset);
            this.startTimeoutTimer();
        } else {
            MLog.info((String)TAG, (String)"allowRequest: false");
            this.onRequestFinish(false);
        }
    }

    protected void onRequestFinish(boolean success) {
        this.handler.removeCallbacksAndMessages(null);
        if (this.getView() != null) {
            MLog.info((String)TAG, (String)"request data onRequestFinish hideLoadingView");
            ((IRequestStatusView)this.getView()).hideLoadingView();
            if (!success && this.needShowErrorView) {
                MLog.info((String)TAG, (String)"request data onRequestFinish showNoDataView");
                ((IRequestStatusView)this.getView()).showNoDataView();
            }
        }
    }

    public void request(long uid, int offset) {
    }

    private void startTimeoutTimer() {
        this.handler.removeCallbacksAndMessages(null);
        this.handler.sendEmptyMessageDelayed(0, REQUEST_TIMEOUT);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.handler.removeCallbacksAndMessages(null);
    }

    protected boolean allowRequest() {
        return NetworkUtils.isNetworkAvailable((Context)BasicConfig.getInstance().getAppContext());
    }
}

