/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.photo;

import android.content.Context;
import android.os.Parcelable;
import android.view.View;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.mobile.ui.profile.photo.PhotoItemView;
import com.yy.mobile.util.log.MLog;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PhotoPagerAdapter
extends PagerAdapter {
    private Context mContext;
    private JSONArray mJsonArray;
    private HashMap<Integer, PhotoItemView> mHashMap;
    private static final String TAG = "PhotoPagerAdapter";

    public PhotoPagerAdapter(Context context, JSONArray arrays) {
        this.mContext = context;
        this.mJsonArray = arrays;
        this.mHashMap = new HashMap();
    }

    public void destroyItem(View container, int position, Object object) {
        PhotoItemView itemView = (PhotoItemView)((Object)object);
        itemView.recycle();
    }

    public void finishUpdate(View view) {
    }

    public int getCount() {
        return this.mJsonArray.length();
    }

    public Object instantiateItem(View container, int position) {
        PhotoItemView itemView;
        if (this.mHashMap.containsKey(position)) {
            itemView = this.mHashMap.get(position);
            itemView.reload();
        } else {
            itemView = new PhotoItemView(this.mContext);
            try {
                JSONObject dataObj = (JSONObject)this.mJsonArray.get(position);
                itemView.setData(dataObj);
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
            this.mHashMap.put(position, itemView);
            ((ViewPager)container).addView((View)itemView);
        }
        return itemView;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void restoreState(Parcelable arg0, ClassLoader arg1) {
    }

    public Parcelable saveState() {
        return null;
    }

    public void startUpdate(View view) {
    }
}

