/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.anchor.personalpage;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.homeapi.ui.home.FontUtils;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.onepiece.activity.OnepieceUserInfoActivity;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.widget.AutoAdjustLinearlayout;
import com.yy.mobile.ui.widget.AutoAdjustRoundConerImageView;
import com.yy.mobile.ui.widget.ViewHolderAdapter;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.ResolutionUtils;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.gallery.IPhotoWatchCountCore;
import com.yymobile.core.gallery.module.PhotoInfo;
import com.yymobile.core.onepiece.OnepieceHiidoConst;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GridViewAdapterOld
extends ViewHolderAdapter {
    public static final int UpAndDownMiddleSpacing = 10;
    public static final int LeftAndRightMiddleSpacing = 10;
    public static final int leftSpacing = 10;
    public static final int rightSpacing = 10;
    public static final int HORIZONTAL_SPACING = 8;
    private int mRoundConerRadius;
    public int columnWidth;
    private int columnHeight;
    protected static final int ITEM_TYPE_SHOW = 1;
    protected static final int ITEM_TYPE_ADD = 0;
    protected Context mContext;
    private int moreSize;
    private boolean isMyself;
    public List<PhotoInfo> photos = new ArrayList<PhotoInfo>();
    private int screenWidth;
    private long anchorUid;
    private int maxColumnCount = 4;
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();

    public GridViewAdapterOld(Context context, long anchorUid) {
        this.mContext = context;
        this.anchorUid = anchorUid;
        this.mRoundConerRadius = DimenConverter.dip2px((Context)this.mContext, (float)this.getCornerRadiusValue());
        this.initColumnWidthOrHeight(context);
    }

    private int getCornerRadiusValue() {
        return 8;
    }

    private void initColumnWidthOrHeight(Context context) {
        this.screenWidth = ResolutionUtils.getScreenWidth((Context)context) - DimenConverter.dip2px((Context)this.mContext, (float)103.0f);
        this.columnWidth = this.columnHeight = (this.screenWidth - DensityUtil.dip2px((Context)context, (float)24.0f)) / this.maxColumnCount;
    }

    public int getTwoLineGridViewHeight() {
        if (this.mContext != null) {
            return this.columnHeight * 2 + DensityUtil.dip2px((Context)this.mContext, (float)10.0f);
        }
        return 0;
    }

    public void setMaxColumnCount(int count) {
        this.maxColumnCount = count;
    }

    public int getOneLineGridViewHeight() {
        if (this.mContext != null) {
            return this.columnHeight;
        }
        return 0;
    }

    public int getOneLineGridViewWidth() {
        if (this.mContext != null) {
            return this.columnWidth * this.maxColumnCount + 24;
        }
        return 0;
    }

    public void setData(int moreSize, boolean isMyself, List<PhotoInfo> photo) {
        if (this.photos == null) {
            this.photos = new ArrayList<PhotoInfo>();
        } else {
            this.photos.clear();
        }
        if (FP.size(photo) > 0) {
            this.moreSize = moreSize;
            this.isMyself = isMyself;
            this.photos.addAll(photo);
        }
        if (isMyself) {
            if (this.photos.size() < this.maxColumnCount) {
                PhotoInfo photoInfo = new PhotoInfo();
                photoInfo.addPhotoFlag = true;
                this.photos.add(photoInfo);
            } else {
                PhotoInfo photoInfo = this.photos.get(this.maxColumnCount - 1);
                photoInfo.addPhotoFlag = true;
                photoInfo.isRemoveListEnd = false;
            }
        } else if (this.photos.size() >= this.maxColumnCount) {
            PhotoInfo photoInfo = this.photos.get(this.maxColumnCount - 1);
            photoInfo.morePhotoFlag = true;
            photoInfo.isRemoveListEnd = false;
        }
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.photos != null ? this.photos.size() : 0;
    }

    public Object getItem(int position) {
        if (this.photos != null && this.photos.size() > position) {
            return this.photos.get(position);
        }
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        PhotoInfo info = (PhotoInfo)this.getItem(position);
        if (info.addPhotoFlag) {
            return 0;
        }
        return 1;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public ViewHolderAdapter.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int position) {
        int type = this.getItemViewType(position);
        ViewHolderAdapter.ViewHolder viewHolder = type == 0 ? new AddViewHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.person_page_graller_add_item, viewGroup, false)) : new ShowViewHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.person_page_graller_show_item, viewGroup, false));
        return viewHolder;
    }

    public void onBindViewHolder(ViewHolderAdapter.ViewHolder view, int position) {
        if (this.photos.size() <= position) {
            return;
        }
        final PhotoInfo photoInfo = (PhotoInfo)this.getItem(position);
        if (view instanceof ShowViewHolder) {
            ShowViewHolder showViewHolder = (ShowViewHolder)view;
            if (photoInfo != null) {
                if (!TextUtils.isEmpty((CharSequence)photoInfo.thumbsUrl)) {
                    AutoAdjustRoundConerImageView ivThumb = showViewHolder.imageView;
                    if (ivThumb != null) {
                        Glide.with((Context)ivThumb.getContext()).asBitmap().load(photoInfo.thumbsUrl).apply(new RequestOptions().placeholder(R.drawable.default_portrait)).into((ImageView)ivThumb);
                        ivThumb.setRoundConerRadius(this.mRoundConerRadius);
                    }
                } else {
                    showViewHolder.imageView.setImageResource(R.drawable.default_portrait);
                }
                if (photoInfo.morePhotoFlag) {
                    showViewHolder.desc.setVisibility(0);
                    showViewHolder.desc.setBackgroundResource(R.drawable.bg_show_gallery_corner_new_style);
                    showViewHolder.size.setVisibility(0);
                    showViewHolder.size.setText((CharSequence)("+" + String.valueOf(this.moreSize)));
                    showViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (GridViewAdapterOld.this.mTimeSlotTool.isProcessing()) {
                                return;
                            }
                            if (NetworkUtils.isNetworkStrictlyAvailable((Context)GridViewAdapterOld.this.mContext)) {
                                if (GridViewAdapterOld.this.mContext != null && GridViewAdapterOld.this.anchorUid > 0L) {
                                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "52501", "0005");
                                    NavigationUtils.toUserGallery(GridViewAdapterOld.this.mContext, GridViewAdapterOld.this.anchorUid, false);
                                }
                            } else {
                                Toast.makeText((Context)GridViewAdapterOld.this.mContext, (CharSequence)"\u7f51\u7edc\u4e0d\u53ef\u7528\uff01", (int)0).show();
                            }
                            if (GridViewAdapterOld.this.mContext != null && GridViewAdapterOld.this.mContext instanceof OnepieceUserInfoActivity) {
                                OnepieceHiidoConst.onOnepieceAnchorInfoPicClick();
                            }
                        }
                    });
                } else {
                    showViewHolder.desc.setBackgroundColor(-1);
                    showViewHolder.desc.setAlpha(1.0f);
                    showViewHolder.desc.setVisibility(8);
                    showViewHolder.size.setVisibility(8);
                    showViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (GridViewAdapterOld.this.mTimeSlotTool.isProcessing()) {
                                return;
                            }
                            if (NetworkUtils.isNetworkStrictlyAvailable((Context)GridViewAdapterOld.this.mContext)) {
                                if (GridViewAdapterOld.this.mContext != null && GridViewAdapterOld.this.anchorUid > 0L) {
                                    ArrayList<PhotoInfo> photoInfoList = new ArrayList<PhotoInfo>(GridViewAdapterOld.this.photos);
                                    if (GridViewAdapterOld.this.isMyself && photoInfoList.size() <= GridViewAdapterOld.this.maxColumnCount) {
                                        int position = photoInfoList.size() - 1;
                                        if (photoInfoList.get((int)position).isRemoveListEnd) {
                                            photoInfoList.remove(position);
                                        }
                                    }
                                    NavigationUtils.toGalleryNewPersonPageActivity(GridViewAdapterOld.this.mContext, GridViewAdapterOld.this.anchorUid, photoInfo.photoAlumId, photoInfo, photoInfoList, 4, 100);
                                    ((IPhotoWatchCountCore)CoreManager.getCore(IPhotoWatchCountCore.class)).addGalleryStatics(GridViewAdapterOld.this.anchorUid, (long)((int)photoInfo.photoId), 1);
                                    Property property = new Property();
                                    property.putString("key1", String.valueOf(photoInfo.photoId));
                                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "52501", "0006", (Serializable)property);
                                }
                            } else {
                                Toast.makeText((Context)GridViewAdapterOld.this.mContext, (CharSequence)"\u7f51\u7edc\u4e0d\u53ef\u7528\uff01", (int)0).show();
                            }
                            if (GridViewAdapterOld.this.mContext != null && GridViewAdapterOld.this.mContext instanceof OnepieceUserInfoActivity) {
                                OnepieceHiidoConst.onOnepieceAnchorInfoPicClick();
                            }
                        }
                    });
                }
            }
        } else if (view instanceof AddViewHolder) {
            AddViewHolder addViewHolder = (AddViewHolder)view;
            if (photoInfo != null && photoInfo.addPhotoFlag) {
                if (TextUtils.isEmpty((CharSequence)photoInfo.thumbsUrl)) {
                    addViewHolder.imageView.setVisibility(8);
                    addViewHolder.desc.setBackgroundColor(0);
                } else {
                    ImageLoader.loadImage((String)photoInfo.thumbsUrl, (RecycleImageView)addViewHolder.imageView, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.default_portrait, (int)R.drawable.default_portrait);
                    addViewHolder.imageView.setRoundConerRadius(this.mRoundConerRadius);
                    addViewHolder.imageView.setVisibility(0);
                    addViewHolder.desc.setBackgroundResource(R.drawable.bg_show_gallery_corner_new_style);
                }
                addViewHolder.size.setVisibility(0);
                addViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (GridViewAdapterOld.this.mTimeSlotTool.isProcessing()) {
                            return;
                        }
                        if (NetworkUtils.isNetworkStrictlyAvailable((Context)GridViewAdapterOld.this.mContext)) {
                            if (GridViewAdapterOld.this.mContext != null && GridViewAdapterOld.this.anchorUid > 0L) {
                                NavigationUtils.toUserGallery(GridViewAdapterOld.this.mContext, GridViewAdapterOld.this.anchorUid, false);
                                ((IPhotoWatchCountCore)CoreManager.getCore(IPhotoWatchCountCore.class)).addGalleryStatics(GridViewAdapterOld.this.anchorUid, (long)((int)photoInfo.photoId), 1);
                                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50207", "0004");
                            }
                        } else {
                            Toast.makeText((Context)GridViewAdapterOld.this.mContext, (CharSequence)"\u7f51\u7edc\u4e0d\u53ef\u7528\uff01", (int)0).show();
                        }
                        if (GridViewAdapterOld.this.mContext != null && GridViewAdapterOld.this.mContext instanceof OnepieceUserInfoActivity) {
                            OnepieceHiidoConst.onOnepieceAnchorInfoPicClick();
                        }
                    }
                });
            }
        }
    }

    public class AddViewHolder
    extends ViewHolderAdapter.ViewHolder {
        public final AutoAdjustRoundConerImageView imageView;
        private final AutoAdjustLinearlayout desc;
        public final ImageView size;

        public AddViewHolder(View itemView) {
            super((ViewHolderAdapter)GridViewAdapterOld.this, itemView);
            this.imageView = (AutoAdjustRoundConerImageView)itemView.findViewById(R.id.image);
            this.desc = (AutoAdjustLinearlayout)itemView.findViewById(R.id.desc);
            this.size = (ImageView)itemView.findViewById(R.id.size);
            this.size.setImageResource(R.drawable.personal_page_image_add_new_style);
        }
    }

    public class ShowViewHolder
    extends ViewHolderAdapter.ViewHolder {
        public final AutoAdjustRoundConerImageView imageView;
        public final LinearLayout desc;
        public final TextView size;

        public ShowViewHolder(View itemView) {
            super((ViewHolderAdapter)GridViewAdapterOld.this, itemView);
            this.imageView = (AutoAdjustRoundConerImageView)itemView.findViewById(R.id.image);
            this.desc = (LinearLayout)itemView.findViewById(R.id.desc);
            this.size = (TextView)itemView.findViewById(R.id.size);
            this.size.setTypeface(FontUtils.getTypeFace((Context)GridViewAdapterOld.this.mContext, (FontUtils.FontType)FontUtils.FontType.DINCond_Bold));
            this.size.setTextSize(20.0f);
        }
    }
}

