/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.anchor.personalpage;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.onepiece.activity.OnepieceUserInfoActivity;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.widget.AutoAdjustLinearlayout;
import com.yy.mobile.ui.widget.AutoAdjustRoundConerImageView;
import com.yy.mobile.ui.widget.ViewHolderAdapter;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.ResolutionUtils;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.gallery.IPhotoWatchCountCore;
import com.yymobile.core.gallery.module.PhotoInfo;
import com.yymobile.core.onepiece.OnepieceHiidoConst;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GridViewAdapter
extends ViewHolderAdapter {
    public static final int UpAndDownMiddleSpacing = 10;
    public static final int LeftAndRightMiddleSpacing = 10;
    public static final int leftSpacing = 10;
    public static final int rightSpacing = 10;
    private int mRoundConerRadius;
    public int columnWidth;
    private int columnHeight;
    protected static final int ITEM_TYPE_SHOW = 1;
    protected static final int ITEM_TYPE_ADD = 0;
    protected Context mContext;
    private int moreSize;
    private boolean isMyself;
    public List<PhotoInfo> photos = new ArrayList<PhotoInfo>();
    private int screenWidth;
    private long anchorUid;
    private int maxColumnCount = 5;
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();

    public GridViewAdapter(Context context, long anchorUid) {
        this.mContext = context;
        this.anchorUid = anchorUid;
        this.mRoundConerRadius = DimenConverter.dip2px((Context)this.mContext, (float)5.0f);
        this.screenWidth = ResolutionUtils.getScreenWidth((Context)context) - DensityUtil.dip2px((Context)context, (float)20.0f);
        this.columnWidth = this.columnHeight = (this.screenWidth - DensityUtil.dip2px((Context)context, (float)40.0f)) / this.maxColumnCount;
    }

    public int getTwoLineGridViewHeight() {
        if (this.mContext != null) {
            return this.columnHeight * 2 + DensityUtil.dip2px((Context)this.mContext, (float)10.0f);
        }
        return 0;
    }

    public void setMaxColumnCount(int count) {
        this.maxColumnCount = count;
    }

    public int getOneLineGridViewHeight() {
        if (this.mContext != null) {
            return this.columnHeight + 10;
        }
        return 0;
    }

    public int getOneLineGridViewWidth() {
        if (this.mContext != null) {
            return (this.columnWidth + 10) * this.maxColumnCount;
        }
        return 0;
    }

    public void setData(int moreSize, boolean isMyself, List<PhotoInfo> photo) {
        if (this.photos == null) {
            this.photos = new ArrayList<PhotoInfo>();
        } else {
            this.photos.clear();
        }
        if (FP.size(photo) > 0) {
            this.moreSize = moreSize;
            this.isMyself = isMyself;
            this.photos.addAll(photo);
        }
        if (isMyself) {
            PhotoInfo photoInfo = null;
            if (this.photos.size() < this.maxColumnCount) {
                photoInfo = new PhotoInfo();
                photoInfo.addPhotoFlag = true;
                this.photos.add(photoInfo);
            } else {
                photoInfo = this.photos.get(this.maxColumnCount - 1);
                photoInfo.addPhotoFlag = true;
                photoInfo.isRemoveListEnd = false;
            }
        } else {
            PhotoInfo photoInfo = null;
            if (this.photos.size() >= this.maxColumnCount) {
                photoInfo = this.photos.get(this.maxColumnCount - 1);
                photoInfo.morePhotoFlag = true;
                photoInfo.isRemoveListEnd = false;
            }
        }
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.photos != null ? this.photos.size() : 0;
    }

    public Object getItem(int position) {
        if (this.photos != null && this.photos.size() > position) {
            return this.photos.get(position);
        }
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        PhotoInfo info = (PhotoInfo)this.getItem(position);
        if (info.addPhotoFlag) {
            return 0;
        }
        return 1;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public ViewHolderAdapter.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int position) {
        ViewHolderAdapter.ViewHolder viewHolder;
        int type = this.getItemViewType(position);
        switch (type) {
            case 0: {
                viewHolder = new AddViewHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.person_page_graller_add_item, viewGroup, false));
                break;
            }
            default: {
                viewHolder = new ShowViewHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.person_page_graller_show_item, viewGroup, false));
            }
        }
        return viewHolder;
    }

    public void onBindViewHolder(ViewHolderAdapter.ViewHolder view, int position) {
        if (this.photos.size() <= position) {
            return;
        }
        final PhotoInfo photoInfo = (PhotoInfo)this.getItem(position);
        if (view instanceof ShowViewHolder) {
            ShowViewHolder showViewHolder = (ShowViewHolder)view;
            if (photoInfo != null) {
                if (!TextUtils.isEmpty((CharSequence)photoInfo.thumbsUrl)) {
                    ImageLoader.loadImage((String)photoInfo.thumbsUrl, (RecycleImageView)showViewHolder.imageView, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait, (int)R.drawable.default_portrait);
                    showViewHolder.imageView.setRoundConerRadius(this.mRoundConerRadius);
                } else {
                    showViewHolder.imageView.setImageResource(R.drawable.default_portrait);
                }
                if (photoInfo.morePhotoFlag) {
                    showViewHolder.desc.setVisibility(0);
                    showViewHolder.desc.setAlpha(0.8f);
                    showViewHolder.size.setVisibility(0);
                    showViewHolder.size.setText((CharSequence)("+" + this.moreSize));
                    showViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (GridViewAdapter.this.mTimeSlotTool.isProcessing()) {
                                return;
                            }
                            if (NetworkUtils.isNetworkStrictlyAvailable((Context)GridViewAdapter.this.mContext)) {
                                if (GridViewAdapter.this.mContext != null && GridViewAdapter.this.anchorUid > 0L) {
                                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("52501", "0005");
                                    NavigationUtils.toUserGallery(GridViewAdapter.this.mContext, GridViewAdapter.this.anchorUid, false);
                                }
                            } else {
                                Toast.makeText((Context)GridViewAdapter.this.mContext, (CharSequence)"\u7f51\u7edc\u4e0d\u53ef\u7528\uff01", (int)0).show();
                            }
                            if (GridViewAdapter.this.mContext != null && GridViewAdapter.this.mContext instanceof OnepieceUserInfoActivity) {
                                OnepieceHiidoConst.onOnepieceAnchorInfoPicClick();
                            }
                        }
                    });
                } else {
                    showViewHolder.desc.setBackgroundColor(-1);
                    showViewHolder.desc.setAlpha(1.0f);
                    showViewHolder.desc.setVisibility(8);
                    showViewHolder.size.setVisibility(8);
                    showViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (GridViewAdapter.this.mTimeSlotTool.isProcessing()) {
                                return;
                            }
                            if (NetworkUtils.isNetworkStrictlyAvailable((Context)GridViewAdapter.this.mContext)) {
                                if (GridViewAdapter.this.mContext != null && GridViewAdapter.this.anchorUid > 0L) {
                                    ArrayList<PhotoInfo> photoInfoList = new ArrayList<PhotoInfo>(GridViewAdapter.this.photos);
                                    if (GridViewAdapter.this.isMyself && photoInfoList.size() <= GridViewAdapter.this.maxColumnCount) {
                                        int position = photoInfoList.size() - 1;
                                        if (photoInfoList.get((int)position).isRemoveListEnd) {
                                            photoInfoList.remove(position);
                                        }
                                    }
                                    NavigationUtils.toGalleryNewPersonPageActivity(GridViewAdapter.this.mContext, GridViewAdapter.this.anchorUid, photoInfo.photoAlumId, photoInfo, photoInfoList, 4, 100);
                                    ((IPhotoWatchCountCore)CoreManager.getCore(IPhotoWatchCountCore.class)).addGalleryStatics(GridViewAdapter.this.anchorUid, (long)((int)photoInfo.photoId), 1);
                                    Property property = new Property();
                                    property.putString("key1", String.valueOf(photoInfo.photoId));
                                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "52501", "0006", (Serializable)property);
                                }
                            } else {
                                Toast.makeText((Context)GridViewAdapter.this.mContext, (CharSequence)"\u7f51\u7edc\u4e0d\u53ef\u7528\uff01", (int)0).show();
                            }
                            if (GridViewAdapter.this.mContext != null && GridViewAdapter.this.mContext instanceof OnepieceUserInfoActivity) {
                                OnepieceHiidoConst.onOnepieceAnchorInfoPicClick();
                            }
                        }
                    });
                }
            }
        } else if (view instanceof AddViewHolder) {
            AddViewHolder addViewHolder = (AddViewHolder)view;
            if (photoInfo != null && photoInfo.addPhotoFlag) {
                if (!TextUtils.isEmpty((CharSequence)photoInfo.thumbsUrl)) {
                    ImageLoader.loadImage((String)photoInfo.thumbsUrl, (RecycleImageView)addViewHolder.imageView, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.default_portrait, (int)R.drawable.default_portrait);
                    addViewHolder.imageView.setRoundConerRadius(this.mRoundConerRadius);
                    addViewHolder.imageView.setVisibility(0);
                    addViewHolder.desc.setBackgroundResource(R.drawable.add_grallery_none_corner);
                    addViewHolder.size.setVisibility(0);
                } else {
                    addViewHolder.imageView.setVisibility(8);
                    addViewHolder.desc.setBackgroundColor(0);
                    addViewHolder.size.setVisibility(0);
                }
                addViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (GridViewAdapter.this.mTimeSlotTool.isProcessing()) {
                            return;
                        }
                        if (NetworkUtils.isNetworkStrictlyAvailable((Context)GridViewAdapter.this.mContext)) {
                            if (GridViewAdapter.this.mContext != null && GridViewAdapter.this.anchorUid > 0L) {
                                NavigationUtils.toUserGallery(GridViewAdapter.this.mContext, GridViewAdapter.this.anchorUid, false);
                                ((IPhotoWatchCountCore)CoreManager.getCore(IPhotoWatchCountCore.class)).addGalleryStatics(GridViewAdapter.this.anchorUid, (long)((int)photoInfo.photoId), 1);
                                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50207", "0004");
                            }
                        } else {
                            Toast.makeText((Context)GridViewAdapter.this.mContext, (CharSequence)"\u7f51\u7edc\u4e0d\u53ef\u7528\uff01", (int)0).show();
                        }
                        if (GridViewAdapter.this.mContext != null && GridViewAdapter.this.mContext instanceof OnepieceUserInfoActivity) {
                            OnepieceHiidoConst.onOnepieceAnchorInfoPicClick();
                        }
                    }
                });
            }
        }
    }

    public class AddViewHolder
    extends ViewHolderAdapter.ViewHolder {
        public AutoAdjustRoundConerImageView imageView;
        private AutoAdjustLinearlayout desc;
        public ImageView size;

        public AddViewHolder(View itemView) {
            super((ViewHolderAdapter)GridViewAdapter.this, itemView);
            this.imageView = (AutoAdjustRoundConerImageView)itemView.findViewById(R.id.image);
            this.desc = (AutoAdjustLinearlayout)itemView.findViewById(R.id.desc);
            this.size = (ImageView)itemView.findViewById(R.id.size);
        }
    }

    public class ShowViewHolder
    extends ViewHolderAdapter.ViewHolder {
        public AutoAdjustRoundConerImageView imageView;
        public LinearLayout desc;
        public TextView size;

        public ShowViewHolder(View itemView) {
            super((ViewHolderAdapter)GridViewAdapter.this, itemView);
            this.imageView = (AutoAdjustRoundConerImageView)itemView.findViewById(R.id.image);
            this.desc = (LinearLayout)itemView.findViewById(R.id.desc);
            this.size = (TextView)itemView.findViewById(R.id.size);
        }
    }
}

