/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.anchor;

import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.alibaba.android.arouter.launcher.ARouter;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.profile.WorksTabConfig;
import com.yy.mobile.ui.profile.view.BaseRequestFragment;
import com.yy.mobile.ui.profile.view.WorksSubTabView;
import com.yy.mobile.util.OnVisibleChangeFragment;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.tabconfig.TabInfo;
import com.yyproto.utils.FP;
import java.util.ArrayList;
import java.util.List;

public class WorksFragment
extends OnVisibleChangeFragment
implements WorksSubTabView.ItemClickListener {
    protected static final String TAG = "WorksFragment";
    public static String KEY_ANCHOR_UID = "anchor_uid_key";
    private ViewPager pager;
    private WorksSubTabView tab;
    private Long anchorUid = 0L;
    protected BaseRequestFragment curFragment;

    public static WorksFragment newInstance(Long anchorUid, boolean isSignAnchor) {
        WorksFragment fragment = new WorksFragment();
        fragment.anchorUid = anchorUid;
        fragment.setParentFragmentVisible(true);
        return fragment;
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_anchor_works_layout, null);
        this.initView(view);
        return view;
    }

    private void initView(View viewRoot) {
        this.pager = (ViewPager)viewRoot.findViewById(R.id.viewpager);
        this.pager.setOffscreenPageLimit(2);
        Bundle bundle = new Bundle();
        bundle.putLong(KEY_ANCHOR_UID, this.anchorUid.longValue());
        ViewPagerAdapter adapter = new ViewPagerAdapter(this.getChildFragmentManager(), bundle);
        adapter.setData(WorksTabConfig.factory());
        this.pager.setAdapter((PagerAdapter)adapter);
        this.tab = (WorksSubTabView)viewRoot.findViewById(R.id.nav_view);
        this.tab.setItemClickedListener(this);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.tab != null) {
            this.tab.selectTab(1);
        }
    }

    public void onFragmentVisibleChange(boolean visible) {
        super.onFragmentVisibleChange(visible);
        MLog.info((String)TAG, (String)("onFragmentVisibleChange: " + visible));
        if (this.curFragment != null) {
            this.curFragment.onVisibleChange(visible);
        }
    }

    @Override
    public void onTabItemClick(int curPosition, int prePosition) {
        if (this.pager != null) {
            this.pager.setCurrentItem(curPosition);
        }
    }

    public class ViewPagerAdapter
    extends FragmentPagerAdapter {
        protected List<TabInfo> data;
        private Bundle mBundle;

        public ViewPagerAdapter(FragmentManager fm, Bundle bundle) {
            super(fm);
            this.data = new ArrayList<TabInfo>();
            this.mBundle = bundle;
        }

        public Fragment getItem(int position) {
            if (position < this.data.size()) {
                TabInfo tabInfo = this.data.get(position);
                Fragment navigation = this.createFragment(tabInfo.url);
                return navigation;
            }
            return new BaseLinkFragment();
        }

        public void setPrimaryItem(ViewGroup container, int position, Object object) {
            super.setPrimaryItem(container, position, object);
            if (object instanceof BaseRequestFragment && WorksFragment.this.curFragment != object) {
                MLog.info((String)WorksFragment.TAG, (String)("primary Item change: " + object.getClass().getSimpleName()));
                if (WorksFragment.this.curFragment != null) {
                    WorksFragment.this.curFragment.onVisibleChange(false);
                }
                WorksFragment.this.curFragment = (BaseRequestFragment)object;
                WorksFragment.this.curFragment.onVisibleChange(true);
            }
        }

        public int getCount() {
            return this.data.size();
        }

        public CharSequence getPageTitle(int position) {
            if (position < this.data.size()) {
                return this.data.get((int)position).name;
            }
            return "";
        }

        public void setData(List<TabInfo> data) {
            if (!FP.empty(data)) {
                this.data = new ArrayList<TabInfo>(data);
                this.notifyDataSetChanged();
            }
        }

        private Fragment createFragment(String path) {
            Fragment fragment = (Fragment)ARouter.getInstance().build(Uri.parse((String)path)).navigation();
            if (fragment == null) {
                fragment = new BaseLinkFragment();
            }
            fragment.setArguments(this.mBundle);
            return fragment;
        }
    }
}

