/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.anchor;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.AutowiredDoc;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnLoadmoreListener;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IAnchorWorksClient_onGetAnchorWorks_EventArgs;
import com.yy.mobile.plugin.main.events.IAnchorWorksClient_onGetNoData_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onDeleteMobileLiveReplaySuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IShenquClient_onPlayVideoDeleted_EventArgs;
import com.yy.mobile.ui.profile.anchor.AnchorWorksAdapter;
import com.yy.mobile.ui.profile.anchor.AnchorWorksFragment$$EventBinder;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.util.OnVisibleChangeFragment;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.asyncgift.IAsyncGiftDelegate;
import com.yymobile.core.onepiece.ScrollableContainer;
import com.yymobile.core.profile.IAnchorWorksCore;
import com.yymobile.core.profile.NoMoreWorksInfo;
import com.yymobile.core.profile.RePlayWorksInfo;
import com.yymobile.core.profile.SmallVideoWorksInfo;
import com.yymobile.core.profile.WorksInfo;
import java.util.Iterator;
import java.util.List;

public class AnchorWorksFragment
extends OnVisibleChangeFragment
implements ScrollableContainer {
    public static final String BUNDLE_ANCHOR_UID = "extra_anchor_uid";
    public static final String BUNDLE_ANCHOR_HIT_AB = "extra_anchor_hit_ab";
    private static final String TAG = "AnchorWorksFragment";
    @Autowired(name="extra_anchor_uid")
    @AutowiredDoc(desc="\u4e3b\u64adUID", eg="long\u7c7b\u578b", limit="no", minVer="7.16")
    long anchorUid = 0L;
    @Autowired(name="IsShopPagerPopupComponent")
    @AutowiredDoc(desc="\u662f\u5426\u4e00\u4ef6\u4e3b\u64ad\u4e3b\u9875", eg="Boolean\u7c7b\u578b", limit="no", minVer="7.16")
    boolean isShopPagerPopupComponent = false;
    private RecyclerView mRecyclerView;
    private RelativeLayout mAnchorworksBg;
    private SmartRefreshLayout mRefreshLayout;
    private boolean mIsLastPage = false;
    private AnchorWorksAdapter mAdapter;
    private static boolean isQueryGiftConfig = false;
    private static boolean sIsHitAB = false;
    private EventBinder mEventBinder;

    public static AnchorWorksFragment newInstance(long anchorId) {
        AnchorWorksFragment fragment = new AnchorWorksFragment();
        Bundle bundle = new Bundle();
        bundle.putLong(BUNDLE_ANCHOR_UID, anchorId);
        fragment.setArguments(bundle);
        return fragment;
    }

    public static AnchorWorksFragment newInstance(long anchorId, boolean isHitAB) {
        sIsHitAB = isHitAB;
        AnchorWorksFragment fragment = new AnchorWorksFragment();
        Bundle bundle = new Bundle();
        bundle.putLong(BUNDLE_ANCHOR_UID, anchorId);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onResume() {
        super.onResume();
        if (this.mAdapter != null && this.mAdapter.getData().size() <= 0) {
            this.showNoData(this.anchorUid);
        }
    }

    public void onPause() {
        super.onPause();
        MLog.info((String)TAG, (String)"onPause");
    }

    public void onCreate(@org.jetbrains.annotations.Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setParentFragmentVisible(true);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = View.inflate((Context)this.getContext(), (int)R.layout.fragment_anchorworks_stagger_list_newstyle, null);
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.anchorworksList);
        this.mAnchorworksBg = (RelativeLayout)view.findViewById(R.id.anchorworks_bg);
        this.mRefreshLayout = (SmartRefreshLayout)view.findViewById(R.id.anchorworksRefreshLayout);
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initRefreshLayout();
        ((IAnchorWorksCore)CoreManager.getCore(IAnchorWorksCore.class)).requestAnchorWorks(this.anchorUid);
        IAsyncGiftDelegate asyncGiftDelegate = (IAsyncGiftDelegate)ICoreManagerBase.getCore(IAsyncGiftDelegate.class);
        if (!isQueryGiftConfig && asyncGiftDelegate != null) {
            isQueryGiftConfig = true;
            asyncGiftDelegate.queryGiftConfig();
        }
    }

    private void initRefreshLayout() {
        MLog.info((String)TAG, (String)"initRefreshLayout");
        FragmentActivity context = this.getActivity();
        if (context != null) {
            this.mAdapter = new AnchorWorksAdapter((Context)context, this.anchorUid, false, this.isShopPagerPopupComponent);
            this.mAdapter.setHit(sIsHitAB);
            this.mRefreshLayout.setEnableRefresh(false);
            this.mRefreshLayout.setOnLoadmoreListener(new OnLoadmoreListener(){

                public void onLoadmore(RefreshLayout refreshlayout) {
                    ((IAnchorWorksCore)CoreManager.getCore(IAnchorWorksCore.class)).requestAnchorWorksNextPage(AnchorWorksFragment.this.anchorUid);
                }
            });
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new StaggeredGridLayoutManager(2, 1));
            this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new WorkItemDecoration((Context)context));
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onGetAnchorWorks(IAnchorWorksClient_onGetAnchorWorks_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)("onGetAnchorWorks mIsLastPage:" + this.mIsLastPage));
        if (!this.mIsLastPage) {
            long anchorId = busEventArgs.getAnchorId();
            List works = busEventArgs.getWorks();
            this.mRefreshLayout.finishLoadmore();
            int endFlag = busEventArgs.getEndflag();
            MLog.info((String)TAG, (String)("onGetAnchorWorks endFlag:" + endFlag));
            if (anchorId == this.anchorUid) {
                this.mAnchorworksBg.setVisibility(8);
                this.mRefreshLayout.setEnableLoadmore(endFlag != 1);
                this.mAdapter.addData(works);
                boolean bl = this.mIsLastPage = endFlag == 1;
                if (this.mIsLastPage) {
                    this.mAdapter.addData((WorksInfo)NoMoreWorksInfo.INSTANCE);
                }
                this.mAdapter.notifyDataSetChanged();
            }
        }
    }

    @BusEvent
    public void onGetNoData(IAnchorWorksClient_onGetNoData_EventArgs busEventArgs) {
        long anchorId = busEventArgs.getAnchorId();
        this.showNoData(anchorId);
    }

    public void showNoData(long anchorId) {
        if (anchorId == this.anchorUid) {
            this.mAnchorworksBg.setVisibility(0);
            this.mRefreshLayout.setEnableLoadmore(false);
            this.mAdapter.clearData();
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @BusEvent
    public void onPlayVideoDeleted(IShenquClient_onPlayVideoDeleted_EventArgs busEventArgs) {
        long deleteVideo = busEventArgs.getDeleteVideo();
        if (deleteVideo != 0L && this.mAdapter != null) {
            List<WorksInfo> shortVideoEntityList = this.mAdapter.getData();
            Iterator<WorksInfo> it = shortVideoEntityList.iterator();
            while (it.hasNext()) {
                WorksInfo bean = it.next();
                if (!bean.worksType.equals("2") || !(bean instanceof SmallVideoWorksInfo)) continue;
                SmallVideoWorksInfo smallVideoWorksInfo = (SmallVideoWorksInfo)bean;
                if (!String.valueOf(deleteVideo).equals(smallVideoWorksInfo.resid)) continue;
                it.remove();
                break;
            }
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @BusEvent
    public void onDeleteMobileLiveReplaySuccess(IMobileLiveClient_onDeleteMobileLiveReplaySuccess_EventArgs busEventArgs) {
        String progamId = busEventArgs.getProgamId();
        if (progamId != null && !progamId.isEmpty() && this.mAdapter != null) {
            List<WorksInfo> replayVideoEntityList = this.mAdapter.getData();
            Iterator<WorksInfo> it = replayVideoEntityList.iterator();
            while (it.hasNext()) {
                WorksInfo bean = it.next();
                if (!bean.worksType.equals("0") || !(bean instanceof RePlayWorksInfo)) continue;
                RePlayWorksInfo rePlayWorksInfo = (RePlayWorksInfo)bean;
                if (!progamId.equals(rePlayWorksInfo.liveId)) continue;
                it.remove();
                break;
            }
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public View getScrollableView() {
        return this.mRecyclerView;
    }

    public void onFragmentFirstVisible() {
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new AnchorWorksFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    private static class WorkItemDecoration
    extends RecyclerView.ItemDecoration {
        private final int dp3;
        private final int dp1point5;
        private final int topSpacing;

        private WorkItemDecoration(@NonNull Context context) {
            this.dp3 = DensityUtil.dip2px((Context)context, (float)5.0f);
            this.dp1point5 = this.dp3 / 2;
            this.topSpacing = DensityUtil.dip2px((Context)context, (float)5.0f);
        }

        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            int pos = parent.getChildAdapterPosition(view);
            if (pos % 2 == 0) {
                outRect.set(this.dp3, 0, this.dp1point5, this.dp3);
            } else {
                outRect.set(this.dp1point5, 0, this.dp3, this.dp3);
            }
            if (pos < 2) {
                outRect.top = this.topSpacing;
            }
        }
    }
}

