/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.anchor;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.dialog.ButtonItem;
import com.yy.mobile.ui.dialog.IDialogLinkManagerCore;
import com.yy.mobile.ui.profile.anchor.AnchorGalleryFragment;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.widget.ImageManageGridLayout;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.gallery.IGalleryCore;
import com.yymobile.core.gallery.IPhotoWatchCountCore;
import com.yymobile.core.gallery.module.AlbumInfo;
import com.yymobile.core.gallery.module.PhotoInfo;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.ArrayList;
import java.util.List;

public class AnchorGalleryListAdapter
extends BaseAdapter
implements View.OnClickListener,
ImageManageGridLayout.OnItemClickListener {
    private static final String TAG = "AnchorGalleryListAdapter";
    private List<AlbumInfo> mData;
    private LayoutInflater mInflater;
    private AnchorGalleryFragment mFragment;
    private long mAnchorId;
    private final ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();

    public AnchorGalleryListAdapter(long anchorId, AnchorGalleryFragment fragment, LayoutInflater inflater) {
        this.mData = new ArrayList<AlbumInfo>();
        this.mInflater = inflater;
        this.mFragment = fragment;
        this.mAnchorId = anchorId;
    }

    public int getCount() {
        return this.mData.size();
    }

    public Object getItem(int i) {
        return this.mData.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int i, View convertView, ViewGroup viewGroup) {
        ViewHolder vh;
        AlbumInfo info = this.mData.get(i);
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.anchor_gallery_main_item, null);
            vh = new ViewHolder();
            vh.operator = convertView.findViewById(R.id.anchor_gallery_main_item_operation);
            vh.operator.setOnClickListener((View.OnClickListener)this);
            vh.arrow = (ImageView)convertView.findViewById(R.id.gallery_more_arrow);
            vh.albumName = (TextView)convertView.findViewById(R.id.anchor_gallery_main_item_title);
            vh.lastUpdateTime = (TextView)convertView.findViewById(R.id.anchor_gallery_main_item_update_time);
            vh.previewGallery = (ImageManageGridLayout)convertView.findViewById(R.id.anchor_gallery_main_item_preview);
            vh.previewGallery.setMaxCount(8);
            vh.previewGallery.setItemMargin(1);
            vh.previewGallery.setEmptyResId(R.drawable.icon_no_photo);
            TextView total = new TextView(viewGroup.getContext());
            total.setId(R.id.gallery_more);
            total.setGravity(17);
            total.setTextColor(viewGroup.getContext().getResources().getColor(R.color.white));
            total.setTextSize(12.0f);
            total.setOnClickListener((View.OnClickListener)this);
            vh.previewGallery.setOnItemClickListener((ImageManageGridLayout.OnItemClickListener)this);
            total.setBackgroundResource(R.drawable.bg_round_corner_gallery_bg);
            vh.previewGallery.setOperationBtn((View)total, 7);
            vh.totalBtn = total;
            convertView.setTag((Object)vh);
        }
        vh = (ViewHolder)convertView.getTag();
        if (((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).hasCreateRule(this.mAnchorId)) {
            vh.operator.setVisibility(0);
            vh.arrow.setVisibility(8);
        } else {
            vh.operator.setVisibility(4);
            vh.arrow.setVisibility(0);
        }
        try {
            vh.operator.setTag((Object)info);
            vh.previewGallery.setTag((Object)info);
            vh.albumName.setText((CharSequence)info.albumName);
            vh.lastUpdateTime.setText((CharSequence)String.valueOf(info.lastUpdateTime));
            vh.totalBtn.setText((CharSequence)String.format("\u67e5\u770b\u5168\u90e8\n%d\u5f20", info.totalNum));
            vh.totalBtn.setTag((Object)info);
            ArrayList<String> photos = new ArrayList<String>(info.photos.size());
            for (int j = 0; j < info.photos.size(); ++j) {
                photos.add(((PhotoInfo)info.photos.get((int)j)).thumbsUrl);
            }
            vh.previewGallery.setImageList(photos);
        }
        catch (Exception ex) {
            MLog.info((String)TAG, (String)"getViewException");
        }
        return convertView;
    }

    public void insertData(AlbumInfo album) {
        this.mData.add(0, album);
        this.notifyDataSetChanged();
    }

    public void addData(List<AlbumInfo> list) {
        this.mData.addAll(list);
        this.notifyDataSetChanged();
    }

    public void setData(List<AlbumInfo> list) {
        this.mData.clear();
        this.addData(list);
    }

    public void removeData(long albumId) {
        for (int i = 0; i < this.mData.size(); ++i) {
            AlbumInfo info = this.mData.get(i);
            if (info.albumId != albumId) continue;
            this.mData.remove(i);
            this.notifyDataSetChanged();
            return;
        }
    }

    public void changeName(long albumId, String newName) {
        for (AlbumInfo info : this.mData) {
            if (info.albumId != albumId) continue;
            info.albumName = newName;
            this.notifyDataSetChanged();
            return;
        }
    }

    private List<ButtonItem> initOperateDialog(final AlbumInfo info) {
        ArrayList<ButtonItem> dialogItems = new ArrayList<ButtonItem>();
        ButtonItem btnItem1 = new ButtonItem(this.mFragment.getString(R.string.str_upload_picture), new ButtonItem.OnClickListener(){

            public void onClick() {
                AnchorGalleryListAdapter.this.mFragment.toUpload(info);
            }
        });
        dialogItems.add(btnItem1);
        ButtonItem btnItem2 = new ButtonItem(this.mFragment.getString(R.string.str_delete_gallery), new ButtonItem.OnClickListener(){

            public void onClick() {
                List dialogItems = AnchorGalleryListAdapter.this.initDeleteConfirmDialog(info);
                ((IDialogLinkManagerCore)ICoreManagerBase.getCore(IDialogLinkManagerCore.class)).getDialogLinkManager().showCommonPopupDialog("\u786e\u8ba4\u5220\u9664\uff1f", dialogItems, AnchorGalleryListAdapter.this.mFragment.getString(R.string.str_cancel), true, true);
            }
        });
        dialogItems.add(btnItem2);
        return dialogItems;
    }

    private List<ButtonItem> initDeleteConfirmDialog(final AlbumInfo info) {
        ArrayList<ButtonItem> dialogItems = new ArrayList<ButtonItem>();
        ButtonItem btnItem1 = new ButtonItem(this.mFragment.getString(R.string.str_delete), new ButtonItem.OnClickListener(){

            public void onClick() {
                AnchorGalleryListAdapter.this.mFragment.deleteAlbum(info.albumId);
            }
        });
        dialogItems.add(btnItem1);
        return dialogItems;
    }

    public void onClick(View v) {
        if (this.mTimeSlotTool.isProcessing()) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.anchor_gallery_main_item_operation) {
            AlbumInfo info = (AlbumInfo)v.getTag();
            List<ButtonItem> dialogItems = this.initOperateDialog(info);
            ((IDialogLinkManagerCore)ICoreManagerBase.getCore(IDialogLinkManagerCore.class)).getDialogLinkManager().showCommonPopupDialog(dialogItems, this.mFragment.getString(R.string.str_cancel), true, true);
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1001", "0004");
        } else if (id2 == R.id.gallery_more) {
            AlbumInfo info2 = (AlbumInfo)v.getTag();
            NavigationUtils.toStaggeredGridAcitivity(v.getContext(), this.mAnchorId, info2.albumName, info2.albumId);
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1001", "0003");
        }
    }

    public void onItemClick(ViewGroup parent, View view, int position) {
        if (this.mTimeSlotTool.isProcessing()) {
            return;
        }
        AlbumInfo albumInfo = (AlbumInfo)parent.getTag();
        if (albumInfo.photos.size() == 0) {
            return;
        }
        if (position >= albumInfo.photos.size()) {
            position = 0;
        }
        NavigationUtils.toGalleryNewDetailActivity(parent.getContext(), this.mAnchorId, albumInfo.albumId, (PhotoInfo)albumInfo.photos.get(position), 1, false, 0, 100);
        ((IPhotoWatchCountCore)CoreManager.getCore(IPhotoWatchCountCore.class)).addGalleryStatics(this.mAnchorId, albumInfo.albumId, 1);
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1001", "0002");
    }

    private static class ViewHolder {
        public TextView albumName;
        public TextView lastUpdateTime;
        public ImageManageGridLayout previewGallery;
        public TextView totalBtn;
        public View operator;
        public ImageView arrow;

        private ViewHolder() {
        }
    }
}

