/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.anchor;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.event.exp.LoginApi;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IGalleryClient_onBatchDetelePhoto_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onCreateAlbum_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onDeleteAlbum_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onGetAuthFinish_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onModifyAlbum_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onQueryGalleryMainList_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onUploadFinish_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onUploadProgress_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onUploadStart_EventArgs;
import com.yy.mobile.plugin.main.events.IProfileClient_onRequestProfile_EventArgs;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.dialog.DialogLinkManager;
import com.yy.mobile.ui.gallery.PhotoUploadActivity;
import com.yy.mobile.ui.profile.anchor.AnchorGalleryFragment$$EventBinder;
import com.yy.mobile.ui.profile.anchor.AnchorGalleryListAdapter;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.dialog.InputDialog;
import com.yy.mobile.ui.utils.dialog.InputDialogListener;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.ui.widget.headerviewpager.AbsListViewDelegate;
import com.yy.mobile.ui.widget.headerviewpager.ScrollableListener;
import com.yy.mobile.ui.widget.headerviewpager.StickyViewListener;
import com.yy.mobile.ui.widget.headerviewpager.ViewDelegate;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.PhotoUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.gallery.IGalleryCore;
import com.yymobile.core.gallery.IPhotoWatchCountCore;
import com.yymobile.core.gallery.module.AlbumInfo;
import com.yymobile.core.gallery.module.UploadStatus;
import com.yymobile.core.profile.EntUserInfo;
import com.yymobile.core.profile.IProfileCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AnchorGalleryFragment
extends BaseLinkFragment
implements ScrollableListener<AbsListView>,
View.OnClickListener,
PullToRefreshBase.OnRefreshListener2,
EndlessListScrollListener.EndlessListener,
StickyViewListener,
AdapterView.OnItemClickListener {
    private static final String TAG = "AnchorGalleryFragment";
    public static final String MOMENT_GALLERY_TYPE = "dynamic";
    private static final int PAGE_SIZE = 10;
    private long loginUserId;
    private long mAnchorId;
    private int mPageNo = 1;
    private boolean mIsLastPage;
    private AlbumInfo mPendingUploadAlbum;
    private PullToRefreshListView mMainGalleryList;
    private Button mCreateGalleryBtn;
    private Button mUploadBtn;
    private FrameLayout noDataLayout;
    private TextView mUploadProgress;
    private StatusLayout mLayout;
    private TextView mEmptyViewTips;
    private View mOperatorView;
    private AnchorGalleryListAdapter mGalleryAdapter;
    private boolean isAnchor = false;
    private EndlessListScrollListener mEndlessListScrollListener;
    public boolean isVisibleHiddle = false;
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();
    private AbsListViewDelegate mViewDelegate = new AbsListViewDelegate();
    private EventBinder mEventBinder;

    public static AnchorGalleryFragment newInstance(long anchorId) {
        AnchorGalleryFragment fragment = new AnchorGalleryFragment();
        Bundle bundle = new Bundle();
        bundle.putLong("extra_anchor_uid", anchorId);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onResume() {
        super.onResume();
        this.isVisibleHiddle = true;
        if (((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getIsDeleteRefresh()) {
            this.refresh();
        }
    }

    public void onPause() {
        super.onPause();
        this.isVisibleHiddle = false;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mAnchorId = this.getArguments().getLong("extra_anchor_uid");
        }
        this.loginUserId = LoginUtil.getUid();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        StatusLayout sl;
        View root = inflater.inflate(R.layout.fragment_anchor_gallery, container, false);
        this.mMainGalleryList = (PullToRefreshListView)root.findViewById(R.id.anchor_gallery_main_list);
        this.mMainGalleryList.setHeaderBackgroundColor(this.getResources().getColor(R.color.common_f1_color));
        this.mCreateGalleryBtn = (Button)root.findViewById(R.id.anchor_gallery_main_create_gallery);
        this.mUploadBtn = (Button)root.findViewById(R.id.anchor_gallery_main_upload_picture);
        this.noDataLayout = (FrameLayout)root.findViewById(R.id.anchor_gallery_main_layout);
        this.mMainGalleryList.setOnRefreshListener((PullToRefreshBase.OnRefreshListener2)this);
        this.mLayout = sl = (StatusLayout)root.findViewById(R.id.anchor_gallery_main_status_container);
        this.mEndlessListScrollListener = new EndlessListScrollListener(sl);
        this.mEndlessListScrollListener.setListener((EndlessListScrollListener.EndlessListener)this);
        this.mMainGalleryList.setOnScrollListener((AbsListView.OnScrollListener)this.mEndlessListScrollListener);
        this.mCreateGalleryBtn.setOnClickListener((View.OnClickListener)this);
        this.mUploadBtn.setOnClickListener((View.OnClickListener)this);
        this.mMainGalleryList.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mUploadProgress = (TextView)root.findViewById(R.id.anchor_gallery_main_progress);
        this.mGalleryAdapter = new AnchorGalleryListAdapter(this.mAnchorId, this, inflater);
        this.mEmptyViewTips = (TextView)root.findViewById(R.id.empty_view_anchor_gallery_tips);
        this.mMainGalleryList.setAdapter((ListAdapter)this.mGalleryAdapter);
        this.mOperatorView = root.findViewById(R.id.ll_anchor_gallery_main_operator);
        if (((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).isUploading()) {
            UploadStatus us = ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getUploadStatus();
            this.mUploadProgress.setText((CharSequence)String.format("\u6b63\u5728\u4e0a\u4f20 %d/%d", us.currentUploadingIndex + 1, us.uploadingCount));
            this.mUploadProgress.setVisibility(0);
        }
        ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).queryGalleryRule(this.mAnchorId);
        EntUserInfo userInfo = ((IProfileCore)CoreManager.getCore(IProfileCore.class)).getCachedProfileInfo(this.loginUserId);
        if (userInfo == null) {
            ((IProfileCore)CoreManager.getCore(IProfileCore.class)).requestProfile(this.loginUserId);
        } else {
            this.isAnchor = userInfo.userType == 1;
        }
        this.showLoading((View)sl, 0, 0);
        return root;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 2010 || requestCode == 2011) {
            if (resultCode == -1 && data != null) {
                String[] clipPaths = data.getStringArrayExtra("portrait_clip_key");
                ArrayList<String> selected = null;
                if (clipPaths != null) {
                    selected = new ArrayList<String>(Arrays.asList(clipPaths));
                }
                long albumId = 0L;
                if (this.mPendingUploadAlbum != null) {
                    albumId = this.mPendingUploadAlbum.albumId;
                }
                PhotoUploadActivity.launchPhotoUpload(this.getContext(), this.mAnchorId, albumId, selected);
            }
            this.mPendingUploadAlbum = null;
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onGetAuthFinish(IGalleryClient_onGetAuthFinish_EventArgs busEventArgs) {
        boolean result = busEventArgs.getResult();
        MLog.info((Object)TAG, (String)"onGetAuthFinish: %b", (Object[])new Object[]{result});
        boolean hasRule = ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).hasCreateRule(this.mAnchorId);
        if (!hasRule) {
            this.mEmptyViewTips.setText(R.string.str_nodata_gallery_rule1);
        } else {
            this.mOperatorView.setVisibility(0);
            this.mEmptyViewTips.setText(R.string.str_nodata_gallery_rule2);
        }
        if (this.isVisibleHiddle) {
            ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).queryGalleryMainList(this.mAnchorId, this.mPageNo, 10);
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onQueryGalleryMainList(IGalleryClient_onQueryGalleryMainList_EventArgs busEventArgs) {
        List galleryList = busEventArgs.getGalleryList();
        int pageNo = busEventArgs.getPageNo();
        boolean isEnd = busEventArgs.getIsEnd();
        long anchorId = busEventArgs.getAnchorId();
        this.hideStatus();
        if (this.mAnchorId == anchorId) {
            this.noDataLayout.setVisibility(8);
            if (pageNo == 1) {
                this.mMainGalleryList.onRefreshComplete();
                if (galleryList == null) {
                    this.showReload();
                } else {
                    this.mGalleryAdapter.setData(galleryList);
                }
            } else {
                this.mEndlessListScrollListener.onLoadComplete();
                if (galleryList == null) {
                    this.showPageError(0);
                    this.checkNetToast();
                } else {
                    this.mGalleryAdapter.addData(galleryList);
                }
            }
            this.mIsLastPage = isEnd;
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onBatchDetelePhoto(IGalleryClient_onBatchDetelePhoto_EventArgs busEventArgs) {
        if (this.isVisibleHiddle) {
            this.refresh();
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onCreateAlbum(IGalleryClient_onCreateAlbum_EventArgs busEventArgs) {
        boolean result = busEventArgs.getResult();
        String msg = busEventArgs.getMsg();
        AlbumInfo albumInfo = busEventArgs.getAlbumInfo();
        int identify = busEventArgs.getIdentify();
        if (result) {
            this.mGalleryAdapter.insertData(albumInfo);
            if (identify == 1) {
                Toast.makeText((Context)BasicConfig.getInstance().getAppContext(), (int)R.string.str_create_gallery_success_tips, (int)0).show();
            }
        } else if (identify == 1) {
            String tips = this.getString(R.string.str_create_gallery_fail_tips);
            if (!TextUtils.isEmpty((CharSequence)msg)) {
                tips = tips + "\uff0c" + msg;
            }
            Toast.makeText((Context)BasicConfig.getInstance().getAppContext(), (CharSequence)tips, (int)0).show();
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onModifyAlbum(IGalleryClient_onModifyAlbum_EventArgs busEventArgs) {
        boolean result = busEventArgs.getResult();
        long albumId = busEventArgs.getAlbumId();
        String newName = busEventArgs.getNewName();
        if (result) {
            this.mGalleryAdapter.changeName(albumId, newName);
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onDeleteAlbum(IGalleryClient_onDeleteAlbum_EventArgs busEventArgs) {
        boolean result = busEventArgs.getResult();
        String msg = busEventArgs.getMsg();
        long anchorId = busEventArgs.getAnchorId();
        long albumId = busEventArgs.getAlbumId();
        if (this.mAnchorId != anchorId) {
            return;
        }
        if (result) {
            this.mGalleryAdapter.removeData(albumId);
            Toast.makeText((Context)this.getActivity(), (int)R.string.str_delete_gallery_success_tips, (int)0).show();
        } else {
            String tips = this.getString(R.string.str_delete_gallery_fail_tips);
            if (!TextUtils.isEmpty((CharSequence)msg)) {
                tips = tips + "\uff0c" + msg;
            }
            Toast.makeText((Context)BasicConfig.getInstance().getAppContext(), (CharSequence)tips, (int)0).show();
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onUploadStart(IGalleryClient_onUploadStart_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)"onUploadStart");
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onUploadProgress(IGalleryClient_onUploadProgress_EventArgs busEventArgs) {
        int currentUploadingIndex = busEventArgs.getCurrentUploadingIndex();
        int totalUploadCount = busEventArgs.getTotalUploadCount();
        MLog.info((Object)TAG, (String)"onUploadProgress: %d/%d", (Object[])new Object[]{currentUploadingIndex + 1, totalUploadCount});
        this.mUploadProgress.setText((CharSequence)String.format("\u6b63\u5728\u4e0a\u4f20 %d/%d", currentUploadingIndex + 1, totalUploadCount));
        this.mUploadProgress.setVisibility(0);
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onUploadFinish(IGalleryClient_onUploadFinish_EventArgs busEventArgs) {
        int successCount = busEventArgs.getSuccessCount();
        int failCount = busEventArgs.getFailCount();
        String errMsg = busEventArgs.getErrMsg();
        MLog.info((Object)TAG, (String)"onUploadFinish. %d,%d", (Object[])new Object[]{successCount, failCount});
        this.mUploadProgress.setVisibility(8);
        if (failCount <= 0) {
            Toast.makeText((Context)this.getContext(), (int)R.string.str_upload_success, (int)0).show();
        } else if (failCount == 10000) {
            if (!StringUtils.isEmpty((String)errMsg).booleanValue()) {
                Toast.makeText((Context)this.getContext(), (CharSequence)errMsg, (int)0).show();
            }
            this.mUploadProgress.setVisibility(8);
        } else {
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.str_upload_fail, new Object[]{failCount}), (int)0).show();
        }
        this.refresh();
    }

    public void toUpload(AlbumInfo albumInfo) {
        this.mPendingUploadAlbum = albumInfo;
        PhotoUtils.choosePhoto(null, (Fragment)this, null, (boolean)true);
    }

    private void refresh() {
        this.mPageNo = 1;
        ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).queryGalleryMainList(this.mAnchorId, this.mPageNo, 10);
    }

    private void loadMore() {
        ++this.mPageNo;
        ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).queryGalleryMainList(this.mAnchorId, this.mPageNo, 10);
    }

    public void deleteAlbum(long albumId) {
        ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).deleteAlbum(albumId, this.mAnchorId);
    }

    public ViewDelegate<AbsListView> getViewDelegate() {
        return this.mViewDelegate;
    }

    public AbsListView getDelegateView() {
        return (AbsListView)this.mMainGalleryList.getRefreshableView();
    }

    public View getStickyBottomView() {
        return this.mOperatorView;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.anchor_gallery_main_create_gallery) {
            if (!LoginApi.INSTANCE.getILoginApi().hasSpeakOrModifyInfoAuth(true)) {
                MLog.info((String)TAG, (String)"create gallery user not has auth");
                return;
            }
            if (!this.isAnchor) {
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1005", "0001");
            }
            new DialogLinkManager(this.getContext()).showDialog((IBaseDialog)new InputDialog(this.getContext(), (CharSequence)"\u65b0\u5efa\u76f8\u518c", (CharSequence)"\u4e3a\u65b0\u76f8\u518c\u8f93\u5165\u540d\u5b57", (CharSequence)"10\u4e2a\u5b57\u4ee5\u5185", null, null, true, true, true, new InputDialogListener(){

                public void cancel() {
                }

                public boolean confirm(String input) {
                    if (TextUtils.isEmpty((CharSequence)(input = input.trim()))) {
                        Toast.makeText((Context)AnchorGalleryFragment.this.getContext(), (int)R.string.str_create_gallery_null, (int)0).show();
                        return false;
                    }
                    if (input.length() > 10) {
                        Toast.makeText((Context)AnchorGalleryFragment.this.getContext(), (int)R.string.str_create_gallery_over_limit, (int)0).show();
                        return false;
                    }
                    ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).createAlbum(AnchorGalleryFragment.this.mAnchorId, input, "", 1);
                    return true;
                }

                public void onExit() {
                }
            }, false));
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1001", "0007");
        } else if (id2 == R.id.anchor_gallery_main_upload_picture) {
            if (!this.isAnchor) {
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1005", "0002");
            }
            PhotoUtils.choosePhoto(null, (Fragment)this, null, (boolean)true);
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1001", "0006");
        }
    }

    public void onPullDownToRefresh(PullToRefreshBase refreshView) {
        this.refresh();
    }

    public void onPullUpToRefresh(PullToRefreshBase refreshView) {
    }

    public void onLoadData() {
        this.loadMore();
    }

    public boolean shouldLoadData() {
        return !this.mIsLastPage;
    }

    public View.OnClickListener getLoadListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                AnchorGalleryFragment.this.refresh();
                AnchorGalleryFragment.this.showLoading((View)AnchorGalleryFragment.this.mLayout, 0, 0);
            }
        };
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
        if (this.mTimeSlotTool.isProcessing()) {
            return;
        }
        AlbumInfo info = (AlbumInfo)adapterView.getAdapter().getItem(i);
        if (info != null) {
            NavigationUtils.toStaggeredGridAcitivity((Context)this.getActivity(), this.mAnchorId, info.albumName, info.albumId);
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1001", "0003");
        }
    }

    @BusEvent
    public void onRequestProfile(IProfileClient_onRequestProfile_EventArgs busEventArgs) {
        EntUserInfo info = busEventArgs.getInfo();
        if (info == null) {
            return;
        }
        this.isAnchor = info.userType == 1;
    }

    public void onDestroy() {
        super.onDestroy();
        ((IPhotoWatchCountCore)CoreManager.getCore(IPhotoWatchCountCore.class)).sendGalleryStatics();
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new AnchorGalleryFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

