/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.anchor;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.channel.sendheart.LevelHelp;
import java.util.List;
import java.util.Map;

public class AnchorFansListAdapter
extends BaseAdapter {
    private long anchorUid = 0L;
    private Context mContext;
    private List<Map<String, String>> data;

    public void setAnchorId(long anchorId) {
        this.anchorUid = anchorId;
    }

    public AnchorFansListAdapter(Context context, List<Map<String, String>> data) {
        this.mContext = context;
        this.data = data;
    }

    public List<Map<String, String>> getData() {
        return this.data;
    }

    public int getCount() {
        return this.data.size();
    }

    public Map<String, String> getItem(int i) {
        return this.data.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        Object info = this.getItem(position);
        if (info == null) {
            return null;
        }
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_anchor_fans_item, parent, false);
            holder = new ViewHolder();
            holder.rankId = (TextView)convertView.findViewById(R.id.rank_id);
            holder.nick = (TextView)convertView.findViewById(R.id.anchor_fans_nick);
            holder.qinmidu = (TextView)convertView.findViewById(R.id.qinmidu);
            holder.logo = (CircleImageView)convertView.findViewById(R.id.anchor_fans_logo);
            holder.qinmiduLv = (RecycleImageView)convertView.findViewById(R.id.qinmidu_lv);
            holder.rankIcon = (RecycleImageView)convertView.findViewById(R.id.rank_icon);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        String rankId = info.get("id").toString();
        if (rankId.equals("1")) {
            ImageLoader.loadImageResource((int)R.drawable.fans_rank_1, (RecycleImageView)holder.rankIcon, (ImageConfig)ImageConfig.defaultImageConfig());
            holder.rankIcon.setVisibility(0);
            holder.rankId.setVisibility(8);
        } else if (rankId.equals("2")) {
            ImageLoader.loadImageResource((int)R.drawable.fans_rank_2, (RecycleImageView)holder.rankIcon, (ImageConfig)ImageConfig.defaultImageConfig());
            holder.rankIcon.setVisibility(0);
            holder.rankId.setVisibility(8);
        } else if (rankId.equals("3")) {
            ImageLoader.loadImageResource((int)R.drawable.fans_rank_3, (RecycleImageView)holder.rankIcon, (ImageConfig)ImageConfig.defaultImageConfig());
            holder.rankIcon.setVisibility(0);
            holder.rankId.setVisibility(8);
        } else {
            holder.rankId.setVisibility(0);
            holder.rankIcon.setVisibility(8);
        }
        if (rankId != null) {
            holder.rankId.setText((CharSequence)rankId);
        }
        if (info.get("photoUrl") != null) {
            ImageLoader.loadImage((String)info.get("photoUrl").toString(), (RecycleImageView)holder.logo, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
        }
        if (info.get("nick") != null) {
            holder.nick.setText((CharSequence)info.get("nick").toString());
        }
        if (info.get("qinmidu") != null) {
            holder.qinmidu.setText((CharSequence)info.get("qinmidu").toString());
        }
        if (info.get("lv") != null) {
            int lv = Integer.parseInt(info.get("lv").toString());
            ImageLoader.loadImageResource((int)LevelHelp.getClosnessLevelDrawable(lv), (RecycleImageView)holder.qinmiduLv, (ImageConfig)ImageConfig.defaultImageConfig());
        }
        return convertView;
    }

    static class ViewHolder {
        TextView rankId;
        TextView nick;
        TextView qinmidu;
        CircleImageView logo;
        RecycleImageView qinmiduLv;
        RecycleImageView rankIcon;

        ViewHolder() {
        }
    }
}

