/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.anchor;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IArtistClient_onAnchorFansList_EventArgs;
import com.yy.mobile.plugin.main.events.IArtistClient_onMyFansListInfo_EventArgs;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.channel.sendheart.LevelHelp;
import com.yy.mobile.ui.profile.anchor.AnchorFansListActivity$$EventBinder;
import com.yy.mobile.ui.profile.anchor.AnchorFansListAdapter;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.BlankUtil;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.CoreManager;
import com.yymobile.core.artist.IArtistCore;
import com.yymobile.core.businesstranport.TrueLoveInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class AnchorFansListActivity
extends BaseActivity {
    public static final String ANCHOR_UID = "anchor_uid";
    private long anchorId = 0L;
    private int pageNo = 1;
    private int pageSize = 20;
    private boolean isLastPage = false;
    private boolean shouldClear = true;
    private EndlessListScrollListener mEndlessListScrollListener;
    private Handler hideLoadingHandler;
    private Runnable hideLoadingCb;
    private Bundle savedState;
    private PullToRefreshListView listView;
    private AnchorFansListAdapter fansListAdapter;
    private View layoutPosition;
    private RecycleImageView myQinmiduLv;
    private TextView myQinmidu;
    private TextView myRank;
    private EventBinder mEventBinder;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.savedState = savedInstanceState;
        this.setContentView(R.layout.layout_anchor_fans_list);
        this.anchorId = this.savedState != null ? this.savedState.getLong(ANCHOR_UID) : this.getIntent().getLongExtra(ANCHOR_UID, 0L);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)"hsj", (String)("AnchorFansListActivity anchorId=" + this.anchorId));
        }
        this.layoutPosition = this.findViewById(R.id.layout_position);
        this.myQinmiduLv = (RecycleImageView)this.findViewById(R.id.my_qinmidu_lv);
        this.myQinmidu = (TextView)this.findViewById(R.id.my_qinmidu);
        this.myRank = (TextView)this.findViewById(R.id.my_rank);
        SimpleTitleBar mTitleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                AnchorFansListActivity.this.finish();
            }
        });
        mTitleBar.setTitlte("\u7c89\u4e1d\u6392\u884c\u699c");
        this.listView = (PullToRefreshListView)this.findViewById(R.id.anchor_fans_list_view);
        this.listView.setMode(PullToRefreshBase.Mode.PULL_FROM_START);
        this.listView.setScrollingWhileRefreshingEnabled(true);
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        this.fansListAdapter = new AnchorFansListAdapter((Context)this, data);
        this.listView.setAdapter((ListAdapter)this.fansListAdapter);
        this.fansListAdapter.notifyDataSetChanged();
        this.listView.setOnRefreshListener((PullToRefreshBase.OnRefreshListener2)new PullToRefreshBase.OnRefreshListener2<ListView>(){

            public void onPullDownToRefresh(PullToRefreshBase<ListView> refreshView) {
                if (!AnchorFansListActivity.this.checkNetToast()) {
                    AnchorFansListActivity.this.getHandler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            AnchorFansListActivity.this.listView.onRefreshComplete();
                        }
                    }, 500L);
                } else {
                    AnchorFansListActivity.this.shouldClear = true;
                    AnchorFansListActivity.this.pageNo = 1;
                    AnchorFansListActivity.this.isLastPage = false;
                    ((IArtistCore)CoreManager.getCore(IArtistCore.class)).queryMyFansListInfo(LoginUtil.getUid(), AnchorFansListActivity.this.anchorId);
                    AnchorFansListActivity.this.reqFansList();
                }
            }

            public void onPullUpToRefresh(PullToRefreshBase<ListView> refreshView) {
            }
        });
        this.mEndlessListScrollListener = new EndlessListScrollListener((StatusLayout)this.findViewById(R.id.status_container));
        this.mEndlessListScrollListener.setListener(new EndlessListScrollListener.EndlessListener(){

            public void onLoadData() {
                AnchorFansListActivity.this.shouldClear = false;
                AnchorFansListActivity.this.pageNo++;
                AnchorFansListActivity.this.reqFansList();
            }

            public boolean shouldLoadData() {
                if (AnchorFansListActivity.this.isLastPage || !AnchorFansListActivity.this.isNetworkAvailable()) {
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            AnchorFansListActivity.this.mEndlessListScrollListener.onLoadComplete();
                        }
                    }, 500L);
                    return false;
                }
                return true;
            }
        });
        this.listView.setOnScrollListener((AbsListView.OnScrollListener)this.mEndlessListScrollListener);
        ((IArtistCore)CoreManager.getCore(IArtistCore.class)).queryMyFansListInfo(LoginUtil.getUid(), this.anchorId);
        this.reqFansList();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putLong(ANCHOR_UID, this.anchorId);
    }

    private void reqFansList() {
        ((IArtistCore)CoreManager.getCore(IArtistCore.class)).queryAnchorFansList(this.anchorId, this.pageNo, this.pageSize);
        this.showListStatusForTimeout();
    }

    private void showListStatusForTimeout() {
        if (this.hideLoadingHandler == null) {
            this.hideLoadingHandler = new Handler();
            this.hideLoadingCb = new Runnable(){

                @Override
                public void run() {
                    AnchorFansListActivity.this.hideStatus();
                    AnchorFansListActivity.this.mEndlessListScrollListener.onLoadComplete();
                    AnchorFansListActivity.this.listView.onRefreshComplete();
                    if (AnchorFansListActivity.this.fansListAdapter.getData().isEmpty()) {
                        if (LoginUtil.isDisconnectButHaveLogined()) {
                            AnchorFansListActivity.this.showReload(R.drawable.icon_error_newstyle, R.string.click_screen_reload);
                        } else {
                            AnchorFansListActivity.this.showReload(R.drawable.icon_neirongkong, R.string.click_login);
                        }
                    }
                }
            };
        } else {
            this.hideLoadingHandler.removeCallbacks(this.hideLoadingCb);
        }
        if (this.isLogined()) {
            this.hideLoadingHandler.postDelayed(this.hideLoadingCb, 6000L);
        } else {
            this.hideLoadingCb.run();
        }
    }

    private synchronized void updateData(List<Map<String, String>> fansList) {
        if (this.shouldClear) {
            this.fansListAdapter.getData().clear();
        }
        this.fansListAdapter.setAnchorId(this.anchorId);
        this.fansListAdapter.getData().addAll(fansList);
        this.fansListAdapter.notifyDataSetChanged();
        this.listView.onRefreshComplete();
        this.mEndlessListScrollListener.onLoadComplete();
    }

    public View.OnClickListener getLoadListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                if (AnchorFansListActivity.this.isLogined()) {
                    if (AnchorFansListActivity.this.isNetworkAvailable()) {
                        AnchorFansListActivity.this.showLoading();
                    }
                    AnchorFansListActivity.this.reqFansList();
                } else {
                    AnchorFansListActivity.this.showLoginDialog();
                }
            }
        };
    }

    @BusEvent
    public void onMyFansListInfo(IArtistClient_onMyFansListInfo_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long uid = busEventArgs.getUid();
        long anchorId = busEventArgs.getAnchorId();
        Map mInfo = busEventArgs.getMInfo();
        int limit = busEventArgs.getLimit();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)"hsj", (String)("AnchorFansListActivity onMyFansListInfo result=" + result));
        }
        if (LoginUtil.getUid() == uid && this.anchorId == anchorId && result == 0 && LoginUtil.getUid() != this.anchorId && mInfo.get("isfans") != null && ((String)mInfo.get("isfans")).equals("1")) {
            if (mInfo.get("lv") != null && this.myQinmiduLv != null) {
                int lv = Integer.parseInt(((String)mInfo.get("lv")).toString());
                Uint32 currentAnchorId = new Uint32(anchorId);
                if (TrueLoveInfo.MyTrueLoveInfo.isTrueLoveUser((Uint32)currentAnchorId)) {
                    ImageLoader.loadImageResource((int)LevelHelp.getTrueLoveLevelDrawable(lv), (RecycleImageView)this.myQinmiduLv, (ImageConfig)ImageConfig.defaultImageConfig());
                } else {
                    ImageLoader.loadImageResource((int)LevelHelp.getClosnessLevelDrawable(lv), (RecycleImageView)this.myQinmiduLv, (ImageConfig)ImageConfig.defaultImageConfig());
                }
            }
            if (mInfo.get("qinmidu") != null && this.myQinmidu != null) {
                this.myQinmidu.setText((CharSequence)((String)mInfo.get("qinmidu")).toString());
            }
            if (!StringUtils.isEmptyString((String)((String)mInfo.get("id"))) && this.myRank != null) {
                int id2 = Integer.parseInt((String)mInfo.get("id"));
                int n = id2 = id2 > 0 ? id2 : 0;
                if (id2 > limit && limit > 0) {
                    this.myRank.setText((CharSequence)(limit + "+"));
                } else {
                    this.myRank.setText((CharSequence)(id2 + ""));
                }
            }
            this.layoutPosition.setVisibility(0);
            return;
        }
        this.layoutPosition.setVisibility(8);
    }

    @BusEvent
    public void onAnchorFansList(IArtistClient_onAnchorFansList_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long anchorId = busEventArgs.getAnchorId();
        List fansList = busEventArgs.getFansList();
        int pageSize = busEventArgs.getPageSize();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)"hsj", (String)("AnchorFansListActivity onAnchorFansList result=" + result));
        }
        if (this.anchorId == anchorId) {
            this.hideStatus();
            if (this.hideLoadingHandler != null) {
                this.hideLoadingHandler.removeCallbacks(this.hideLoadingCb);
                this.hideLoadingHandler = null;
                this.hideLoadingCb = null;
            }
            if (result != 0) {
                this.showReload(R.drawable.icon_error_newstyle, R.string.click_screen_reload);
            } else if (BlankUtil.isBlank((Collection)fansList)) {
                if (this.anchorId == LoginUtil.getUid()) {
                    this.showNoData(0, R.string.str_my_no_fans);
                } else {
                    this.showNoData(0, R.string.str_ta_no_fans);
                }
            } else {
                if (fansList.size() < pageSize) {
                    this.isLastPage = true;
                }
                this.updateData(fansList);
            }
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new AnchorFansListActivity$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

