/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.popupwebview;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebBackForwardList;
import android.webkit.WebView;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.immersion.CutoutUtils;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.ISharpTabsClient_onSharpInfos_EventArgs;
import com.yy.mobile.ui.basicchanneltemplate.component.BasePopupComponent;
import com.yy.mobile.ui.common.IJsSupportWebApi;
import com.yy.mobile.ui.popupwebview.JsSupporttedPopupComponent$$EventBinder;
import com.yy.mobile.ui.sharpgirls.WebViewFragment;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.utils.MiscUtils;
import com.yy.mobile.ui.utils.js.bridge.ApiChannel;
import com.yy.mobile.ui.widget.CommonTitleFragment;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ImeUtil;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.live.gson.RightBtnInfo;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsSupporttedPopupComponent
extends BasePopupComponent
implements IJsSupportWebApi {
    private static String TAG = "JsSupporttedPopupComponent";
    public static final String WEB_URL = "yyweburl";
    public static final String WEB_TITLE = "yywebtitle";
    public static final String USE_PAGE_TITLE = "usepagetitle";
    public static final String WEBVIEW_FEATURE = "webviewFeature";
    public static final String DISABLE_REFRESH = "disableRefresh";
    public static final String IS_BACK_URL_HISTORY = "is_back_url_history";
    private CommonTitleFragment mTitleFragment;
    private View mRootView;
    private Bundle mJsSupporttedWebApiBundle = new Bundle();
    private boolean mForceUseTitle = true;
    private WebViewFragment mFragment;
    private View.OnClickListener mRightListener = new View.OnClickListener(){

        public void onClick(View v) {
            Object tag = v.getTag();
            MLog.info((String)TAG, (String)("#mRightListener tag = " + tag));
            if (tag == null || !(tag instanceof RightBtnInfo)) {
                return;
            }
            RightBtnInfo info = (RightBtnInfo)tag;
            if (info.selectable && JsSupporttedPopupComponent.this.mTitleFragment != null) {
                JsSupporttedPopupComponent.this.mTitleFragment.updateBtnCheckedState(v, info);
            }
            JsSupporttedPopupComponent.this.mFragment.getApiChanel().onRightBtnClicked((RightBtnInfo)v.getTag());
        }
    };
    private View.OnClickListener finishActivityListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (JsSupporttedPopupComponent.this.mJsSupporttedWebApiBundle.getBoolean(JsSupporttedPopupComponent.IS_BACK_URL_HISTORY, true)) {
                WebBackForwardList backList;
                WebViewFragment webViewFragment = null;
                Fragment object = JsSupporttedPopupComponent.this.getChildFragmentManager().findFragmentByTag("web_content");
                if (object instanceof WebViewFragment) {
                    webViewFragment = (WebViewFragment)object;
                }
                if (webViewFragment != null && webViewFragment.getWebView() != null && webViewFragment.getWebView().canGoBack() && (backList = webViewFragment.getWebView().copyBackForwardList()) != null && backList.getCurrentIndex() > 2) {
                    webViewFragment.getWebView().goBack();
                    return;
                }
            }
            JsSupporttedPopupComponent.this.hide();
        }
    };
    private WebViewFragment.AbsAppearanceCallback mCallback = new WebViewFragment.AbsAppearanceCallback((Activity)this.getActivity()){

        @Override
        public void onReceivedTitle(WebView view, String title) {
            if (JsSupporttedPopupComponent.this.mTitleFragment != null && JsSupporttedPopupComponent.this.mForceUseTitle) {
                JsSupporttedPopupComponent.this.mTitleFragment.setTitleText(title);
            }
        }

        @Override
        protected void handleBackAction(Object data) {
        }

        @Override
        public void changeHeight(int height) {
        }

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favIcon) {
            JsSupporttedPopupComponent.this.mTitleFragment.setBackBtnEnableState(true);
            JsSupporttedPopupComponent.this.mTitleFragment.setBackListener(JsSupporttedPopupComponent.this.finishActivityListener);
            JsSupporttedPopupComponent.this.showBackBtn();
            super.onPageStarted(view, url, favIcon);
        }
    };
    private EventBinder mEventBinder;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getResources().getConfiguration().orientation == 2) {
            this.setStyle(1, R.style.fullscreen_micgragment);
        } else {
            this.setStyle(1, R.style.translucent_micgragment);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.layout_js_web_act, container, false);
        this.mForceUseTitle = this.mJsSupporttedWebApiBundle.getBoolean(USE_PAGE_TITLE, true);
        this.mTitleFragment = (CommonTitleFragment)this.getChildFragmentManager().findFragmentByTag("web_title");
        if (this.mTitleFragment == null) {
            this.mTitleFragment = CommonTitleFragment.getInstance();
        }
        this.mTitleFragment.setTitleText(this.mJsSupporttedWebApiBundle.getString(WEB_TITLE, ""));
        this.mTitleFragment.setBackListener(this.finishActivityListener);
        this.getChildFragmentManager().beginTransaction().replace(R.id.web_title, (Fragment)this.mTitleFragment, "web_title").commitAllowingStateLoss();
        this.mFragment = (WebViewFragment)this.getChildFragmentManager().findFragmentByTag("web_content");
        if (this.mFragment == null) {
            this.mFragment = WebViewFragment.newInstance(this.mJsSupporttedWebApiBundle.getString(WEB_URL));
        }
        this.mFragment.setAppearanceCallback(this.mCallback);
        this.mFragment.setIJsSupportWebApi(this);
        this.mFragment.setWebViewFeature(this.mJsSupporttedWebApiBundle.getInt(WEBVIEW_FEATURE, 1));
        if (this.mJsSupporttedWebApiBundle.getBoolean(DISABLE_REFRESH, false)) {
            this.mFragment.setEnablePullRefresh(false);
        }
        this.getChildFragmentManager().beginTransaction().replace(R.id.web_content, (Fragment)this.mFragment, "web_content").commitAllowingStateLoss();
        return this.mRootView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        View root;
        super.onViewCreated(view, savedInstanceState);
        if (CutoutUtils.needHandleNotch() && !Build.BRAND.equals("HUAWEI") && MiscUtils.isFullScreen() && (root = view.findViewById(R.id.root)) != null) {
            root.setPadding(ScreenUtil.getStatusBarHeight(), 0, 0, 0);
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setWindowAnimations(R.style.DialogAnimation);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog.getWindow().clearFlags(2);
        dialog.getWindow().setLayout(-1, -1);
        return dialog;
    }

    public void show(FragmentManager fm, Bundle data) {
        super.show(fm, data);
        this.mJsSupporttedWebApiBundle = data == null ? new Bundle() : data;
    }

    public void onDismiss(DialogInterface dialog) {
        ImeUtil.hideIME((Context)this.getActivity(), (View)this.mRootView);
        super.onDismiss(dialog);
    }

    public void hide() {
        ImeUtil.hideIME((Context)this.getActivity(), (View)this.mRootView);
        super.hide();
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onSharpInfos(ISharpTabsClient_onSharpInfos_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)"#onSharpInfos");
        Object info = busEventArgs.getInfo();
        if (info instanceof ApiChannel.SharpGirlsInfo) {
            this.handleInfo((ApiChannel.SharpGirlsInfo)info);
        }
    }

    private void handleInfo(ApiChannel.SharpGirlsInfo info) {
        ApiChannel.SharpGirlsInfo.Type type = info.type;
        MLog.verbose((String)TAG, (String)("#handleInfo type = " + (Object)((Object)type)));
        if (type == ApiChannel.SharpGirlsInfo.Type.SET_RIGHT_BTN) {
            this.setRightBtn(info);
        } else if (type == ApiChannel.SharpGirlsInfo.Type.NAV_TITLE_INFO) {
            this.setNavTitle(info);
        } else {
            MLog.warn((String)TAG, (String)("#handleInfo no type match, info = " + info));
        }
    }

    private void setRightBtn(ApiChannel.SharpGirlsInfo info) {
        MLog.info((String)TAG, (String)("#setRightBtn info = " + info));
        if (info.info == null) {
            return;
        }
        if (info.info instanceof JSONArray) {
            JSONArray array = (JSONArray)info.info;
            if (array.length() <= 0) {
                return;
            }
            if (this.mTitleFragment != null) {
                this.mTitleFragment.clearTitle();
            }
            this.addRigthBtn(array);
        } else {
            MLog.warn((String)TAG, (String)"#setRightBtn info is not JSONArray");
        }
    }

    private void setNavTitle(ApiChannel.SharpGirlsInfo info) {
        MLog.verbose((String)TAG, (String)("#setNavTitle SharpGirlsInfo info  = " + info));
        if (info.info == null) {
            return;
        }
        if (info.info instanceof JSONObject) {
            int titleImage = ((JSONObject)info.info).optInt("titleImage");
            JSONArray array = ((JSONObject)info.info).optJSONArray("rightItems");
            String title = ((JSONObject)info.info).optString("title");
            if (titleImage > 0) {
                if (this.mTitleFragment != null) {
                    this.mTitleFragment.setTitleImage(R.drawable.title_1931_logo);
                }
            } else if (!FP.empty((CharSequence)title) && this.mTitleFragment != null) {
                this.mTitleFragment.setTitleText(title);
            }
            this.addRigthBtn(array);
        } else {
            MLog.warn((String)TAG, (String)"#setNavTitle info is not JSONObject");
        }
    }

    private void addRigthBtn(JSONArray array) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.info((String)TAG, (String)("#addRightBtn array = " + array));
        }
        if (this.mTitleFragment != null) {
            this.mTitleFragment.clearTitle();
        }
        if (array == null) {
            MLog.warn((String)TAG, (String)"#addRightBtn array is NULL");
            return;
        }
        try {
            List btns = JsonParser.parseJsonList((String)array.toString(), RightBtnInfo.class);
            if (btns == null || btns.size() <= 0) {
                return;
            }
            if (this.mTitleFragment != null) {
                this.mTitleFragment.setRightContainerWidth(btns.size());
            }
            for (RightBtnInfo sub : btns) {
                if (this.mTitleFragment == null) continue;
                this.mTitleFragment.addRightBtn(sub, this.mRightListener, new float[0]);
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
    }

    public void hideBackBtn() {
        this.mTitleFragment.setBackBtnState(8);
    }

    public void showBackBtn() {
        this.mTitleFragment.setBackBtnState(0);
    }

    public void setNavigationBar(String param, IApiModule.IJSCallback callback) {
        MLog.info((Object)TAG, (String)"#setNavigationBar param = %s", (Object[])new Object[]{param});
        JSONObject jsonObject = null;
        JSONObject titleObj = null;
        JSONObject rightItemObj = null;
        try {
            jsonObject = new JSONObject(param);
            titleObj = jsonObject.optJSONObject("title");
            rightItemObj = jsonObject.optJSONObject("rightItem");
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        if (this.mTitleFragment != null && this.mTitleFragment.isAdded()) {
            if (titleObj != null) {
                this.mTitleFragment.setTitleText(titleObj.optString("title"));
                if (titleObj.has("subTitle") && !TextUtils.isEmpty((CharSequence)titleObj.optString("subTitle"))) {
                    this.mTitleFragment.setSubTitle(titleObj.optString("subTitle"));
                } else {
                    this.mTitleFragment.setSubTitle(null);
                }
                if (titleObj.has("subTitleColor") && !TextUtils.isEmpty((CharSequence)titleObj.optString("subTitleColor"))) {
                    this.mTitleFragment.setSubTitleColor(titleObj.optString("subTitleColor"));
                }
                if (titleObj.has("subTitleTextSize") && titleObj.optInt("subTitleTextSize", 0) > 0) {
                    this.mTitleFragment.setSubTitleSize(titleObj.optInt("subTitleTextSize"));
                }
            }
            if (rightItemObj != null) {
                this.mTitleFragment.clearTitle();
                this.addRightBtn(rightItemObj, callback);
            }
        }
    }

    private void addRightBtn(JSONObject rightItemObj, IApiModule.IJSCallback callback) {
        this.addRightBtn(rightItemObj, callback, 0);
    }

    private void addRightBtn(JSONObject rightItemObj, final IApiModule.IJSCallback callback, int drawableWidth) {
        RightBtnInfo info = new RightBtnInfo();
        String enableString = rightItemObj.optString("enabled");
        boolean hidden = rightItemObj.optBoolean("hidden");
        final int rightItemId = rightItemObj.optInt("id");
        String titleString = rightItemObj.optString("title");
        int rightBarItemImgStyle = rightItemObj.optInt("rightBarItemImgStyle", 0);
        String img = rightItemObj.optString("img");
        info.style = rightItemObj.optString("style");
        info.textColor = rightItemObj.optString("titleColor");
        if (rightItemObj.has("textSize")) {
            info.textSize = rightItemObj.optInt("textSize");
        }
        info.title = titleString;
        info.hidden = hidden;
        info.img = img;
        info.rightBarItemImgStyle = rightBarItemImgStyle;
        boolean bl = info.enable = enableString == null || !enableString.equals("false");
        if (drawableWidth > 0) {
            this.mTitleFragment.addNewRightBtn(info, new View.OnClickListener(){

                public void onClick(View view) {
                    if (callback != null) {
                        HashMap<String, Integer> map = new HashMap<String, Integer>();
                        map.put("id", rightItemId);
                        callback.invokeCallback("'" + JsonParser.toJson(map) + "'");
                    }
                }
            }, drawableWidth);
        } else {
            this.mTitleFragment.addNewRightBtn(info, new View.OnClickListener(){

                public void onClick(View view) {
                    if (callback != null) {
                        HashMap<String, Integer> map = new HashMap<String, Integer>();
                        map.put("id", rightItemId);
                        callback.invokeCallback("'" + JsonParser.toJson(map) + "'");
                    }
                }
            });
        }
    }

    public void setNavigationRightButton(String param, IApiModule.IJSCallback callback) {
        MLog.info((Object)TAG, (String)"#setNavigationRightButton param = %s", (Object[])new Object[]{param});
        if (this.mTitleFragment == null) {
            return;
        }
        this.mTitleFragment.clearTitle();
        try {
            JSONObject jsonObject = new JSONObject(param);
            if (jsonObject.get("rightItems") == null) {
                return;
            }
            if (jsonObject.get("rightItems") instanceof JSONArray) {
                JSONArray rightBtns = jsonObject.optJSONArray("rightItems");
                for (int i = 0; i < rightBtns.length(); ++i) {
                    this.addRightBtn(rightBtns.optJSONObject(i), callback, DensityUtil.dip2px((Context)this.getContext(), (float)22.0f));
                }
            } else if (jsonObject.get("rightItems") instanceof JSONObject) {
                JSONObject rightBtns = jsonObject.optJSONObject("rightItems");
                this.addRightBtn(rightBtns, callback, DensityUtil.dip2px((Context)this.getContext(), (float)22.0f));
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void showNobleRightButtonMore() {
    }

    public void hideNobleRightButtonMore() {
    }

    public void setNavigationBarTitle(String title) {
        if (this.mTitleFragment != null) {
            this.mTitleFragment.setTitleText(title);
        }
    }

    public void setTitleWithBackground(String param, IApiModule.IJSCallback callback) {
    }

    public void onShortCutPayDialog(String param, IApiModule.IJSCallback callback) {
    }

    public void setNavigationBarAppearance(String param, IApiModule.IJSCallback callback) {
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new JsSupporttedPopupComponent$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

