/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.onepiece.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.core.widget.NestedScrollView;

public class FixedMultiScrollView
extends NestedScrollView {
    private static final String TAG = "FixedMultiScrollView";
    private OnScrollViewTouchListener mOnScrollViewTouchListener;
    private boolean isIntercept;
    private float lastY;

    public FixedMultiScrollView(Context context) {
        super(context);
    }

    public FixedMultiScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setOnTouchlistener(OnScrollViewTouchListener onScrollViewTouchListener) {
        this.mOnScrollViewTouchListener = onScrollViewTouchListener;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        float y = ev.getY();
        switch (action) {
            case 0: {
                this.lastY = y;
                break;
            }
            case 2: {
                this.cacluteIsNeedIntercept(ev);
                this.lastY = y;
                break;
            }
            case 1: 
            case 3: {
                this.resetTouch();
                break;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public void cacluteIsNeedIntercept(MotionEvent ev) {
        boolean isHeadVisiable;
        int tabTopHeight = this.mOnScrollViewTouchListener.getTabStripTopHeight();
        boolean isScrollDown = ev.getY() >= this.lastY;
        boolean bl = isHeadVisiable = this.getScrollY() < tabTopHeight;
        if (!isScrollDown && this.getScrollY() == tabTopHeight && !this.isIntercept) {
            ev.setAction(0);
        }
        if (isScrollDown && this.getScrollY() == tabTopHeight && this.isSubScrollViewTop()) {
            this.isIntercept = false;
            this.requestDisallowInterceptTouchEvent(false);
        } else {
            this.isIntercept = !isHeadVisiable;
            this.requestDisallowInterceptTouchEvent(!isHeadVisiable);
        }
    }

    private void resetTouch() {
        this.isIntercept = false;
        this.lastY = 0.0f;
    }

    private boolean isSubScrollViewTop() {
        return this.mOnScrollViewTouchListener != null && this.mOnScrollViewTouchListener.isSlidingTop();
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return super.onStartNestedScroll(child, target, nestedScrollAxes);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int beforeScrollY = this.getScrollY();
        if (this.isHeadVisiable()) {
            this.scrollBy(0, dy);
            consumed[1] = this.getScrollY() - beforeScrollY;
        }
        super.onNestedPreScroll(target, dx, dy, consumed);
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        if (this.isHeadVisiable()) {
            this.fling((int)velocityY);
            return true;
        }
        return super.onNestedPreFling(target, velocityX, velocityY);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return super.onNestedFling(target, velocityX, velocityY, consumed);
    }

    private boolean isHeadVisiable() {
        int tabTopHeight = this.mOnScrollViewTouchListener.getTabStripTopHeight();
        return this.getScrollY() < tabTopHeight;
    }

    public static interface OnScrollViewTouchListener {
        public int getTabStripTopHeight();

        public boolean isSlidingTop();
    }
}

