/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.onepiece.web;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.onepiece.web.JsWebViewPopupComponent;
import com.yy.mobile.ui.sharpgirls.WebViewFragment;
import com.yy.mobile.ui.widget.RoundRectRelativeLayout;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import org.json.JSONObject;

public class OnePieceJsWebViewPopupComponent
extends JsWebViewPopupComponent {
    private static final String TAG = "OnePieceJsWebViewPopupComponent";
    public boolean mIsFirstResume = true;
    private RoundRectRelativeLayout webLayout;

    public static OnePieceJsWebViewPopupComponent newInstance(JSONObject json) {
        OnePieceJsWebViewPopupComponent fragment = new OnePieceJsWebViewPopupComponent();
        Bundle bundle = new Bundle();
        bundle.putString("PARAM_POP_WEBVIEW", json.toString());
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onResume() {
        super.onResume();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)"onResume:");
        }
        if (this.mIsFirstResume) {
            this.mIsFirstResume = false;
        } else if (this.mWVFragment != null) {
            this.mWVFragment.loadJavaScript("javascript:onepieceWebViewAppear()");
        }
    }

    @Override
    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View layout2 = inflater.inflate(R.layout.onepiece_dialog_webview, container);
        this.webLayout = (RoundRectRelativeLayout)layout2.findViewById(R.id.webview_fragment);
        this.updateWebLayoutSize();
        FragmentTransaction ft = this.getChildFragmentManager().beginTransaction();
        this.mWVFragment = WebViewFragment.newInstance(this.url, this.titleBar);
        if (!this.mWebViewPopupParam.isCanPullRefresh) {
            this.mWVFragment.setEnablePullRefresh(false);
        }
        if (this.mWVFragment.isDetached()) {
            ft.attach((Fragment)this.mWVFragment);
            ft.commitAllowingStateLoss();
        } else if (!this.mWVFragment.isAdded()) {
            ft.add(R.id.webview_fragment, (Fragment)this.mWVFragment);
            ft.commitAllowingStateLoss();
        }
        return layout2;
    }

    public void onPause() {
        super.onPause();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)"onPause:");
        }
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("onHiddenChanged:" + hidden));
        }
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)"onDismiss:");
        }
    }

    public void onStart() {
        super.onStart();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)"onStart:");
        }
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)"onCancel:");
        }
    }

    public void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        if (this.getDialog() != null) {
            this.setDialogPrepare(this.getDialog());
        }
        this.updateWebLayoutSize();
        if (this.mWVFragment != null) {
            this.mWVFragment.setUrl(this.mWVFragment.getCurrentUrl(), true);
        }
    }

    private void updateWebLayoutSize() {
        if (this.webLayout == null) {
            return;
        }
        if (this.isScreenOriatationPortrait(this.getContext())) {
            int width = (int)((double)ResolutionUtils.getScreenWidth((Context)this.getActivity()) * this.mWebViewPopupParam.portraitWidth);
            int height = (int)((double)ResolutionUtils.getScreenHeight((Context)this.getActivity()) * this.mWebViewPopupParam.portraitHeight);
            this.webLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(width, height));
            this.webLayout.setRadius(this.mWebViewPopupParam.cornerRadius > 0 ? (int)ResolutionUtils.convertDpToPixel((float)(this.mWebViewPopupParam.cornerRadius / 2), (Context)this.getContext()) : 0);
        } else {
            int width = (int)((double)ResolutionUtils.getScreenWidth((Context)this.getActivity()) * this.mWebViewPopupParam.landscapeWidth);
            int height = (int)((double)ResolutionUtils.getScreenHeight((Context)this.getActivity()) * this.mWebViewPopupParam.landscapeHeight);
            this.webLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(width, height));
        }
    }
}

