/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.onepiece.web;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IOrderClient_onJsWebViewPopupComponentDismiss_EventArgs;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.ui.onepiece.web.WebViewPopupParam;
import com.yy.mobile.ui.sharpgirls.WebViewFragment;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import org.json.JSONException;
import org.json.JSONObject;

public class JsWebViewPopupComponent
extends PopupComponent {
    public static final String TAG = "JsWebViewPopupComponent";
    public static final String PARAM_POP_WEBVIEW = "PARAM_POP_WEBVIEW";
    public WebViewFragment mWVFragment;
    protected boolean titleBar;
    protected String url;
    protected WebViewPopupParam mWebViewPopupParam = new WebViewPopupParam();
    private String mDismissNotifyTag;

    public static JsWebViewPopupComponent newInstance(JSONObject json) {
        JsWebViewPopupComponent fragment = new JsWebViewPopupComponent();
        Bundle bundle = new Bundle();
        bundle.putString(PARAM_POP_WEBVIEW, json.toString());
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            String jsonString = this.getArguments().getString(PARAM_POP_WEBVIEW);
            this.loadJson(new JSONObject(jsonString));
        }
        catch (Exception ex) {
            return;
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog.getWindow().setFlags(1024, 1024);
        dialog.getWindow().getDecorView().setPadding(0, 0, 0, 0);
        dialog.getWindow().addFlags(2);
        this.setDialogPrepare(dialog);
        return dialog;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        int width;
        View layout2 = inflater.inflate(R.layout.mn_dialog_webview, container);
        RelativeLayout webLayout = (RelativeLayout)layout2.findViewById(R.id.webview_fragment);
        if (this.isScreenOriatationPortrait((Context)this.getActivity())) {
            width = (int)((double)ResolutionUtils.getScreenWidth((Context)this.getActivity()) * this.mWebViewPopupParam.portraitWidth);
            int height = (int)((double)ResolutionUtils.getScreenHeight((Context)this.getActivity()) * this.mWebViewPopupParam.portraitHeight);
            webLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(width, height));
        } else {
            width = (int)((double)ResolutionUtils.getScreenWidth((Context)this.getActivity()) * this.mWebViewPopupParam.landscapeWidth);
            int height = (int)((double)ResolutionUtils.getScreenHeight((Context)this.getActivity()) * this.mWebViewPopupParam.landscapeHeight);
            webLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(width, height));
        }
        FragmentTransaction ft = this.getChildFragmentManager().beginTransaction();
        this.mWVFragment = this.getOrCreatWebViewFragment(this.url, this.titleBar);
        if (!this.mWebViewPopupParam.isCanPullRefresh) {
            this.mWVFragment.setEnablePullRefresh(false);
        }
        if (this.mWVFragment.isDetached()) {
            ft.attach((Fragment)this.mWVFragment);
            ft.commitAllowingStateLoss();
        } else if (!this.mWVFragment.isAdded()) {
            ft.add(R.id.webview_fragment, (Fragment)this.mWVFragment);
            ft.commitAllowingStateLoss();
        }
        return layout2;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mWVFragment != null) {
            this.mWVFragment.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void setVisibility(int visibility) {
        this.getView().setVisibility(visibility);
    }

    public ViewGroup.LayoutParams getLayoutParams() {
        return this.getView().getLayoutParams();
    }

    public void setLayoutParams(ViewGroup.LayoutParams params) {
        this.getView().setLayoutParams(params);
    }

    private WebViewFragment getOrCreatWebViewFragment(String url, boolean titleBar) {
        return WebViewFragment.newInstance(url, titleBar);
    }

    protected void setDialogPrepare(Dialog dialog) {
        Window win = dialog.getWindow();
        WindowManager.LayoutParams lp = win.getAttributes();
        lp.dimAmount = 0.55f;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        if (this.isScreenOriatationPortrait((Context)this.getActivity())) {
            width = (int)((double)ResolutionUtils.getScreenWidth((Context)this.getActivity()) * this.mWebViewPopupParam.portraitWidth);
            height = (int)((double)ResolutionUtils.getScreenHeight((Context)this.getActivity()) * this.mWebViewPopupParam.portraitHeight);
            x = (int)((double)ResolutionUtils.getScreenWidth((Context)this.getActivity()) * this.mWebViewPopupParam.portraitX);
            y = (int)((double)ResolutionUtils.getScreenHeight((Context)this.getActivity()) * this.mWebViewPopupParam.portraitY);
        } else {
            width = (int)((double)ResolutionUtils.getScreenWidth((Context)this.getActivity()) * this.mWebViewPopupParam.landscapeWidth);
            height = (int)((double)ResolutionUtils.getScreenHeight((Context)this.getActivity()) * this.mWebViewPopupParam.landscapeHeight);
            x = (int)((double)ResolutionUtils.getScreenWidth((Context)this.getActivity()) * this.mWebViewPopupParam.landscapeX);
            y = (int)((double)ResolutionUtils.getScreenHeight((Context)this.getActivity()) * this.mWebViewPopupParam.landscapeY);
        }
        lp.width = width;
        lp.height = height;
        lp.x = x - ResolutionUtils.getScreenWidth((Context)this.getActivity()) / 2 + lp.width / 2;
        lp.y = y - ResolutionUtils.getScreenHeight((Context)this.getActivity()) / 2 + lp.height / 2;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("JsWebViewPopupComponent portraitDistanceX:" + this.mWebViewPopupParam.portraitX + " portraitDistanceY:" + this.mWebViewPopupParam.portraitY + " portraitWidth:" + this.mWebViewPopupParam.portraitWidth + " portraitHeight:" + this.mWebViewPopupParam.portraitHeight));
        }
        MLog.info((String)TAG, (String)("JsWebViewPopupComponent ScreenWidth=" + ResolutionUtils.getScreenWidth((Context)this.getActivity()) + " ScreenHeight=:" + ResolutionUtils.getScreenHeight((Context)this.getActivity())));
        MLog.info((String)TAG, (String)("JsWebViewPopupComponent x=:" + lp.x + " y=:" + lp.y + " Width:" + lp.width + " Height:" + lp.height));
        win.setAttributes(lp);
    }

    public boolean isScreenOriatationPortrait(Context context) {
        return context.getResources().getConfiguration().orientation == 1;
    }

    public void loadJson(JSONObject json) {
        if (json != null) {
            try {
                JSONObject landscapeObject;
                JSONObject portraitObject;
                this.mWebViewPopupParam.actName = json.getString("actId");
                this.url = json.getString("actUrl");
                if (json.has("titleBar")) {
                    this.titleBar = json.getBoolean("titleBar");
                }
                if ((portraitObject = json.getJSONObject("portrait")) != null) {
                    this.mWebViewPopupParam.portraitX = portraitObject.getDouble("x");
                    this.mWebViewPopupParam.portraitY = portraitObject.getDouble("y");
                    this.mWebViewPopupParam.portraitWidth = portraitObject.getDouble("width");
                    this.mWebViewPopupParam.portraitHeight = portraitObject.getDouble("height");
                    this.mWebViewPopupParam.cornerRadius = portraitObject.optInt("cornerRadius", 0);
                }
                if ((landscapeObject = json.getJSONObject("landscape")) != null) {
                    this.mWebViewPopupParam.landscapeX = landscapeObject.getDouble("x");
                    this.mWebViewPopupParam.landscapeY = landscapeObject.getDouble("y");
                    this.mWebViewPopupParam.landscapeWidth = landscapeObject.getDouble("width");
                    this.mWebViewPopupParam.landscapeHeight = landscapeObject.getDouble("height");
                }
                this.mWebViewPopupParam.isCanPullRefresh = json.optBoolean("WEB_VIEW_PULL", true);
                this.mDismissNotifyTag = json.optString("DISMISS_NOTIFY_TAG", "");
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (!TextUtils.isEmpty((CharSequence)this.mDismissNotifyTag)) {
            RxBus.getDefault().post((Object)new IOrderClient_onJsWebViewPopupComponentDismiss_EventArgs(this.mDismissNotifyTag));
        }
    }
}

