/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.onepiece.activity;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IGalleryClient_onQueryPersonGalleryInfo_EventArgs;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.onepiece.activity.OnepieceUserInfoFragment$$EventBinder;
import com.yy.mobile.ui.onepiece.widget.FixedMultiScrollFrameLayout;
import com.yy.mobile.ui.onepiece.widget.FixedMultiScrollView;
import com.yy.mobile.ui.onepiece.widget.GetHeightInterface;
import com.yy.mobile.ui.profile.anchor.AnchorDocumentFragmentOld;
import com.yy.mobile.ui.profile.anchor.personalpage.GridViewAdapter;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.gallery.IGalleryCore;
import com.yymobile.core.gallery.module.PersonPagePhotoInfo;
import com.yymobile.core.mobilelive.ILivePluginCore;
import com.yymobile.core.subscribe.ISubscribeCore;
import java.util.Collection;

public class OnepieceUserInfoFragment
extends BaseLinkFragment
implements FixedMultiScrollView.OnScrollViewTouchListener,
GetHeightInterface {
    private static final String TAG = "OnepieceUserInfoFragmen";
    private long mUid;
    private SimpleTitleBar stickyTitleBar;
    private GridView grallery;
    private FixedMultiScrollFrameLayout flDocumentFragment;
    private FixedMultiScrollView userInfoScrollView;
    private TextView tvGalleryTitle;
    private LinearLayout scorllTopContent;
    private GridViewAdapter gralleryAdapter;
    private AnchorDocumentFragmentOld mAnchorDocumentFragment;
    private EventBinder mEventBinder;

    public static OnepieceUserInfoFragment newInstance(long uid) {
        OnepieceUserInfoFragment fragment = new OnepieceUserInfoFragment();
        Bundle bundle = new Bundle();
        bundle.putLong("uid", uid);
        if (bundle != null) {
            fragment.setArguments(bundle);
        }
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null && this.getArguments().getLong("uid", 0L) > 0L) {
            this.mUid = this.getArguments().getLong("uid");
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_op_personal_data, null, false);
        this.stickyTitleBar = (SimpleTitleBar)view.findViewById(R.id.sticky_title_bar);
        this.grallery = (GridView)view.findViewById(R.id.grallery);
        this.flDocumentFragment = (FixedMultiScrollFrameLayout)view.findViewById(R.id.fl_document_fragment);
        this.userInfoScrollView = (FixedMultiScrollView)view.findViewById(R.id.user_info_scroll_view);
        this.tvGalleryTitle = (TextView)view.findViewById(R.id.tv_gallery_title);
        this.scorllTopContent = (LinearLayout)view.findViewById(R.id.scorll_top_content);
        this.gralleryAdapter = new GridViewAdapter((Context)this.getActivity(), this.mUid);
        this.gralleryAdapter.setMaxColumnCount(5);
        this.grallery.setAdapter((ListAdapter)this.gralleryAdapter);
        this.stickyTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                OnepieceUserInfoFragment.this.getActivity().finish();
            }
        });
        this.stickyTitleBar.setTitlte("\u8d44\u6599");
        this.mAnchorDocumentFragment = AnchorDocumentFragmentOld.newInstance(this.mUid);
        this.flDocumentFragment.setGetHeightInterface(this);
        this.getChildFragmentManager().beginTransaction().replace(R.id.fl_document_fragment, (Fragment)this.mAnchorDocumentFragment).commitAllowingStateLoss();
        this.userInfoScrollView.setOnTouchlistener(this);
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.requestInfo();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (OnepieceUserInfoFragment.this.mAnchorDocumentFragment != null) {
                    OnepieceUserInfoFragment.this.mAnchorDocumentFragment.setUserVisibleHint(true);
                }
                if (ICoreManagerBase.getCore(ILivePluginCore.class) != null) {
                    ((ILivePluginCore)ICoreManagerBase.getCore(ILivePluginCore.class)).queryUserInfo(OnepieceUserInfoFragment.this.mUid);
                }
            }
        }, (long)1000L);
    }

    private void requestInfo() {
        if (this.mUid <= 0L) {
            return;
        }
        if (!this.isMyself()) {
            ((ISubscribeCore)ICoreManagerBase.getCore(ISubscribeCore.class)).querySubscribe(this.mUid);
        }
        ((IGalleryCore)ICoreManagerBase.getCore(IGalleryCore.class)).queryPersonGallery(this.mUid, "1", "5");
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    protected boolean isMyself() {
        return LoginUtil.isLogined() && LoginUtil.getUid() == this.mUid;
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onQueryPersonGalleryInfo(IGalleryClient_onQueryPersonGalleryInfo_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        PersonPagePhotoInfo personPagePhotoInfo = busEventArgs.getPersonPagePhotoInfo();
        long uid = busEventArgs.getUid();
        if (uid != this.mUid) {
            return;
        }
        try {
            if (result == 0) {
                if (this.gralleryAdapter != null && personPagePhotoInfo != null && FP.size((Collection)personPagePhotoInfo.getPhotos()) > 0) {
                    if (this.grallery != null) {
                        this.grallery.setVisibility(0);
                        this.tvGalleryTitle.setVisibility(0);
                    }
                    if (this.grallery != null) {
                        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.grallery.getLayoutParams();
                        layoutParams.height = this.gralleryAdapter.getOneLineGridViewHeight();
                        layoutParams.weight = this.gralleryAdapter.getOneLineGridViewWidth();
                        this.grallery.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    }
                    this.gralleryAdapter.setData(personPagePhotoInfo.getTotalNum(), this.isMyself(), personPagePhotoInfo.getPhotos());
                }
            } else if (result == -1 && this.grallery != null) {
                this.grallery.setVisibility(8);
                this.tvGalleryTitle.setVisibility(8);
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
    }

    @Override
    public int getTabStripTopHeight() {
        if (this.scorllTopContent != null) {
            return this.scorllTopContent.getMeasuredHeight();
        }
        return 0;
    }

    @Override
    public boolean isSlidingTop() {
        return this.mAnchorDocumentFragment.isSlidingTop();
    }

    public void showLoginDialog() {
        if (this.getActivity() != null && this.getActivity() instanceof BaseActivity) {
            ((BaseActivity)this.getActivity()).showLoginDialog();
        }
    }

    @Override
    public int getHeight() {
        return this.getView().getMeasuredHeight() - this.getResources().getDimensionPixelSize(R.dimen.navigation_bar_height);
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new OnepieceUserInfoFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

