/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive.clipimage;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.widget.ImageView;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.util.log.MLog;

public class ClipImageView
extends ImageView
implements ScaleGestureDetector.OnScaleGestureListener,
View.OnTouchListener {
    private static final String TAG = "ClipImageView";
    private final Paint mPaint;
    private final int mMaskColor;
    private int mAspectX;
    private int mAspectY;
    private String mTipText;
    private final int mClipPadding;
    private float mScaleMax = 4.0f;
    private float mScaleMin = 2.0f;
    private float mInitScale = 1.0f;
    private final float[] mMatrixValues = new float[9];
    private ScaleGestureDetector mScaleGestureDetector = null;
    private final Matrix mScaleMatrix = new Matrix();
    private GestureDetector mGestureDetector;
    private boolean isAutoScale;
    private float mLastX;
    private float mLastY;
    private boolean isCanDrag;
    private int lastPointerCount;
    private Rect mClipBorder = new Rect();
    private int mMaxOutputWidth = 0;
    private boolean mDrawCircleFlag;
    private float mRoundCorner;

    public ClipImageView(Context context) {
        this(context, null);
    }

    public ClipImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent e) {
                if (ClipImageView.this.isAutoScale) {
                    return true;
                }
                float x = e.getX();
                float y = e.getY();
                if (ClipImageView.this.getScale() < ClipImageView.this.mScaleMin) {
                    ClipImageView.this.postDelayed(new AutoScaleRunnable(ClipImageView.this.mScaleMin, x, y), 16L);
                } else {
                    ClipImageView.this.postDelayed(new AutoScaleRunnable(ClipImageView.this.mInitScale, x, y), 16L);
                }
                ClipImageView.this.isAutoScale = true;
                return true;
            }
        });
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
        this.setOnTouchListener(this);
        this.mPaint = new Paint(1);
        this.mPaint.setColor(-1);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ClipImageView);
        this.mAspectX = ta.getInteger(R.styleable.ClipImageView_civWidth, 1);
        this.mAspectY = ta.getInteger(R.styleable.ClipImageView_civHeight, 1);
        this.mClipPadding = ta.getDimensionPixelSize(R.styleable.ClipImageView_civClipPadding, 0);
        this.mTipText = ta.getString(R.styleable.ClipImageView_civTipText);
        this.mMaskColor = ta.getColor(R.styleable.ClipImageView_civMaskColor, -1308622848);
        this.mDrawCircleFlag = ta.getBoolean(R.styleable.ClipImageView_civClipCircle, false);
        this.mRoundCorner = ta.getDimension(R.styleable.ClipImageView_civClipRoundCorner, 0.0f);
        int textSize = ta.getDimensionPixelSize(R.styleable.ClipImageView_civTipTextSize, 24);
        this.mPaint.setTextSize((float)textSize);
        ta.recycle();
        this.mPaint.setDither(true);
    }

    public boolean onScale(ScaleGestureDetector detector) {
        float scale = this.getScale();
        float scaleFactor = detector.getScaleFactor();
        if (this.getDrawable() == null) {
            return true;
        }
        if (scale < this.mScaleMax && scaleFactor > 1.0f || scale > this.mInitScale && scaleFactor < 1.0f) {
            if (scaleFactor * scale < this.mInitScale) {
                scaleFactor = this.mInitScale / scale;
            }
            if (scaleFactor * scale > this.mScaleMax) {
                scaleFactor = this.mScaleMax / scale;
            }
            this.mScaleMatrix.postScale(scaleFactor, scaleFactor, detector.getFocusX(), detector.getFocusY());
            this.checkBorder();
            this.setImageMatrix(this.mScaleMatrix);
        }
        return true;
    }

    private RectF getMatrixRectF() {
        Matrix matrix = this.mScaleMatrix;
        RectF rect = new RectF();
        Drawable d2 = this.getDrawable();
        if (null != d2) {
            rect.set(0.0f, 0.0f, (float)d2.getIntrinsicWidth(), (float)d2.getIntrinsicHeight());
            matrix.mapRect(rect);
        }
        return rect;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.mGestureDetector.onTouchEvent(event)) {
            return true;
        }
        this.mScaleGestureDetector.onTouchEvent(event);
        float x = 0.0f;
        float y = 0.0f;
        int pointerCount = event.getPointerCount();
        for (int i = 0; i < pointerCount; ++i) {
            x += event.getX(i);
            y += event.getY(i);
        }
        x /= (float)pointerCount;
        y /= (float)pointerCount;
        if (pointerCount != this.lastPointerCount) {
            this.isCanDrag = false;
            this.mLastX = x;
            this.mLastY = y;
        }
        this.lastPointerCount = pointerCount;
        switch (event.getAction()) {
            case 2: {
                float dx = x - this.mLastX;
                float dy = y - this.mLastY;
                if (!this.isCanDrag) {
                    this.isCanDrag = this.isCanDrag(dx, dy);
                }
                if (this.isCanDrag && this.getDrawable() != null) {
                    RectF rectF = this.getMatrixRectF();
                    if (rectF.width() <= (float)this.mClipBorder.width()) {
                        dx = 0.0f;
                    }
                    if (rectF.height() <= (float)this.mClipBorder.height()) {
                        dy = 0.0f;
                    }
                    this.mScaleMatrix.postTranslate(dx, dy);
                    this.checkBorder();
                    this.setImageMatrix(this.mScaleMatrix);
                }
                this.mLastX = x;
                this.mLastY = y;
                break;
            }
            case 1: 
            case 3: {
                this.lastPointerCount = 0;
                break;
            }
        }
        return true;
    }

    public final float getScale() {
        this.mScaleMatrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[0];
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.updateBorder();
    }

    private void updateBorder() {
        int height;
        int width = this.getWidth();
        if (width > (height = this.getHeight())) {
            this.mClipBorder.top = this.mClipPadding;
            this.mClipBorder.bottom = height - this.mClipPadding;
            int borderWidth = this.mClipBorder.height() * this.mAspectX / this.mAspectY;
            if (this.mDrawCircleFlag) {
                int borderTempWidth = this.mClipBorder.height() * 1 / 1;
                this.mClipBorder.left = (width - borderTempWidth) / 2;
                this.mClipBorder.right = this.mClipBorder.left + borderTempWidth;
            } else {
                this.mClipBorder.left = (width - borderWidth) / 2;
                this.mClipBorder.right = this.mClipBorder.left + borderWidth;
            }
        } else {
            this.mClipBorder.left = this.mClipPadding;
            this.mClipBorder.right = width - this.mClipPadding;
            int borderHeight = this.mClipBorder.width() * this.mAspectY / this.mAspectX;
            if (this.mDrawCircleFlag) {
                int borderTempHeight = this.mClipBorder.width() * 1 / 1;
                this.mClipBorder.top = (height - borderTempHeight) / 2;
                this.mClipBorder.bottom = this.mClipBorder.top + borderTempHeight;
            } else {
                this.mClipBorder.top = (height - borderHeight) / 2;
                this.mClipBorder.bottom = this.mClipBorder.top + borderHeight;
            }
        }
    }

    public void setAspect(int aspectX, int aspectY) {
        this.mAspectX = aspectX;
        this.mAspectY = aspectY;
    }

    public void setTip(String tip) {
        this.mTipText = tip;
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        this.postResetImageMatrix();
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.postResetImageMatrix();
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.postResetImageMatrix();
    }

    private void postResetImageMatrix() {
        if (this.getWidth() != 0) {
            this.resetImageMatrix();
        } else {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ClipImageView.this.resetImageMatrix();
                }
            });
        }
    }

    public void resetImageMatrix() {
        Drawable d2 = this.getDrawable();
        if (d2 == null) {
            return;
        }
        int dWidth = d2.getIntrinsicWidth();
        int dHeight = d2.getIntrinsicHeight();
        int cWidth = this.mClipBorder.width();
        int cHeight = this.mClipBorder.height();
        int vWidth = this.getWidth();
        int vHeight = this.getHeight();
        float scale = dWidth * cHeight > cWidth * dHeight ? (float)cHeight / (float)dHeight : (float)cWidth / (float)dWidth;
        float dx = ((float)vWidth - (float)dWidth * scale) * 0.5f;
        float dy = ((float)vHeight - (float)dHeight * scale) * 0.5f;
        this.mScaleMatrix.setScale(scale, scale);
        this.mScaleMatrix.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        this.setImageMatrix(this.mScaleMatrix);
        this.mInitScale = scale;
        this.mScaleMin = this.mInitScale * 2.0f;
        this.mScaleMax = this.mInitScale * 4.0f;
    }

    public Bitmap clip() {
        Drawable drawable2 = this.getDrawable();
        Bitmap originalBitmap = ((BitmapDrawable)drawable2).getBitmap();
        float[] matrixValues = new float[9];
        this.mScaleMatrix.getValues(matrixValues);
        float scale = matrixValues[0] * (float)drawable2.getIntrinsicWidth() / (float)originalBitmap.getWidth();
        float transX = matrixValues[2];
        float transY = matrixValues[5];
        float cropX = (-transX + (float)this.mClipBorder.left) / scale;
        float cropY = (-transY + (float)this.mClipBorder.top) / scale;
        float cropWidth = (float)this.mClipBorder.width() / scale;
        float cropHeight = (float)this.mClipBorder.height() / scale;
        Matrix outputMatrix = null;
        if (this.mMaxOutputWidth > 0 && cropWidth > (float)this.mMaxOutputWidth) {
            float outputScale = (float)this.mMaxOutputWidth / cropWidth;
            outputMatrix = new Matrix();
            outputMatrix.setScale(outputScale, outputScale);
        }
        MLog.info((String)TAG, (String)(" cropX=" + cropX + "cropY=" + cropY + " cropWidth=" + cropWidth + " cropHeight=" + cropHeight + " scale=" + scale));
        if (cropX < 0.0f) {
            cropX = 0.0f;
        }
        if (cropY < 0.0f) {
            cropY = 0.0f;
        }
        return Bitmap.createBitmap((Bitmap)originalBitmap, (int)((int)cropX), (int)((int)cropY), (int)((int)cropWidth), (int)((int)cropHeight), (Matrix)outputMatrix, (boolean)false);
    }

    private void checkBorder() {
        RectF rect = this.getMatrixRectF();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        if (rect.width() >= (float)this.mClipBorder.width()) {
            if (rect.left > (float)this.mClipBorder.left) {
                deltaX = -rect.left + (float)this.mClipBorder.left;
            }
            if (rect.right < (float)this.mClipBorder.right) {
                deltaX = (float)this.mClipBorder.right - rect.right;
            }
        } else {
            deltaX = -rect.left + (float)this.mClipBorder.left;
        }
        if (rect.height() >= (float)this.mClipBorder.height()) {
            if (rect.top > (float)this.mClipBorder.top) {
                deltaY = -rect.top + (float)this.mClipBorder.top;
            }
            if (rect.bottom < (float)this.mClipBorder.bottom) {
                deltaY = (float)this.mClipBorder.bottom - rect.bottom;
            }
        } else {
            deltaY = -rect.top + (float)this.mClipBorder.top;
        }
        this.mScaleMatrix.postTranslate(deltaX, deltaY);
    }

    private boolean isCanDrag(float dx, float dy) {
        return Math.sqrt(dx * dx + dy * dy) >= 0.0;
    }

    public Rect getClipBorder() {
        return this.mClipBorder;
    }

    public void setMaxOutputWidth(int maxOutputWidth) {
        this.mMaxOutputWidth = maxOutputWidth - 2 * this.mClipPadding;
    }

    public float[] getClipMatrixValues() {
        float[] matrixValues = new float[9];
        this.mScaleMatrix.getValues(matrixValues);
        return matrixValues;
    }

    public void drawRectangleOrCircle(Canvas canvas) {
        MLog.debug((String)TAG, (String)"drawRectangleOrCircle start");
        if (this.mDrawCircleFlag) {
            this.drawCircleBorder(canvas);
        } else {
            this.drawRectBorder(canvas);
        }
    }

    private void drawRectBorder(Canvas canvas) {
        RectF rect = new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight());
        Paint paint = new Paint(1);
        int saveCount = canvas.saveLayer(rect, paint, 31);
        paint.setColor(this.mMaskColor);
        canvas.drawRect(rect, paint);
        PorterDuffXfermode porterDuffXfermode = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
        paint.setColor(0);
        paint.setXfermode((Xfermode)porterDuffXfermode);
        RectF rectF = new RectF((float)this.mClipBorder.left, (float)this.mClipBorder.top, (float)this.mClipBorder.right, (float)this.mClipBorder.bottom);
        canvas.drawRoundRect(rectF, this.mRoundCorner, this.mRoundCorner, paint);
        canvas.restoreToCount(saveCount);
        Paint rectPaint = new Paint(1);
        rectPaint.setColor(-1);
        rectPaint.setStyle(Paint.Style.STROKE);
        rectPaint.setStrokeWidth(10.0f);
        canvas.drawRect(rectF, rectPaint);
        Paint linePaint = new Paint(1);
        linePaint.setColor(-1);
        linePaint.setStyle(Paint.Style.STROKE);
        linePaint.setStrokeWidth(2.0f);
        DashPathEffect effects = new DashPathEffect(new float[]{5.0f, 5.0f, 5.0f, 5.0f}, 1.0f);
        linePaint.setPathEffect((PathEffect)effects);
        canvas.drawLine((float)this.mClipBorder.left + rectF.width() / 3.0f, (float)this.mClipBorder.top, (float)this.mClipBorder.left + rectF.width() / 3.0f, (float)this.mClipBorder.bottom, linePaint);
        canvas.drawLine((float)this.mClipBorder.left + rectF.width() * 2.0f / 3.0f, (float)this.mClipBorder.top, (float)this.mClipBorder.left + rectF.width() * 2.0f / 3.0f, (float)this.mClipBorder.bottom, linePaint);
        canvas.drawLine((float)this.mClipBorder.left, (float)this.mClipBorder.top + rectF.height() / 3.0f, (float)this.mClipBorder.right, (float)this.mClipBorder.top + rectF.height() / 3.0f, linePaint);
        canvas.drawLine((float)this.mClipBorder.left, (float)this.mClipBorder.top + rectF.height() * 2.0f / 3.0f, (float)this.mClipBorder.right, (float)this.mClipBorder.top + rectF.height() * 2.0f / 3.0f, linePaint);
    }

    private void drawCircleBorder(Canvas canvas) {
        RectF rect = new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight());
        Paint paint = new Paint(1);
        int saveCount = canvas.saveLayer(rect, paint, 31);
        paint.setColor(this.mMaskColor);
        canvas.drawRect(rect, paint);
        float cx = (float)this.mClipBorder.left + (float)this.mClipBorder.width() / 2.0f;
        float cy = (float)this.mClipBorder.top + (float)this.mClipBorder.height() / 2.0f;
        float radius = (float)this.mClipBorder.height() / 2.0f;
        PorterDuffXfermode porterDuffXfermode = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
        paint.setColor(0);
        paint.setXfermode((Xfermode)porterDuffXfermode);
        canvas.drawCircle(cx, cy, radius, paint);
        canvas.restoreToCount(saveCount);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        this.mPaint.setColor(this.mMaskColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(1.0f);
        this.drawRectangleOrCircle(canvas);
        if (this.mTipText != null) {
            float textWidth = this.mPaint.measureText(this.mTipText);
            float startX = ((float)width - textWidth) / 2.0f;
            Paint.FontMetrics fm = this.mPaint.getFontMetrics();
            float startY = (float)(this.mClipBorder.bottom + this.mClipBorder.top / 2) - (fm.descent - fm.ascent) / 2.0f;
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawText(this.mTipText, startX, startY, this.mPaint);
        }
    }

    private class AutoScaleRunnable
    implements Runnable {
        static final float BIGGER = 1.07f;
        static final float SMALLER = 0.93f;
        private float mTargetScale;
        private float tmpScale;
        private float x;
        private float y;

        AutoScaleRunnable(float targetScale, float x, float y) {
            this.mTargetScale = targetScale;
            this.x = x;
            this.y = y;
            this.tmpScale = ClipImageView.this.getScale() < this.mTargetScale ? 1.07f : 0.93f;
        }

        @Override
        public void run() {
            ClipImageView.this.mScaleMatrix.postScale(this.tmpScale, this.tmpScale, this.x, this.y);
            ClipImageView.this.checkBorder();
            ClipImageView.this.setImageMatrix(ClipImageView.this.mScaleMatrix);
            float currentScale = ClipImageView.this.getScale();
            if (this.tmpScale > 1.0f && currentScale < this.mTargetScale || this.tmpScale < 1.0f && this.mTargetScale < currentScale) {
                ClipImageView.this.postDelayed(this, 16L);
            } else {
                float deltaScale = this.mTargetScale / currentScale;
                ClipImageView.this.mScaleMatrix.postScale(deltaScale, deltaScale, this.x, this.y);
                ClipImageView.this.checkBorder();
                ClipImageView.this.setImageMatrix(ClipImageView.this.mScaleMatrix);
                ClipImageView.this.isAutoScale = false;
            }
        }
    }
}

