/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.view.View;
import android.widget.TextView;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.AndPermission;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.policy.dialog.IPerConstantKt;
import com.yy.mobile.policy.dialog.PermissionTips;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.mobilelive.ClipImagePresent;
import com.yy.mobile.ui.mobilelive.clipimage.ClipImageView;
import com.yy.mobile.ui.mobilelive.clipimage.ClipParaInfo;
import com.yy.mobile.ui.mobilelive.clipimage.IClipImagePresenter;
import com.yy.mobile.ui.widget.photopicker.PhotoPickActivity;
import com.yy.mobile.util.BuildCompat;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.TimeUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.YYImageUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.gallery.module.GalleryConst;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PhotoEditController
implements View.OnClickListener {
    private static final String TAG = "PhotoEditController";
    private static final String CLIP_NAME = "clip_";
    private static final String JPG_EXT = ".jpg";
    private static final String CAMERA_PREFIX = "pic_";
    public static final int IMAGE_CAPTURE_REPUEST_CODE = 0;
    private Activity mActivity;
    private View mRootView;
    private TextView mUploadPhoto;
    private TextView mRetakePhoto;
    private ClipImageView mClipImageView;
    private IClipImagePresenter mClipImagePresent;
    private boolean mPhotoFromCamera;
    private boolean mEditInit;
    private String mBmpPath;
    private CancelCallback cancelCallback;

    public PhotoEditController(Activity act, CancelCallback cancelCallback) {
        this.mActivity = act;
        this.cancelCallback = cancelCallback;
    }

    public void initPhotoEditContentView(View rootView, boolean isFromCamera) {
        this.mPhotoFromCamera = isFromCamera;
        this.mRootView = rootView;
        if (this.mRootView != null) {
            this.mClipImageView = (ClipImageView)this.mRootView.findViewById(R.id.clip_image_view);
            this.mClipImagePresent = new ClipImagePresent();
            this.mClipImagePresent.setClipImageView(this.mClipImageView);
            this.mUploadPhoto = (TextView)this.mRootView.findViewById(R.id.btn_use);
            this.mRetakePhoto = (TextView)this.mRootView.findViewById(R.id.btn_retake);
            if (!this.mPhotoFromCamera) {
                this.mRetakePhoto.setText((CharSequence)"\u53d6\u6d88");
            } else {
                this.mRetakePhoto.setText((CharSequence)"\u91cd\u62cd");
            }
            this.mUploadPhoto.setOnClickListener((View.OnClickListener)this);
            this.mRetakePhoto.setOnClickListener((View.OnClickListener)this);
            this.mRootView.setVisibility(8);
        }
    }

    public void onGetPhoto(String bmpPath, boolean photoFromCamera) {
        MLog.info((String)TAG, (String)("onGetPhoto bmpPath = " + bmpPath + " photoFromCamera=" + photoFromCamera + ",isQ:" + BuildCompat.isAtLeastQ()));
        if (BuildCompat.isAtLeastQ()) {
            if (FP.empty((CharSequence)bmpPath)) {
                return;
            }
        } else if (FP.empty((CharSequence)bmpPath) || bmpPath.lastIndexOf(".") == -1) {
            MLog.error((String)TAG, (String)"onGetPhoto bmtppath is NULL");
            return;
        }
        this.mBmpPath = bmpPath;
        try {
            ClipParaInfo info = new ClipParaInfo();
            info.aspectX = 3;
            info.aspectY = 2;
            info.maxWidth = 1;
            info.inputPath = bmpPath;
            if (this.mClipImagePresent != null) {
                this.mClipImagePresent.initClipParaInfo(info);
            }
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
        this.mPhotoFromCamera = photoFromCamera;
    }

    public void setEditViewVisible(boolean isVisible) {
        if (this.mRootView != null && this.mActivity != null) {
            try {
                if (isVisible) {
                    this.mRootView.setVisibility(0);
                } else {
                    this.mRootView.setVisibility(8);
                    if (this.cancelCallback != null) {
                        this.cancelCallback.onCancel(this.mRootView);
                    }
                }
            }
            catch (Throwable ex) {
                MLog.error((Object)TAG, (Throwable)ex);
            }
        }
    }

    public void onClick(View v) {
        if (v == this.mRetakePhoto) {
            if (this.mClipImagePresent != null) {
                this.mClipImagePresent.setClipImageViewBitmapPath(null);
            }
            if (this.mEditInit) {
                this.finishActivity();
                return;
            }
            if (this.mPhotoFromCamera) {
                this.deleteTempImage();
                this.takePhotoFromCamera();
                ((BaseActivity)this.mActivity).getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        PhotoEditController.this.onCancel();
                    }
                }, 1000L);
            } else {
                this.onCancel();
            }
        } else if (v == this.mUploadPhoto) {
            try {
                Bitmap bitmap = this.mClipImagePresent.getClipBitmap();
                if (bitmap != null) {
                    long uid = LoginUtil.getUid();
                    String path = CLIP_NAME + TimeUtils.curSec() + JPG_EXT;
                    if (!StringUtils.isEmpty((String)Long.toString(uid)).booleanValue()) {
                        path = Long.toString(uid) + "_" + TimeUtils.curSec() + JPG_EXT;
                    }
                    MLog.info((String)TAG, (String)("mOkClick uid=" + uid + " file path=" + path));
                    GalleryConst.PhotoQuality mQuality = GalleryConst.PhotoQuality.LIVE_COVER;
                    File clipTemp = YYFileUtils.getTempFile((Context)this.mActivity, (String)path);
                    YYFileUtils.saveBitmap((Bitmap)bitmap, (String)clipTemp.getPath(), (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG, (int)80);
                    if (bitmap.getWidth() * bitmap.getHeight() > mQuality.width * mQuality.height) {
                        YYImageUtils.resizeImage((String)clipTemp.getPath(), (String)clipTemp.getPath(), (int)mQuality.width, (int)mQuality.height, (Matrix)new Matrix(), (int)mQuality.quality);
                    }
                    if (this.mPhotoFromCamera) {
                        this.deleteTempImage();
                    }
                    MLog.info((String)TAG, (String)("mPhotoFromCamera =" + this.mPhotoFromCamera + " mPhotoFile=" + this.mBmpPath));
                    Intent data = new Intent();
                    data.putExtra("take_pic_local_path_key", clipTemp.getAbsolutePath());
                    this.mActivity.setResult(0, data);
                    this.mActivity.finish();
                } else {
                    MLog.error((String)TAG, (String)"mEditView.getCroppedImage() ==  null");
                    ((BaseActivity)this.mActivity).toast("\u7f16\u8f91\u7684\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91!");
                    this.onCancel();
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
                ((BaseActivity)this.mActivity).toast("\u7f16\u8f91\u7684\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91!");
                this.onCancel();
            }
        }
    }

    public void setEditPhotoFrom(boolean isFromCoverGallery) {
        this.mPhotoFromCamera = isFromCoverGallery;
        if (this.mRetakePhoto != null) {
            if (!this.mPhotoFromCamera) {
                this.mRetakePhoto.setText((CharSequence)"\u53d6\u6d88");
            } else {
                this.mRetakePhoto.setText((CharSequence)"\u91cd\u62cd");
            }
        }
    }

    public void onCancel() {
        if (this.mPhotoFromCamera) {
            this.deleteTempImage();
        }
        this.setEditViewVisible(false);
    }

    public boolean onBackPressed() {
        if (this.mEditInit) {
            this.finishActivity();
            return true;
        }
        if (this.mRootView != null && this.mRootView.isShown() && this.mActivity != null) {
            try {
                this.onCancel();
            }
            catch (Throwable ex) {
                MLog.error((Object)TAG, (Throwable)ex);
            }
            return true;
        }
        return false;
    }

    public void deleteTempImage() {
        if (this.mBmpPath != null) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((String)TAG, (String)("deleteTempImage path=" + this.mBmpPath));
            }
            YYFileUtils.removeFile((String)this.mBmpPath);
            this.mBmpPath = null;
        }
    }

    public void setEditInit(boolean mEditInit) {
        this.mEditInit = mEditInit;
    }

    public void takePhotoFromCamera() {
        ArrayList<String> permission = new ArrayList<String>();
        permission.add("android.permission.CAMERA");
        IPerConstantKt.showPermissionTips((Context)this.mActivity, (String)PermissionTips.INSTANCE.getCAMERA(), permission, (Action)new Action<List<String>>(){

            public void onAction(List<String> data) {
                PhotoEditController.this.realTakePhotoFromCamera();
            }
        }, (Action)new Action<List<String>>(){

            public void onAction(List<String> data) {
                MLog.info((String)PhotoEditController.TAG, (String)"takePhotoFromCamera deny permission");
            }
        }, (String)"");
    }

    private void realTakePhotoFromCamera() {
        long uid = LoginUtil.getUid();
        MLog.info((String)TAG, (String)("takePhotoFromCamera beign uid=" + uid));
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        String camCapturingName = StringUtils.isEmpty((String)Long.toString(uid)) == false ? uid + "_" + TimeUtils.curSec() + JPG_EXT : CAMERA_PREFIX + TimeUtils.curSec() + JPG_EXT;
        ((PhotoPickActivity)this.mActivity).saveCamCaptureName(camCapturingName);
        try {
            File out = YYFileUtils.getTempFile((Context)this.mActivity, (String)camCapturingName);
            out.delete();
            Uri uri = AndPermission.getFileUri((Activity)this.mActivity, (File)out);
            if (!Build.MANUFACTURER.equals("OPPO")) {
                intent.putExtra("android.intent.extras.CAMERA_FACING", 1);
            }
            intent.putExtra("output", (Parcelable)uri);
            this.mActivity.startActivityForResult(intent, 0);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"takePotoFromCamera fail, %s", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private void finishActivity() {
        if (this.mActivity != null) {
            this.mActivity.setResult(-1);
            this.mActivity.finish();
        }
    }

    public static interface CancelCallback {
        public void onCancel(View var1);
    }
}

