/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.messagenotifycenter.menu;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.scwang.smartrefresh.layout.util.DensityUtil;
import com.yy.mobile.memoryrecycle.views.YYLinearLayout;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import java.util.Map;

public class MenuPopupWindow
extends PopupWindow {
    private static final String TAG = "MenuPopupWindow";
    private Context mContext;
    private YYLinearLayout mContainer;
    private int mMenuItems = 0;
    private String mSelectText;
    private String mDefaultAllText;
    private OnMenuItemChanged mOnMenuItemSelectChanged;

    public void setOnMenuItemSelectChanged(OnMenuItemChanged changed) {
        this.mOnMenuItemSelectChanged = changed;
    }

    public MenuPopupWindow(Context context, String selectText) {
        super(context);
        this.mContext = context;
        this.mSelectText = selectText;
        this.init(this.mContext, -2, -2);
    }

    public MenuPopupWindow(Context context, String selectText, String defalutAllText) {
        super(context);
        this.mContext = context;
        this.mDefaultAllText = defalutAllText;
        this.mSelectText = selectText;
        if (TextUtils.equals((CharSequence)this.mSelectText, (CharSequence)this.mDefaultAllText)) {
            this.mSelectText = "\u5168\u90e8";
        }
        this.init(this.mContext, -2, -2);
    }

    private void init(Context context, int width, int height) {
        View rootView = LayoutInflater.from((Context)context).inflate(R.layout.message_center_popupwindow, null);
        this.mContainer = (YYLinearLayout)rootView.findViewById(R.id.message_center_container);
        this.setWidth(width);
        this.setHeight(height);
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.setBackgroundDrawable((Drawable)new ColorDrawable());
        this.setTouchable(true);
        this.setContentView(rootView);
    }

    private void createMenuItem(int item, String strText, int classifyId) {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(DensityUtil.dp2px((float)140.0f), DensityUtil.dp2px((float)45.0f));
        layoutParams.gravity = 17;
        TextView textView = new TextView(this.mContext);
        textView.setText((CharSequence)strText);
        textView.setTextSize(16.0f);
        textView.setGravity(17);
        if (!StringUtils.isEmptyString((String)this.mSelectText) && this.mSelectText.equals(strText)) {
            textView.setTextColor(this.mContext.getResources().getColor(R.color.bg_high_light));
        } else {
            textView.setTextColor(this.mContext.getResources().getColor(R.color.message_center_item_text_color));
        }
        int backgroundId = R.drawable.selector_tuanchuan_bg_zhong;
        if (item == 1) {
            backgroundId = R.drawable.selector_tuanchuan_bg_shang;
        } else if (item == this.mMenuItems) {
            backgroundId = R.drawable.selector_tuanchuan_bg_xia;
        }
        textView.setTag((Object)classifyId);
        textView.setBackgroundResource(backgroundId);
        textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mContainer.addView((View)textView);
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MenuPopupWindow.this.mOnMenuItemSelectChanged != null) {
                    TextView text = (TextView)v;
                    if (!TextUtils.equals((CharSequence)MenuPopupWindow.this.mSelectText, (CharSequence)text.getText().toString())) {
                        MenuPopupWindow.this.mOnMenuItemSelectChanged.onItemChanged(MenuPopupWindow.this.getShowString(text.getText().toString()), (Integer)text.getTag());
                    }
                }
                MenuPopupWindow.this.dismiss();
            }
        });
        if (item != this.mMenuItems) {
            this.createDividingLine();
        }
    }

    private String getShowString(String text) {
        if (!TextUtils.isEmpty((CharSequence)this.mDefaultAllText) && TextUtils.equals((CharSequence)"\u5168\u90e8", (CharSequence)text)) {
            return this.mDefaultAllText;
        }
        return text;
    }

    private void createDividingLine() {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, 1);
        View view = new View(this.mContext);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mContainer.addView(view);
    }

    public void updateMenu(Map<Integer, String> menuMap) {
        if (FP.empty(menuMap)) {
            MLog.error((String)TAG, (String)"updateMenu list is null");
            return;
        }
        this.mMenuItems = menuMap.size();
        int index = 0;
        for (Map.Entry<Integer, String> entry : menuMap.entrySet()) {
            if (TextUtils.isEmpty((CharSequence)entry.getValue())) continue;
            this.createMenuItem(++index, entry.getValue(), entry.getKey());
        }
    }

    public static interface OnMenuItemChanged {
        public void onItemChanged(String var1, int var2);
    }
}

