/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.messagenotifycenter;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.mobile.bizmodel.login.ILoginCore;
import com.yy.mobile.bizmodel.login.LoginStateType;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.messagenotifycenter.IMessageHistoryPresenter;
import com.yy.mobile.ui.messagenotifycenter.IMessageHistoryView;
import com.yy.mobile.ui.messagenotifycenter.MessageHistoryPresenter;
import com.yy.mobile.ui.messagenotifycenter.menu.MenuPopupWindow;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yymobile.core.CoreFactory;

public class SystemMessageActivity
extends BaseActivity
implements IMessageHistoryView {
    private static final String TAG = "SystemMessageActivity";
    private IMessageHistoryPresenter messageHistoryPresenter;
    private static final int MESSAGE_HISTORY_LOGIN_REQ = 12;
    private SimpleTitleBar mTitleBar;
    private TextView mCenterTitle;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_message_history);
        this.messageHistoryPresenter = new MessageHistoryPresenter(this);
        this.messageHistoryPresenter.onCreate(savedInstanceState, this.getIntent());
        this.initTitleBar();
        this.initListView();
    }

    private void initTitleBar() {
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.message_history_title_bar);
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                SystemMessageActivity.this.messageHistoryPresenter.onBackPress();
                SystemMessageActivity.this.finish();
            }
        });
        View rootCenterView = this.getLayoutInflater().inflate(R.layout.message_titlebar_center_view, null);
        this.mCenterTitle = (TextView)rootCenterView.findViewById(R.id.interactive_title_center_text);
        this.mCenterTitle.setText((CharSequence)this.getString(R.string.str_msg_system));
        this.mCenterTitle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SystemMessageActivity.this.showMessageMenu();
            }
        });
        this.mTitleBar.setCenterView(rootCenterView);
        View rootRightView = this.getLayoutInflater().inflate(R.layout.layout_simple_text_title_right, null);
        TextView clearNotify = (TextView)rootRightView.findViewById(R.id.simple_text_title_right);
        clearNotify.setText((CharSequence)this.getString(R.string.str_msg_clear));
        clearNotify.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
            }
        });
        this.mTitleBar.setRightView(rootRightView);
    }

    private void initListView() {
        PullToRefreshListView listView = (PullToRefreshListView)this.findViewById(R.id.lv_message_history);
        EndlessListScrollListener endlessListScrollListener = new EndlessListScrollListener((StatusLayout)this.findViewById(R.id.message_status_layout));
        this.messageHistoryPresenter.initListView(listView, endlessListScrollListener);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.messageHistoryPresenter.onSaveInstanceState(outState);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        this.messageHistoryPresenter.onBackPress();
        return super.onKeyDown(keyCode, event);
    }

    public void onResume() {
        super.onResume();
        this.checkAutoLoginState();
    }

    protected void onDestroy() {
        this.messageHistoryPresenter.dispose();
        super.onDestroy();
    }

    @Override
    public void showToast(int msgId) {
        if (!this.checkActivityValid()) {
            return;
        }
        Toast.makeText((Context)this.getContext(), (CharSequence)this.getString(msgId), (int)0).show();
    }

    @Override
    public void showClearNotifyDailog(OkCancelDialogListener dialogListener) {
        this.getDialogLinkManager().showDialog((IBaseDialog)new OkCancelDialog((CharSequence)this.getString(R.string.str_msg_clear_content), true, dialogListener));
    }

    @Override
    public void showNoDataView() {
        this.showNoData(R.drawable.no_message_bg, R.string.no_data_mesaage);
    }

    public View.OnClickListener getLoadListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                SystemMessageActivity.this.messageHistoryPresenter.reLoad();
            }
        };
    }

    public static void navigateFrom(Context context) {
        Intent intent = new Intent(context, SystemMessageActivity.class);
        intent.putExtra("title", "\u5168\u90e8\u7cfb\u7edf\u901a\u77e5");
        intent.putExtra("classifyId", -1);
        NavigationUtils.slideStartActivity(context, intent);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 12: {
                if (resultCode != -1 || !data.getExtras().getBoolean("LoginOnBack")) break;
                this.finish();
                break;
            }
        }
    }

    private void showMessageMenu() {
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.menu_down_btn_down);
        drawable2.setBounds(0, 0, drawable2.getMinimumWidth(), drawable2.getMinimumHeight());
        this.mCenterTitle.setCompoundDrawables(null, null, drawable2, null);
        int[] location = new int[2];
        this.mCenterTitle.getLocationOnScreen(location);
        MenuPopupWindow menuPopupWindow = new MenuPopupWindow((Context)this, this.mCenterTitle.getText().toString());
        menuPopupWindow.showAtLocation((View)this.mTitleBar, 49, 0, this.mCenterTitle.getHeight() + location[1]);
    }

    private void checkAutoLoginState() {
        if (!LoginUtil.isLogined()) {
            if (((ILoginCore)CoreFactory.getCore(ILoginCore.class)).isTryAutoLogin() && (LoginUtil.getLoginState() == LoginStateType.NotLogin || LoginUtil.getLoginState() == LoginStateType.Disconnect || LoginUtil.getLoginState() == LoginStateType.Failed)) {
                this.showLoginDialog();
            } else {
                this.showLoginDialog();
            }
        }
    }
}

