/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.messagenotifycenter;

import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.event.ui.IMessageNotifyControl;
import com.yy.mobile.plugin.main.events.INotifyClient_onNotify_EventArgs;
import com.yy.mobile.ui.messagecenter.MessageClassifyInfo;
import com.yy.mobile.ui.messagenotifycenter.HostMessageNotifyControl;
import com.yy.mobile.ui.messagenotifycenter.MessageNotifyManager$$EventBinder;
import com.yy.mobile.ui.notify.NotifyInfo;
import com.yy.mobile.util.log.MLog;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import java.util.List;
import java.util.concurrent.TimeUnit;

public enum MessageNotifyManager implements EventCompat
{
    INSTANCE;

    private static final String TAG = "MessageNotifyManager";
    private final IMessageNotifyControl mDefaultControl = new HostMessageNotifyControl();
    private EventBinder mEventBinder;

    public void init() {
        MLog.info((String)TAG, (String)"MessageNotifyManager init start");
        this.onEventBind();
    }

    public void unInit() {
        this.onEventUnBind();
    }

    @BusEvent
    public void onNotify(INotifyClient_onNotify_EventArgs busEventArgs) {
        NotifyInfo info = busEventArgs.getInfo();
        MLog.info((String)TAG, (String)("onNotify info: " + info));
        if (info.type == 1) {
            this.refresh();
        }
    }

    public IMessageNotifyControl getControl(int classifyId) {
        return this.mDefaultControl;
    }

    public void updateAllMessageReadStatus() {
        this.mDefaultControl.updateAllMessageReadStatus();
    }

    public void refresh() {
        this.mDefaultControl.refresh();
    }

    public void refreshHostNotify() {
        this.mDefaultControl.refresh();
    }

    public void loadData(Observer<List<MessageClassifyInfo>> observer) {
        this.mDefaultControl.loadData().subscribe(observer);
    }

    public void queryRedDot(@NonNull Observer<Integer> observer) {
        MLog.info((String)TAG, (String)("queryRedDot observer = " + observer));
        this.mDefaultControl.queryUnReadMsgNumber().debounce(1L, TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(observer);
    }

    public void onEventBind() {
        if (this.mEventBinder == null) {
            this.mEventBinder = new MessageNotifyManager$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

