/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.messagenotifycenter;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.event.ui.IMessageNotifyControl;
import com.yy.mobile.event.ui.OnNotifyMsgUpdate;
import com.yy.mobile.image.PauseOnScrollListener;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.messagecenter.IMessagePresenter;
import com.yy.mobile.ui.messagenotifycenter.IMessageHistoryPresenter;
import com.yy.mobile.ui.messagenotifycenter.IMessageHistoryView;
import com.yy.mobile.ui.messagenotifycenter.MessageNotifyManager;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.TimeUtils;
import com.yy.mobile.util.log.MLog;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MessageHistoryPresenter
implements IMessageHistoryPresenter {
    private static final String LOG_TAG = "MessageHistoryPresenter";
    private int mClassifyId = 0;
    private int mSelectBusinessType = -1;
    private int mLastStartIndex = 0;
    private IMessageHistoryView mView;
    private boolean mIsLastPage = false;
    public static int PAGE_SIZE = 30;
    private PullToRefreshListView mListView;
    private EndlessListScrollListener mEndlessListScrollListener;
    private IMessagePresenter mInternalPresenter;
    private String mTitle;
    private boolean showRightTitleBtn;
    private boolean mUpdateStatusWithBack;
    private List<Disposable> mDisposableList = new ArrayList<Disposable>();
    private Runnable fixCompleteRefreshMsg = new Runnable(){

        @Override
        public void run() {
            MessageHistoryPresenter.this.mListView.onRefreshComplete();
        }
    };
    private Runnable checkRequestTimeoutTask = new Runnable(){

        @Override
        public void run() {
            MessageHistoryPresenter.this.mView.hideStatus();
            MessageHistoryPresenter.this.mListView.onRefreshComplete();
            if (MessageHistoryPresenter.this.mInternalPresenter != null && MessageHistoryPresenter.this.mInternalPresenter.getAdapter() != null && MessageHistoryPresenter.this.mInternalPresenter.getAdapter().getCount() == 0) {
                MessageHistoryPresenter.this.mView.showReload();
            }
        }
    };

    public MessageHistoryPresenter(IMessageHistoryView view) {
        this.mView = view;
        this.registerRefreshFinishEvent();
    }

    @Override
    public void onCreate(Bundle savedInstanceState, Intent intent) {
        if (savedInstanceState != null) {
            this.init(savedInstanceState);
        }
        if (intent != null) {
            this.init(intent.getExtras());
        }
        MLog.info((String)LOG_TAG, (String)("onCreate mClassifyId = " + this.mClassifyId));
        IMessageNotifyControl control = MessageNotifyManager.INSTANCE.getControl(this.mClassifyId);
        if (control != null) {
            this.mInternalPresenter = control.getPresenter(this.mClassifyId);
            this.loadData(-1, 0);
        }
    }

    private void init(Bundle bundle) {
        if (bundle != null) {
            this.mTitle = bundle.getString("title");
            this.mClassifyId = bundle.getInt("classifyId", 0);
            this.showRightTitleBtn = bundle.getBoolean("canShorRightTitleBtn", false);
            this.mUpdateStatusWithBack = bundle.getBoolean("update_with_back", false);
        }
    }

    @Override
    public void dispose() {
        if (this.mView != null) {
            this.mView.getHandler().removeCallbacks(this.fixCompleteRefreshMsg);
            this.mView.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        }
        for (Disposable d2 : this.mDisposableList) {
            d2.dispose();
        }
        if (this.mInternalPresenter != null) {
            this.mInternalPresenter.onDestroy();
        }
    }

    @Override
    public String getTitle() {
        return this.mTitle;
    }

    @Override
    public boolean showRightTitlBtn() {
        return this.showRightTitleBtn;
    }

    @Override
    public void updateAllMsgReaded() {
        if (null != this.mInternalPresenter) {
            this.mInternalPresenter.updateAllBusinessMessageReaded(this.mSelectBusinessType);
        }
    }

    @Override
    public void initListView(PullToRefreshListView listView, EndlessListScrollListener endlessListScrollListener) {
        this.mListView = listView;
        this.mEndlessListScrollListener = endlessListScrollListener;
        this.mListView.setOnScrollListener((AbsListView.OnScrollListener)new PauseOnScrollListener(true, true));
        this.mListView.setOnRefreshListener((PullToRefreshBase.OnRefreshListener)new PullToRefreshBase.OnRefreshListener<ListView>(){
            Handler handler;
            {
                this.handler = MessageHistoryPresenter.this.mView.getHandler();
            }

            public void onRefresh(PullToRefreshBase<ListView> refreshView) {
                if (!MessageHistoryPresenter.this.mView.checkNetToast()) {
                    this.handler.removeCallbacks(MessageHistoryPresenter.this.fixCompleteRefreshMsg);
                    this.handler.postDelayed(MessageHistoryPresenter.this.fixCompleteRefreshMsg, 300L);
                    return;
                }
                if (LoginUtil.isLogined()) {
                    this.handler.removeCallbacks(MessageHistoryPresenter.this.checkRequestTimeoutTask);
                    this.handler.postDelayed(MessageHistoryPresenter.this.checkRequestTimeoutTask, TimeUtils.SECONDS.toMillis((long)10L));
                    if (MessageHistoryPresenter.this.mInternalPresenter != null) {
                        MessageHistoryPresenter.this.mInternalPresenter.refresh(LoginUtil.getUid());
                    }
                } else {
                    MessageHistoryPresenter.this.mView.showToast(R.string.str_not_login_yet);
                }
            }
        });
        this.mEndlessListScrollListener.setListener(new EndlessListScrollListener.EndlessListener(){

            public void onLoadData() {
                if (MessageHistoryPresenter.this.mInternalPresenter != null && MessageHistoryPresenter.this.mInternalPresenter.getAdapter() == null) {
                    MessageHistoryPresenter.this.loadData(MessageHistoryPresenter.this.mSelectBusinessType, 0);
                } else if (MessageHistoryPresenter.this.mInternalPresenter != null) {
                    MessageHistoryPresenter.this.loadData(MessageHistoryPresenter.this.mSelectBusinessType, MessageHistoryPresenter.this.mLastStartIndex);
                }
            }

            public boolean shouldLoadData() {
                if (MessageHistoryPresenter.this.mIsLastPage) {
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            MessageHistoryPresenter.this.mEndlessListScrollListener.onLoadComplete();
                        }
                    }, 500L);
                    return false;
                }
                return true;
            }
        });
        this.mListView.setOnScrollListener((AbsListView.OnScrollListener)this.mEndlessListScrollListener);
        if (this.mInternalPresenter != null) {
            MLog.info((String)LOG_TAG, (String)("getAdapter mAdapter = " + this.mInternalPresenter.getAdapter()));
            this.mListView.setAdapter((ListAdapter)this.mInternalPresenter.getAdapter());
        }
        this.mView.showLoading();
        this.mView.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        this.mView.getHandler().postDelayed(this.checkRequestTimeoutTask, TimeUtils.SECONDS.toMillis((long)10L));
    }

    @Override
    public void onBackPress() {
        if (this.mInternalPresenter != null && this.mUpdateStatusWithBack) {
            this.mInternalPresenter.updateAllClassifyMessageReaded(this.mClassifyId);
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        outState.putString("title", this.mTitle);
        outState.putInt("classifyId", this.mClassifyId);
    }

    @Override
    public void handleRestart() {
        if (this.mInternalPresenter != null && this.mInternalPresenter.getAdapter() != null) {
            this.mInternalPresenter.getAdapter().notifyDataSetChanged();
        }
    }

    private void registerRefreshFinishEvent() {
        MLog.info((String)LOG_TAG, (String)"registerRefreshFinishEvent");
        Disposable disposable2 = RxBus.getDefault().register(OnNotifyMsgUpdate.class).subscribe((Consumer)new Consumer<OnNotifyMsgUpdate>(){

            public void accept(@NonNull OnNotifyMsgUpdate onNotifyMsgUpdate) throws Exception {
                if (onNotifyMsgUpdate.getError() == null) {
                    // empty if block
                }
            }
        }, RxUtils.errorConsumer((String)LOG_TAG));
        this.mDisposableList.add(disposable2);
    }

    private void loadData(int businessType, int startIndex) {
        MLog.info((String)LOG_TAG, (String)("loadData mInternalPresenter=" + this.mInternalPresenter));
        if (this.mInternalPresenter == null) {
            return;
        }
        this.mLastStartIndex = startIndex;
        this.mSelectBusinessType = businessType;
        this.mInternalPresenter.loadData(businessType, startIndex).subscribe(new Observer(){

            public void onSubscribe(Disposable d2) {
                MLog.info((String)MessageHistoryPresenter.LOG_TAG, (String)"loadData onSubscribe");
            }

            public void onNext(Object o) {
                MLog.info((String)MessageHistoryPresenter.LOG_TAG, (String)("loadData onNext " + o));
                if (o instanceof List) {
                    MessageHistoryPresenter.this.onRefreshFinish((List)o, null);
                } else if (o instanceof Integer) {
                    MessageHistoryPresenter.this.mLastStartIndex = MessageHistoryPresenter.this.mLastStartIndex + (Integer)o;
                }
            }

            public void onError(Throwable e) {
                MLog.info((String)MessageHistoryPresenter.LOG_TAG, (String)("loadData onError " + e));
                MessageHistoryPresenter.this.onRefreshFinish(null, e.getMessage());
            }

            public void onComplete() {
                MLog.info((String)MessageHistoryPresenter.LOG_TAG, (String)"loadData onComplete");
            }
        });
    }

    private void onRefreshFinish(List<Object> messagesList, String errorMsg) {
        MLog.info((Object)LOG_TAG, (String)"onRefreshFinish message.size=%d, error=%s", (Object[])new Object[]{FP.size(messagesList), errorMsg});
        this.mView.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        this.mView.hideStatus();
        if (this.mEndlessListScrollListener != null) {
            this.mEndlessListScrollListener.onLoadComplete();
        }
        if (errorMsg != null) {
            MLog.info((String)LOG_TAG, (String)("[MessageCenter].[Error] error=" + errorMsg));
        } else if (messagesList != null) {
            this.mIsLastPage = messagesList.size() < PAGE_SIZE;
            MLog.info((String)LOG_TAG, (String)("mListView=" + this.mListView));
            if (this.mListView != null) {
                this.mListView.onRefreshComplete();
                if (messagesList.isEmpty()) {
                    this.mView.showNoDataView();
                }
            }
        } else {
            this.mIsLastPage = true;
            if (this.mListView != null) {
                this.mListView.onRefreshComplete();
            }
            MLog.info((String)LOG_TAG, (String)"[MessageCenter]  null!");
        }
    }

    @Override
    public void reLoad() {
        this.mView.showLoading();
        this.loadData(-1, 0);
        this.mView.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        this.mView.getHandler().postDelayed(this.checkRequestTimeoutTask, TimeUtils.SECONDS.toMillis((long)10L));
    }

    @Override
    public void reLoad(int businessType) {
        this.mView.showLoading();
        this.loadData(businessType, 0);
        this.mView.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        this.mView.getHandler().postDelayed(this.checkRequestTimeoutTask, TimeUtils.SECONDS.toMillis((long)10L));
    }

    @Override
    public Map<Integer, String> getMsgTypes() {
        return null != this.mInternalPresenter ? this.mInternalPresenter.getBusinessMsgTypes() : null;
    }
}

