/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.messagenotifycenter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.Spannable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.bumptech.glide.Glide;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.richtext.RichTextManager;
import com.yy.mobile.ui.messagenotifycenter.MessageBaseAdapter;
import com.yy.mobile.ui.messagenotifycenter.statistic.SysStatistic;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.TimeUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.BaseActivityApi;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.messagenotifycenter.IMessageNotifyCenterCore;
import com.yymobile.core.messagenotifycenter.templetmessage.BaseTemplateMessage;
import com.yymobile.core.messagenotifycenter.templetmessage.TemplateMessage;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MessageHistoryAdapter
extends MessageBaseAdapter {
    public static final String SYSTEM_MSG = "0";
    public static final String INTERACT_MSG = "1";
    private static final String LOG_TAG = "MessageHistoryAdapter";
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();
    private List<RichTextManager.Feature> features = new ArrayList<RichTextManager.Feature>(){
        {
            this.add(RichTextManager.Feature.EMOTICON);
        }
    };
    private List<BaseTemplateMessage> mData = new ArrayList<BaseTemplateMessage>();

    public List<BaseTemplateMessage> getData() {
        return this.mData;
    }

    public void setData(List<BaseTemplateMessage> data) {
        this.mData = data;
    }

    public int getCount() {
        return this.mData == null ? 0 : this.mData.size();
    }

    public BaseTemplateMessage getItem(int position) {
        return this.mData.get(position);
    }

    public int getViewTypeCount() {
        return 200;
    }

    public int getItemViewType(int position) {
        return this.mData.get((int)position).templateId;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        BaseTemplateMessage messageInfo = this.mData.get(position);
        if (convertView == null) {
            convertView = this.setBaseTempletMessage(messageInfo, 2, parent.getContext());
        } else {
            this.setBaseTemplateMessageData((MessageViewHolder)convertView.getTag(), messageInfo, 2, parent.getContext());
        }
        MLog.info((String)LOG_TAG, (String)("getView messageReportId = " + messageInfo.messageReportId));
        SysStatistic.INSTANCE.sysNotifyShow(messageInfo.messageId, messageInfo.messageReportId);
        return convertView;
    }

    @Override
    public void deleteOneData(TemplateMessage templateMessage) {
        if (this.mData != null && this.mData.contains(templateMessage)) {
            this.mData.remove(templateMessage);
            this.notifyDataSetChanged();
        }
    }

    @SuppressLint(value={"InflateParams"})
    public View setBaseTempletMessage(BaseTemplateMessage messageInfo, int showType, Context context) {
        View convertView;
        MLog.info((String)LOG_TAG, (String)("setBaseTempletMessage messageInfo = " + messageInfo));
        MessageViewHolder msgViewHolder = new MessageViewHolder();
        switch (messageInfo.templateId) {
            case 1: 
            case 10: {
                convertView = LayoutInflater.from((Context)context).inflate(R.layout.item_msg_center_content1, null);
                break;
            }
            case 2: {
                convertView = LayoutInflater.from((Context)context).inflate(R.layout.item_msg_center_content2, null);
                msgViewHolder.msgSubContent = (TextView)convertView.findViewById(R.id.msg_content_subtitle);
                break;
            }
            case 3: 
            case 5: {
                convertView = INTERACT_MSG.equals(messageInfo.msgClassify) ? LayoutInflater.from((Context)context).inflate(R.layout.item_msg_center_content_interact, null) : LayoutInflater.from((Context)context).inflate(R.layout.item_msg_center_content3, null);
                msgViewHolder.imgViews.add((ImageView)convertView.findViewById(R.id.msg_content_img));
                msgViewHolder.msgSubContent = (TextView)convertView.findViewById(R.id.msg_content_subtitle);
                break;
            }
            case 4: {
                convertView = LayoutInflater.from((Context)context).inflate(R.layout.item_msg_center_content4, null);
                msgViewHolder.imgViews.add((ImageView)convertView.findViewById(R.id.msg_content_img));
                break;
            }
            case 6: {
                convertView = LayoutInflater.from((Context)context).inflate(R.layout.item_msg_center_content6, null);
                msgViewHolder.imgViews.add((ImageView)convertView.findViewById(R.id.msg_imgs_0));
                msgViewHolder.imgViews.add((ImageView)convertView.findViewById(R.id.msg_imgs_1));
                break;
            }
            case 7: {
                convertView = LayoutInflater.from((Context)context).inflate(R.layout.item_msg_center_content7, null);
                msgViewHolder.imgViews.add((ImageView)convertView.findViewById(R.id.msg_imgs_0));
                msgViewHolder.imgViews.add((ImageView)convertView.findViewById(R.id.msg_imgs_1));
                msgViewHolder.imgViews.add((ImageView)convertView.findViewById(R.id.msg_imgs_2));
                break;
            }
            case 8: {
                convertView = LayoutInflater.from((Context)context).inflate(R.layout.item_msg_center_content8, null);
                msgViewHolder.imgViews.add((ImageView)convertView.findViewById(R.id.msg_imgs_0));
                msgViewHolder.imgViews.add((ImageView)convertView.findViewById(R.id.msg_imgs_1));
                msgViewHolder.imgViews.add((ImageView)convertView.findViewById(R.id.msg_imgs_2));
                break;
            }
            case 9: {
                convertView = LayoutInflater.from((Context)context).inflate(R.layout.item_msg_center_content9, null);
                msgViewHolder.imgViews.add((ImageView)convertView.findViewById(R.id.msg_imgs_0));
                msgViewHolder.imgViews.add((ImageView)convertView.findViewById(R.id.msg_imgs_1));
                msgViewHolder.imgViews.add((ImageView)convertView.findViewById(R.id.msg_imgs_2));
                msgViewHolder.imgViews.add((ImageView)convertView.findViewById(R.id.msg_imgs_3));
                break;
            }
            case 12: {
                convertView = LayoutInflater.from((Context)context).inflate(R.layout.item_msg_center_content_interact1, null);
                msgViewHolder.imgViews.add((ImageView)convertView.findViewById(R.id.msg_content_img));
                break;
            }
            default: {
                convertView = LayoutInflater.from((Context)context).inflate(R.layout.item_msg_center_content1, null);
            }
        }
        msgViewHolder.contentView = convertView;
        msgViewHolder.msgHeadIcon = (ImageView)convertView.findViewById(R.id.msg_head_icon);
        msgViewHolder.msgRedDotIcon = (ImageView)convertView.findViewById(R.id.msg_redhot_icon);
        msgViewHolder.msgTitle = (TextView)convertView.findViewById(R.id.msg_content_title);
        msgViewHolder.msgPublicTime = (TextView)convertView.findViewById(R.id.msg_content_time);
        msgViewHolder.msgContent = (TextView)convertView.findViewById(R.id.msg_content_text);
        msgViewHolder.msgDynamicContent = (TextView)convertView.findViewById(R.id.msg_content_dynamic);
        msgViewHolder.vDynamicContent = convertView.findViewById(R.id.v_content_dynamic);
        msgViewHolder.msgContain1 = convertView.findViewById(R.id.rl_bg_msg_item);
        convertView.setTag((Object)msgViewHolder);
        this.setBaseTemplateMessageData(msgViewHolder, messageInfo, showType, context);
        return convertView;
    }

    public void setBaseTemplateMessageData(MessageViewHolder holder, final BaseTemplateMessage messageInfo, int showType, final Context context) {
        Spannable text;
        String filterText;
        if (messageInfo == null) {
            return;
        }
        holder.setMessageStautus(messageInfo.msgClassify, messageInfo.messageStatus == 1);
        if (messageInfo.isMerge == 1) {
            holder.msgTitle.setText((CharSequence)messageInfo.title);
        } else {
            holder.msgTitle.setText((CharSequence)messageInfo.messageTitle);
        }
        if (!TextUtils.isEmpty((CharSequence)messageInfo.messageContent)) {
            filterText = messageInfo.messageContent.replace("&#x0A;", "\n");
            text = RichTextManager.getInstance().getSpannableString(context, (CharSequence)filterText, this.features);
            holder.msgContent.setText((CharSequence)text);
        }
        holder.msgPublicTime.setText((CharSequence)TimeUtils.getFormatTimeString((long)messageInfo.messageTime, (String)"year/mon/day hour:min"));
        holder.msgContain1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MessageHistoryAdapter.this.mTimeSlotTool.isProcessing()) {
                    return;
                }
                if (!LoginUtil.isLogined()) {
                    ((BaseActivityApi)CoreApiManager.getInstance().getApi(BaseActivityApi.class)).showLoginDialog((Activity)context);
                    return;
                }
                ((IMessageNotifyCenterCore)CoreFactory.getCore(IMessageNotifyCenterCore.class)).updateMessageNotifyCenterStatusByMessageID(messageInfo.messageId);
                messageInfo.messageStatus = 1;
                Bundle bundle = new Bundle();
                bundle.putString("content", messageInfo.messageContent);
                if (!FP.empty((CharSequence)messageInfo.messageContent)) {
                    bundle.putString("messageDetailAction", messageInfo.messageDetailAction);
                }
                bundle.putInt("messageTemplateId", messageInfo.templateId);
                MessageHistoryAdapter.this.sendHidoClickEvent(messageInfo);
                if (!FP.empty((CharSequence)messageInfo.messageAction)) {
                    MLog.info((String)MessageHistoryAdapter.LOG_TAG, (String)("[MessageCenter] messageAction.[uri] = " + messageInfo.messageAction));
                    if (messageInfo.classifyId == 6L) {
                        bundle.putInt("extra_key_play_from", 15);
                    }
                    ARouter.getInstance().build(Uri.parse((String)messageInfo.messageAction)).with(bundle).navigation(context);
                } else {
                    ARouter.getInstance().build(Uri.parse((String)"yymobile://MessageCenter/MessageDetailPage")).with(bundle).navigation(context);
                    MLog.info((String)MessageHistoryAdapter.LOG_TAG, (String)"[MessageCenter].[default uri]");
                }
            }
        });
        if (TextUtils.isEmpty((CharSequence)messageInfo.iconAction)) {
            holder.msgHeadIcon.setOnClickListener(null);
        } else {
            holder.msgHeadIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (MessageHistoryAdapter.this.mTimeSlotTool.isProcessing()) {
                        return;
                    }
                    MLog.info((String)MessageHistoryAdapter.LOG_TAG, (String)("[MessageCenter] iconAction.[uri] = " + messageInfo.iconAction));
                    ARouter.getInstance().build(Uri.parse((String)messageInfo.iconAction)).navigation((Context)((Activity)context));
                }
            });
        }
        if (TextUtils.isEmpty((CharSequence)messageInfo.iconUrl) && TextUtils.isEmpty((CharSequence)messageInfo.iconUid)) {
            holder.msgHeadIcon.setImageResource(R.drawable.message_item_default_icon);
            holder.msgHeadIcon.setTag((Object)0L);
        } else if (!TextUtils.isEmpty((CharSequence)messageInfo.iconUrl)) {
            holder.msgHeadIcon.setImageResource(R.drawable.default_portrait);
            Glide.with((Context)context).load((Object)messageInfo.iconUrl).into(holder.msgHeadIcon);
            holder.msgHeadIcon.setTag((Object)0L);
        } else if (!TextUtils.isEmpty((CharSequence)messageInfo.iconUid)) {
            long uid = StringUtils.safeParseLong((String)messageInfo.iconUid);
            holder.msgHeadIcon.setTag((Object)uid);
            this.addToHeadIconMap(uid, holder.msgHeadIcon);
            if (uid != 0L) {
                CoreManager.getUserCore().requestDetailUserInfo(uid, false);
            }
        }
        switch (messageInfo.templateId) {
            case 1: {
                this.setContentLines(holder, messageInfo);
                break;
            }
            case 2: {
                holder.msgSubContent.setText((CharSequence)messageInfo.messageSubContent);
                this.setContentLines(holder, messageInfo);
                break;
            }
            case 3: {
                this.loadImageSet(holder.imgViews, messageInfo.messageSubContentImage);
                if (messageInfo.classifyId == 6L && null != messageInfo.messageSubContent && messageInfo.messageSubContent.length() > 0) {
                    holder.msgSubContent.setText((CharSequence)RichTextManager.getInstance().getSpannableString(context, (CharSequence)messageInfo.messageSubContent, this.features));
                    break;
                }
                holder.msgSubContent.setText((CharSequence)messageInfo.messageSubContent);
                break;
            }
            case 4: {
                this.loadImageSet(holder.imgViews, messageInfo.messageImage);
                break;
            }
            case 5: {
                this.loadImageSet(holder.imgViews, messageInfo.messageImage);
                break;
            }
            case 6: {
                this.loadImageSet(holder.imgViews, messageInfo.messageImage);
                break;
            }
            case 7: {
                this.loadImageSet(holder.imgViews, messageInfo.messageImage);
                break;
            }
            case 8: {
                this.loadImageSet(holder.imgViews, messageInfo.messageImage);
                break;
            }
            case 9: {
                this.loadImageSet(holder.imgViews, messageInfo.messageImage);
                break;
            }
            case 11: {
                holder.msgContain1.setVisibility(8);
                break;
            }
            case 12: {
                if (messageInfo.messageImage.size() > 0) {
                    holder.vDynamicContent.setVisibility(8);
                    holder.msgDynamicContent.setVisibility(8);
                    this.loadImageSet(holder.imgViews, messageInfo.messageImage);
                    break;
                }
                if (TextUtils.isEmpty((CharSequence)messageInfo.messageSrcContent)) break;
                holder.vDynamicContent.setVisibility(0);
                holder.msgDynamicContent.setVisibility(0);
                filterText = messageInfo.messageSrcContent.replace("&#x0A;", "\n");
                text = RichTextManager.getInstance().getSpannableString(context, (CharSequence)filterText, this.features, (int)TypedValue.applyDimension((int)1, (float)11.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()));
                holder.msgDynamicContent.setEllipsize(TextUtils.TruncateAt.END);
                CharSequence ellipsizeStr = TextUtils.ellipsize((CharSequence)text, (TextPaint)holder.msgDynamicContent.getPaint(), (float)TypedValue.applyDimension((int)1, (float)180.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
                holder.msgDynamicContent.setText((CharSequence)text);
                break;
            }
        }
    }

    private void setContentLines(MessageViewHolder holder, BaseTemplateMessage messageInfo) {
        if (messageInfo.classifyId == 12L) {
            holder.msgContent.setMaxLines(Integer.MAX_VALUE);
        } else {
            holder.msgContent.setMaxLines(2);
        }
    }

    private void sendHidoClickEvent(BaseTemplateMessage messageInfo) {
        if (null == messageInfo) {
            return;
        }
        if (SYSTEM_MSG.equals(messageInfo.msgClassify)) {
            Property property = new Property();
            property.putString(String.valueOf(messageInfo.classifyId), INTERACT_MSG);
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1803", "0007", (Serializable)property);
            SysStatistic.INSTANCE.clickSysNotify(messageInfo.messageId, messageInfo.messageReportId);
        } else if (messageInfo.messageType != null) {
            switch (messageInfo.messageType) {
                case "1": {
                    Property property1 = new Property();
                    property1.putString("key1", INTERACT_MSG);
                    property1.putString("key2", messageInfo.messageSrcId);
                    property1.putString("key3", String.valueOf(LoginUtil.getUid()));
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "52404", "0002", (Serializable)property1);
                    break;
                }
                case "2": {
                    Property property2 = new Property();
                    property2.putString("key1", "2");
                    property2.putString("key2", messageInfo.messageSrcId);
                    property2.putString("key3", String.valueOf(LoginUtil.getUid()));
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "52404", "0002", (Serializable)property2);
                    break;
                }
                case "3": {
                    Property property3 = new Property();
                    property3.putString("key1", "3");
                    property3.putString("key2", messageInfo.messageSrcId);
                    property3.putString("key3", String.valueOf(LoginUtil.getUid()));
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "52404", "0002", (Serializable)property3);
                    break;
                }
                case "4": {
                    Property property4 = new Property();
                    property4.putString("key1", "4");
                    property4.putString("key2", messageInfo.messageSrcId);
                    property4.putString("key3", String.valueOf(LoginUtil.getUid()));
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "52404", "0002", (Serializable)property4);
                    break;
                }
                case "5": {
                    Property property5 = new Property();
                    property5.putString("key1", "5");
                    property5.putString("key2", messageInfo.messageSrcId);
                    property5.putString("key3", String.valueOf(LoginUtil.getUid()));
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "52404", "0002", (Serializable)property5);
                    break;
                }
                case "6": {
                    Property property6 = new Property();
                    property6.putString("key1", "6");
                    property6.putString("key2", messageInfo.messageSrcId);
                    property6.putString("key3", String.valueOf(LoginUtil.getUid()));
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "52404", "0002", (Serializable)property6);
                    break;
                }
            }
        }
    }

    private void addToHeadIconMap(long uid, ImageView imgView) {
        ArrayList<ImageView> mList = (ArrayList<ImageView>)this.headIconMap.get(uid);
        if (mList == null) {
            mList = new ArrayList<ImageView>();
            this.headIconMap.put(uid, mList);
        }
        if (imgView != null) {
            mList.add(imgView);
        }
    }

    protected static class MessageViewHolder {
        View contentView;
        ImageView msgHeadIcon;
        ImageView msgRedDotIcon;
        View msgContain1;
        TextView msgContent;
        TextView msgDynamicContent;
        View vDynamicContent;
        TextView msgTitle;
        TextView msgSubContent;
        TextView msgPublicTime;
        List<ImageView> imgViews = new ArrayList<ImageView>();

        protected MessageViewHolder() {
        }

        public void setMessageStautus(String msgClassifyId, boolean isRead) {
            if (null == this.contentView || null == this.msgRedDotIcon) {
                return;
            }
            if (TextUtils.equals((CharSequence)String.valueOf(0), (CharSequence)msgClassifyId)) {
                this.contentView.setBackgroundResource(R.drawable.bg_profile_white_btn_slector);
                this.msgRedDotIcon.setVisibility(isRead ? 8 : 0);
            } else {
                this.contentView.setBackgroundResource(isRead ? R.drawable.bg_profile_white_btn_slector : R.drawable.bg_profile_yellow_btn_selector);
                this.msgRedDotIcon.setVisibility(8);
            }
        }
    }
}

