/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.messagenotifycenter;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.mobile.bizmodel.login.ILoginCore;
import com.yy.mobile.bizmodel.login.LoginStateType;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.messagenotifycenter.IMessageHistoryPresenter;
import com.yy.mobile.ui.messagenotifycenter.IMessageHistoryView;
import com.yy.mobile.ui.messagenotifycenter.MessageHistoryPresenter;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.SimpleRightTextTitleBar;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yymobile.core.CoreFactory;

public class MessageHistoryActivity
extends BaseActivity
implements IMessageHistoryView {
    private static final String TAG = "MessageHistoryActivity";
    private IMessageHistoryPresenter messageHistoryPresenter;
    private static final int MESSAGE_HISTORY_LOGIN_REQ = 12;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_message_history);
        this.messageHistoryPresenter = new MessageHistoryPresenter(this);
        this.messageHistoryPresenter.onCreate(savedInstanceState, this.getIntent());
        this.initTitleBar();
        this.initListView();
    }

    private void initTitleBar() {
        SimpleRightTextTitleBar titleBar = (SimpleRightTextTitleBar)this.findViewById(R.id.message_history_title_bar);
        titleBar.setTitlte(this.messageHistoryPresenter.getTitle());
        titleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                MessageHistoryActivity.this.messageHistoryPresenter.onBackPress();
                MessageHistoryActivity.this.finish();
            }
        });
        View rootRightView = this.getLayoutInflater().inflate(R.layout.layout_simple_text_title_right, null);
        TextView clearNotify = (TextView)rootRightView.findViewById(R.id.simple_text_title_right);
        clearNotify.setText((CharSequence)this.getString(R.string.str_msg_clear));
        clearNotify.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
            }
        });
        titleBar.setRightView(rootRightView);
    }

    private void initListView() {
        PullToRefreshListView listView = (PullToRefreshListView)this.findViewById(R.id.lv_message_history);
        EndlessListScrollListener endlessListScrollListener = new EndlessListScrollListener((StatusLayout)this.findViewById(R.id.message_status_layout));
        this.messageHistoryPresenter.initListView(listView, endlessListScrollListener);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.messageHistoryPresenter.onSaveInstanceState(outState);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        this.messageHistoryPresenter.onBackPress();
        return super.onKeyDown(keyCode, event);
    }

    protected void onResume() {
        super.onResume();
        this.checkAutoLoginState();
    }

    protected void onDestroy() {
        this.messageHistoryPresenter.dispose();
        super.onDestroy();
    }

    @Override
    public void showToast(int msgId) {
        if (!this.checkActivityValid()) {
            return;
        }
        Toast.makeText((Context)this.getContext(), (CharSequence)this.getString(msgId), (int)0).show();
    }

    @Override
    public void showNoDataView() {
        this.showNoData(R.drawable.no_message_bg, R.string.no_data_mesaage);
    }

    @Override
    public void showClearNotifyDailog(OkCancelDialogListener dialogListener) {
        this.getDialogLinkManager().showDialog((IBaseDialog)new OkCancelDialog((CharSequence)this.getString(R.string.str_msg_clear_content), true, dialogListener));
    }

    public View.OnClickListener getLoadListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                MessageHistoryActivity.this.messageHistoryPresenter.reLoad();
            }
        };
    }

    public static void navigateFrom(Context context, String title, int classifyId) {
        Intent intent = new Intent(context, MessageHistoryActivity.class);
        intent.putExtra("title", title);
        intent.putExtra("classifyId", classifyId);
        NavigationUtils.slideStartActivity(context, intent);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 12: {
                if (resultCode != -1 || !data.getExtras().getBoolean("LoginOnBack")) break;
                this.finish();
                break;
            }
        }
    }

    private void checkAutoLoginState() {
        if (!LoginUtil.isLogined()) {
            if (((ILoginCore)CoreFactory.getCore(ILoginCore.class)).isTryAutoLogin() && (LoginUtil.getLoginState() == LoginStateType.NotLogin || LoginUtil.getLoginState() == LoginStateType.Disconnect || LoginUtil.getLoginState() == LoginStateType.Failed)) {
                this.showLoginDialog();
            } else {
                this.showLoginDialog();
            }
        }
    }
}

