/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.messagenotifycenter;

import android.os.Handler;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.event.ui.OnNotifyMsgUpdate;
import com.yy.mobile.image.PauseOnScrollListener;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.messagecenter.MessageClassifyInfo;
import com.yy.mobile.ui.messagenotifycenter.IMessageCenterPresenter;
import com.yy.mobile.ui.messagenotifycenter.IMessageCenterView;
import com.yy.mobile.ui.messagenotifycenter.MessageCenterAdapter;
import com.yy.mobile.ui.messagenotifycenter.MessageNotifyManager;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.TimeUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.messagenotifycenter.IMessageNotifyCenterCore;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.List;

public class MessageCenterPresenter
implements IMessageCenterPresenter {
    private static final String LOG_TAG = "MessageCenterPresenter";
    private IMessageCenterView mView;
    private PullToRefreshListView mListView;
    private MessageCenterAdapter mAdapter;
    private List<Disposable> mDisposableList = new ArrayList<Disposable>();
    private Runnable checkRequestTimeoutTask = new Runnable(){

        @Override
        public void run() {
            MessageCenterPresenter.this.mView.hideStatus();
            MessageCenterPresenter.this.mListView.onRefreshComplete();
            if (MessageCenterPresenter.this.mAdapter.getCount() == 0) {
                MessageCenterPresenter.this.mView.showReload();
            }
        }
    };
    private Runnable fixCompleteRefreshMsg = new Runnable(){

        @Override
        public void run() {
            MessageCenterPresenter.this.mListView.onRefreshComplete();
        }
    };

    public MessageCenterPresenter(IMessageCenterView view) {
        this.mView = view;
        this.registerRefreshFinish();
    }

    @Override
    public void onClearButtonClicked() {
        this.mView.showClearNotifyDialog(new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                MLog.info((String)MessageCenterPresenter.LOG_TAG, (String)"[MessageCenter].[updateAllMessageNotifyCenterStatus]");
                MessageNotifyManager.INSTANCE.updateAllMessageReadStatus();
            }
        });
    }

    @Override
    public void initListView(PullToRefreshListView listView) {
        this.mListView = listView;
        final Handler handler = this.mView.getHandler();
        this.mListView.setMode(PullToRefreshBase.Mode.PULL_FROM_START);
        this.mListView.setScrollingWhileRefreshingEnabled(true);
        this.mListView.setOnScrollListener((AbsListView.OnScrollListener)new PauseOnScrollListener(true, true));
        this.mListView.setOnRefreshListener((PullToRefreshBase.OnRefreshListener)new PullToRefreshBase.OnRefreshListener<ListView>(){

            public void onRefresh(PullToRefreshBase<ListView> refreshView) {
                if (!MessageCenterPresenter.this.mView.checkNetToast()) {
                    handler.removeCallbacks(MessageCenterPresenter.this.fixCompleteRefreshMsg);
                    handler.postDelayed(MessageCenterPresenter.this.fixCompleteRefreshMsg, 300L);
                    return;
                }
                if (LoginUtil.isLogined()) {
                    handler.removeCallbacks(MessageCenterPresenter.this.checkRequestTimeoutTask);
                    handler.postDelayed(MessageCenterPresenter.this.checkRequestTimeoutTask, TimeUtils.SECONDS.toMillis((long)10L));
                    MessageNotifyManager.INSTANCE.refresh();
                } else {
                    MessageCenterPresenter.this.mView.showToast(R.string.str_not_login_yet);
                }
            }
        });
        this.mAdapter = new MessageCenterAdapter();
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mView.showLoading();
        handler.removeCallbacks(this.checkRequestTimeoutTask);
        handler.postDelayed(this.checkRequestTimeoutTask, TimeUtils.SECONDS.toMillis((long)10L));
    }

    @Override
    public void onCreate() {
        MessageNotifyManager.INSTANCE.refresh();
    }

    @Override
    public void onResume() {
        if (((IMessageNotifyCenterCore)CoreFactory.getCore(IMessageNotifyCenterCore.class)).getDbCreateState()) {
            this.loadData();
        }
    }

    @Override
    public void reLoad() {
        this.mView.showLoading();
        this.mView.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        this.mView.getHandler().postDelayed(this.checkRequestTimeoutTask, TimeUtils.SECONDS.toMillis((long)10L));
        this.loadData();
    }

    private void registerRefreshFinish() {
        Disposable disposableItem = RxBus.getDefault().register(OnNotifyMsgUpdate.class).subscribe((Consumer)new Consumer<OnNotifyMsgUpdate>(){

            public void accept(@NonNull OnNotifyMsgUpdate onNotifyMsgUpdate) throws Exception {
                if (onNotifyMsgUpdate.getError() == null) {
                    MessageCenterPresenter.this.loadData();
                }
            }
        }, RxUtils.errorConsumer((String)LOG_TAG));
        this.mDisposableList.add(disposableItem);
    }

    private void loadData() {
        MessageNotifyManager.INSTANCE.loadData(new Observer<List<MessageClassifyInfo>>(){

            public void onSubscribe(Disposable d2) {
                MLog.info((String)MessageCenterPresenter.LOG_TAG, (String)"onSubscribe");
            }

            public void onNext(List<MessageClassifyInfo> messageClassifyInfoList) {
                MLog.info((Object)MessageCenterPresenter.LOG_TAG, (String)"onNext messageClassifyInfoList.size=%d", (Object[])new Object[]{FP.size(messageClassifyInfoList)});
                MessageCenterPresenter.this.onRefreshFinish(messageClassifyInfoList, null);
            }

            public void onError(Throwable e) {
                MLog.info((String)MessageCenterPresenter.LOG_TAG, (String)("onError Throwable" + e));
                MessageCenterPresenter.this.onRefreshFinish(null, e.getMessage());
            }

            public void onComplete() {
                MLog.info((String)MessageCenterPresenter.LOG_TAG, (String)"onComplete");
            }
        });
    }

    @Override
    public void dispose() {
        if (this.mView != null) {
            this.mView.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
            this.mView.getHandler().removeCallbacks(this.fixCompleteRefreshMsg);
        }
        for (Disposable d2 : this.mDisposableList) {
            d2.dispose();
        }
        if (this.mAdapter != null) {
            this.mAdapter.onDestroy();
        }
    }

    private void onRefreshFinish(List<MessageClassifyInfo> itemInfoList, String errorMsg) {
        this.mView.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        MLog.info((Object)LOG_TAG, (String)"onUpdateAdapter list.size=%d, error=%s, checkActivityValid=%s", (Object[])new Object[]{FP.size(itemInfoList), errorMsg, this.mView.isActivityAvailable() ? "true" : "false"});
        this.mAdapter.updateData(new ArrayList<MessageClassifyInfo>());
        this.mAdapter.notifyDataSetChanged();
        if (this.mView.isActivityAvailable() && itemInfoList != null && itemInfoList.size() > 0 && errorMsg == null) {
            if (itemInfoList != null && this.mListView != null && this.mAdapter != null) {
                this.mListView.onRefreshComplete();
                MLog.info((Object)LOG_TAG, (String)"mAdapter.updateData list.size=%d", (Object[])new Object[]{FP.size(itemInfoList)});
                this.mAdapter.updateData(itemInfoList);
                this.mAdapter.notifyDataSetChanged();
            } else if (this.mListView != null) {
                this.mListView.onRefreshComplete();
            }
            this.mView.hideStatus();
        } else if (this.mView.isActivityAvailable() && FP.size(itemInfoList) == 0) {
            if (!this.mView.isNetWorkAvailable()) {
                this.mView.showNetworkErr();
                this.mView.showToast(R.string.nonetwork);
            } else {
                this.mView.showNotData();
                MLog.info((String)LOG_TAG, (String)"show No data");
            }
        }
    }
}

