/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.messagenotifycenter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.messagecenter.MessageClassifyInfo;
import com.yy.mobile.ui.messagenotifycenter.MessageBaseAdapter;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.messagenotifycenter.templetmessage.TemplateMessage;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MessageCenterAdapter
extends MessageBaseAdapter {
    private List<MessageClassifyInfo> mData = new ArrayList<MessageClassifyInfo>();
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();

    public void updateData(List<MessageClassifyInfo> data) {
        this.handleNewData(data);
    }

    private void handleNewData(List<MessageClassifyInfo> newData) {
        this.mData.clear();
        this.mData.addAll(newData);
    }

    public List<MessageClassifyInfo> getData() {
        return this.mData;
    }

    public int getCount() {
        return this.mData == null ? 0 : this.mData.size();
    }

    public MessageClassifyInfo getItem(int position) {
        return this.mData.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Context context = parent.getContext();
        MessageClassifyInfo messageInfo = this.mData.get(position);
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)context).inflate(R.layout.item_msg_center_title, null);
            ClassifyViewHolder classifyTemplateMessageHolder = new ClassifyViewHolder();
            classifyTemplateMessageHolder.msgCategoryIcon = (RecycleImageView)convertView.findViewById(R.id.msg_category_icon);
            classifyTemplateMessageHolder.msgCategoryName = (TextView)convertView.findViewById(R.id.msg_category_text);
            classifyTemplateMessageHolder.msgNumber = (TextView)convertView.findViewById(R.id.msg_category_nums);
            classifyTemplateMessageHolder.contain1 = convertView.findViewById(R.id.msg_category_layout);
            convertView.setTag((Object)classifyTemplateMessageHolder);
            this.setClassifyData(classifyTemplateMessageHolder, messageInfo, context);
        } else {
            Object holder = convertView.getTag();
            this.setClassifyData((ClassifyViewHolder)holder, messageInfo, context);
        }
        return convertView;
    }

    private void setClassifyData(ClassifyViewHolder holder, final MessageClassifyInfo messageInfo, final Context context) {
        holder.contain1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (MessageCenterAdapter.this.mTimeSlotTool.isProcessing()) {
                    return;
                }
                Property property = new Property();
                property.putString(String.valueOf(messageInfo.getClassifyId()), "1");
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1803", "0005", (Serializable)property);
                NavigationUtils.toMessageHistoryActivity(context, messageInfo.getClassifyName(), messageInfo.getClassifyId());
            }
        });
        holder.msgCategoryIcon.setImageResource(messageInfo.getIcon());
        holder.msgCategoryName.setText((CharSequence)messageInfo.getClassifyName());
        this.updateUnreadNotifyTipsView(holder.msgNumber, messageInfo.getUnReadCount());
    }

    @Override
    public void deleteOneData(TemplateMessage templateMessage) {
    }

    private void updateUnreadNotifyTipsView(TextView messageText, int count) {
        if (messageText != null && count <= 0) {
            messageText.setVisibility(8);
            return;
        }
        if (messageText != null) {
            messageText.setVisibility(0);
            if (count > 0) {
                if (count < 10) {
                    messageText.setBackgroundResource(R.drawable.discovery_dot);
                    messageText.setText((CharSequence)String.valueOf(count));
                } else if (count > 99) {
                    count = 99;
                    messageText.setBackgroundResource(R.drawable.discovery_message_nums);
                    messageText.setText((CharSequence)String.valueOf(count + "+"));
                } else {
                    messageText.setBackgroundResource(R.drawable.discovery_message_nums);
                    messageText.setText((CharSequence)String.valueOf(count));
                }
            }
        }
    }

    protected static class ClassifyViewHolder {
        RecycleImageView msgCategoryIcon;
        TextView msgCategoryName;
        TextView msgNumber;
        View contain1;

        protected ClassifyViewHolder() {
        }
    }
}

