/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.messagenotifycenter;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.annotation.RouteDoc;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.mobile.bizmodel.login.ILoginCore;
import com.yy.mobile.bizmodel.login.LoginStateType;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.messagenotifycenter.IMessageCenterPresenter;
import com.yy.mobile.ui.messagenotifycenter.IMessageCenterView;
import com.yy.mobile.ui.messagenotifycenter.MessageCenterPresenter;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.NetworkUtils;
import com.yymobile.core.CoreFactory;

@Route(path="/MessageCenter/MessageMainPage", name="\u6d88\u606f\u4e2d\u5fc3")
@RouteDoc(desc="\u6d88\u606f\u4e2d\u5fc3\u9875\u9762", minVer="7.16.0", eg="yymobile://MessageCenter/MessageMainPage")
public class MessageCenterActivity
extends BaseActivity
implements IMessageCenterView {
    private static final String TAG = "MessageCenterActivity";
    public static final String LOGIN_SUCCEED_FROM_MES_CENTER = "LOGIN_SUCCEED_FROM_MES_CENTER";
    private static final int MESSAGE_CENTER_LOGIN_REQ = 246;
    private IMessageCenterPresenter messageCenterPresenter;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_message_center);
        this.messageCenterPresenter = new MessageCenterPresenter(this);
        this.messageCenterPresenter.onCreate();
        this.initTitleBar();
        this.initListView();
    }

    protected void onResume() {
        super.onResume();
        this.messageCenterPresenter.onResume();
        this.checkAutoLoginState();
    }

    private void initTitleBar() {
        SimpleTitleBar titleBar = (SimpleTitleBar)this.findViewById(R.id.message_center_title_bar);
        titleBar.setTitlte(this.getString(R.string.str_msg_center));
        titleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                MessageCenterActivity.this.finish();
            }
        });
        View rootRightView = this.getLayoutInflater().inflate(R.layout.layout_simple_text_title_right, null);
        TextView clearNotify = (TextView)rootRightView.findViewById(R.id.simple_text_title_right);
        clearNotify.setText((CharSequence)this.getString(R.string.str_msg_ignore));
        clearNotify.setTextSize(16.0f);
        clearNotify.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MessageCenterActivity.this.messageCenterPresenter.onClearButtonClicked();
            }
        });
        titleBar.setRightView(rootRightView);
    }

    private void initListView() {
        PullToRefreshListView listView = (PullToRefreshListView)this.findViewById(R.id.lv_message_center);
        this.messageCenterPresenter.initListView(listView);
    }

    protected void onDestroy() {
        this.messageCenterPresenter.dispose();
        super.onDestroy();
    }

    @Override
    public void showToast(int msgId) {
        Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(msgId), (int)0).show();
    }

    @Override
    public boolean isActivityAvailable() {
        return this.checkActivityValid();
    }

    @Override
    public boolean isNetWorkAvailable() {
        return NetworkUtils.isNetworkStrictlyAvailable((Context)this.getContext());
    }

    @Override
    public void showNotData() {
        this.showNoData(R.drawable.no_message_bg, R.string.no_data_mesaage);
    }

    @Override
    public void showClearNotifyDialog(OkCancelDialogListener dialogListener) {
        this.getDialogLinkManager().showDialog((IBaseDialog)new OkCancelDialog((CharSequence)this.getString(R.string.str_msg_ignore_content), true, dialogListener));
    }

    public View.OnClickListener getLoadListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                MessageCenterActivity.this.messageCenterPresenter.reLoad();
            }
        };
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 246: {
                if (resultCode != -1 || !data.getExtras().getBoolean("LoginOnBack")) break;
                this.finish();
                break;
            }
        }
    }

    private void checkAutoLoginState() {
        if (LoginUtil.isLogined()) {
            return;
        }
        if (!LoginUtil.isLogined()) {
            if (((ILoginCore)CoreFactory.getCore(ILoginCore.class)).isTryAutoLogin() && (LoginUtil.getLoginState() == LoginStateType.NotLogin || LoginUtil.getLoginState() == LoginStateType.Disconnect || LoginUtil.getLoginState() == LoginStateType.Failed)) {
                this.showLoginDialog();
            } else {
                this.showLoginDialog();
            }
        }
    }
}

