/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.messagenotifycenter;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkDialog;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestDetailUserInfo_EventArgs;
import com.yy.mobile.ui.dialog.DialogLinkManager;
import com.yy.mobile.ui.dialog.IDialogLinkManagerCore;
import com.yy.mobile.ui.messagenotifycenter.MessageBaseAdapter$$EventBinder;
import com.yy.mobile.ui.utils.router.rest.INavHandlerCallBack;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreError;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.download.DownLoadFileInfo;
import com.yymobile.core.download.IDownLoadCore;
import com.yymobile.core.messagenotifycenter.IMessageNotifyCenterCore;
import com.yymobile.core.messagenotifycenter.templetmessage.TemplateMessage;
import com.yymobile.core.user.UserInfo;
import java.io.File;
import java.util.HashMap;
import java.util.List;

public abstract class MessageBaseAdapter
extends BaseAdapter
implements EventCompat {
    public static final int MES_LIST_TYPE = 1;
    public static final int MES_HOSTORY_TYPE = 2;
    private static final String LOG_TAG = "MessageBaseAdapter";
    protected HashMap<Long, List<ImageView>> headIconMap = new HashMap();
    protected INavHandlerCallBack universalCallback = new INavHandlerCallBack(){

        public void onCallback(Activity context, String uri, Object others) {
            MLog.info((String)MessageBaseAdapter.LOG_TAG, (String)"[MessageCenter].[onCallback]");
            final String yyVersion = ((IMessageNotifyCenterCore)CoreFactory.getCore(IMessageNotifyCenterCore.class)).queryLatestYYVersion();
            if (!FP.empty((CharSequence)yyVersion)) {
                try {
                    if (VersionUtil.getVerFromStr((String)yyVersion).bigThan(VersionUtil.getLocalVer((Context)BasicConfig.getInstance().getAppContext()))) {
                        DialogLinkManager dialogLinkManager = ((IDialogLinkManagerCore)ICoreManagerBase.getCore(IDialogLinkManagerCore.class)).getDialogLinkManager();
                        if (dialogLinkManager != null) {
                            String message = "\u5f53\u524d\u7248\u672c\u8fc7\u4f4e\n\n\u4e0d\u652f\u6301\u6b64\u529f\u80fd\u8bf7\u66f4\u65b0\u81f3" + yyVersion + "\u7248\u672c";
                            String okLable = "\u9a6c\u4e0a\u66f4\u65b0";
                            int okLableColor = 0;
                            String cancelLabel = "\u6682\u4e0d\u4e0b\u8f7d";
                            int cancelLabelColor = Color.parseColor((String)"FF808080");
                            boolean cancelable = true;
                            boolean outSideCancelable = true;
                            dialogLinkManager.showDialog((IBaseDialog)new OkCancelDialog((CharSequence)message, (CharSequence)okLable, okLableColor, (CharSequence)cancelLabel, cancelLabelColor, cancelable, outSideCancelable, new OkCancelDialogListener(){

                                public void onCancel() {
                                }

                                public void onOk() {
                                    String url = ((IMessageNotifyCenterCore)CoreFactory.getCore(IMessageNotifyCenterCore.class)).queryDownLoadYYUrl();
                                    MLog.info((String)MessageBaseAdapter.LOG_TAG, (String)("[MessageCenter].[onCallback].url=" + url));
                                    if (!FP.empty((CharSequence)url)) {
                                        int index = url.lastIndexOf(File.separatorChar);
                                        String storageName = System.currentTimeMillis() + "";
                                        if (index != -1) {
                                            storageName = url.substring(index + 1);
                                        }
                                        DownLoadFileInfo downLoadFileInfo = new DownLoadFileInfo("\u624b\u673aYY " + yyVersion, storageName, url, storageName, storageName, "application/vnd.android.package-archive");
                                        ((IDownLoadCore)CoreFactory.getCore(IDownLoadCore.class)).addFileToDownLoadList(downLoadFileInfo, -1);
                                    }
                                }
                            }));
                        }
                    } else {
                        DialogLinkManager dialogLinkManager = ((IDialogLinkManagerCore)ICoreManagerBase.getCore(IDialogLinkManagerCore.class)).getDialogLinkManager();
                        if (dialogLinkManager != null) {
                            dialogLinkManager.showDialog((IBaseDialog)new OkDialog((CharSequence)"\u5f53\u524d\u7248\u672c\u4e0d\u652f\u6301\n\n\u7a0d\u540e\u8bf7\u7559\u610f\u7248\u672c\u66f4\u65b0\u4fe1\u606f", (CharSequence)"\u6211\u77e5\u9053\u4e86", 0, true, null));
                        }
                    }
                }
                catch (Throwable t) {
                    MLog.error((String)MessageBaseAdapter.LOG_TAG, (String)"[MessageCenter] convert to Ver error");
                }
            }
        }
    };
    private EventBinder mEventBinder;

    public MessageBaseAdapter() {
        CoreManager.addClient((Object)((Object)this));
    }

    public void onEventBind() {
        if (this.mEventBinder == null) {
            this.mEventBinder = new MessageBaseAdapter$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    public abstract void deleteOneData(TemplateMessage var1);

    public void loadImageSet(List<? extends ImageView> imgViews, List<String> urls) {
        if (imgViews != null && imgViews.size() > 0 && urls != null && urls.size() > 0) {
            int count = imgViews.size() > urls.size() ? urls.size() : imgViews.size();
            for (int i = 0; i < count; ++i) {
                String url = urls.get(i);
                ImageView imageView = imgViews.get(i);
                Context context = imageView.getContext();
                imageView.setImageResource(R.drawable.default_live_drawable);
                Glide.with((Context)context).load((Object)url).into(imageView);
            }
        }
    }

    @BusEvent
    public void onRequestDetailUserInfo(IUserClient_onRequestDetailUserInfo_EventArgs busEventArgs) {
        long userId = busEventArgs.getUserId();
        UserInfo info = busEventArgs.getInfo();
        CoreError error = busEventArgs.getError();
        if (error != null || info == null) {
            MLog.info((String)LOG_TAG, (String)"onRequestDetailUserInfo:error");
            return;
        }
        MLog.info((String)LOG_TAG, (String)("onRequestDetailUserInfo:UserInfo:" + info.iconUrl));
        List<ImageView> tmpIcons = this.headIconMap.get(userId);
        if (tmpIcons != null) {
            for (ImageView tmpIcon : tmpIcons) {
                if (tmpIcon == null) continue;
                try {
                    long uid = (Long)tmpIcon.getTag();
                    if (uid != userId) continue;
                    tmpIcon.setImageResource(R.drawable.default_portrait);
                    Context context = tmpIcon.getContext();
                    if ("".equals(info.iconUrl)) continue;
                    Glide.with((Context)context).load((Object)info.iconUrl).into(tmpIcon);
                }
                catch (Throwable throwable) {
                    MLog.error((Object)LOG_TAG, (Throwable)throwable);
                }
            }
        }
    }

    public void onDestroy() {
        CoreManager.removeClient((Object)((Object)this));
        if (this.headIconMap != null) {
            this.headIconMap.clear();
        }
    }
}

