/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.messagenotifycenter;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.mobile.bizmodel.login.ILoginCore;
import com.yy.mobile.bizmodel.login.LoginStateType;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseDarkModeActivity;
import com.yy.mobile.ui.messagenotifycenter.IMessageHistoryPresenter;
import com.yy.mobile.ui.messagenotifycenter.IMessageHistoryView;
import com.yy.mobile.ui.messagenotifycenter.MessageHistoryPresenter;
import com.yy.mobile.ui.messagenotifycenter.menu.MenuPopupWindow;
import com.yy.mobile.ui.messagenotifycenter.statistic.InteractiveStatistic;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.SimpleRightTextTitleBar;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;

public class InteractiveMessageActivity
extends BaseDarkModeActivity
implements IMessageHistoryView {
    private static final String TAG = "InteractiveMessageActivity";
    private static final int MESSAGE_HISTORY_LOGIN_REQ = 12;
    private IMessageHistoryPresenter messageHistoryPresenter;
    private SimpleRightTextTitleBar mTitleBar;
    private TextView mCenterTitle;
    public static final String LOGIN_ON_BACK = "LoginOnBack";

    public static void skipToSystemMsgActivity(Context context) {
        InteractiveMessageActivity.skipToMsgNotifyActivity(context, "\u5168\u90e8\u7cfb\u7edf\u901a\u77e5", 0, false, true);
    }

    public static void skipToInteractMsgActivity(Context context) {
        InteractiveMessageActivity.skipToMsgNotifyActivity(context, "\u5168\u90e8\u4e92\u52a8\u6d88\u606f", 1, false, true);
    }

    public static void skipToMsgNotifyActivity(Context context, String defaultAlltitle, int classifyId, boolean showRightBtn, boolean updateStatusWithFinish) {
        Intent intent = new Intent(context, InteractiveMessageActivity.class);
        intent.putExtra("title", defaultAlltitle);
        intent.putExtra("classifyId", classifyId);
        intent.putExtra("canShorRightTitleBtn", showRightBtn);
        intent.putExtra("update_with_back", updateStatusWithFinish);
        NavigationUtils.slideStartActivity(context, intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_message_history);
        this.messageHistoryPresenter = new MessageHistoryPresenter(this);
        this.messageHistoryPresenter.onCreate(savedInstanceState, this.getIntent());
        this.initTitleBar();
        this.initListView();
    }

    private void initTitleBar() {
        this.mTitleBar = (SimpleRightTextTitleBar)this.findViewById(R.id.message_history_title_bar);
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                InteractiveMessageActivity.this.messageHistoryPresenter.onBackPress();
                InteractiveMessageActivity.this.finish();
            }
        });
        View rootCenterView = this.getLayoutInflater().inflate(R.layout.message_titlebar_center_view, null);
        this.mCenterTitle = (TextView)rootCenterView.findViewById(R.id.interactive_title_center_text);
        this.mCenterTitle.setText((CharSequence)this.messageHistoryPresenter.getTitle());
        this.mCenterTitle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                InteractiveMessageActivity.this.showMessageMenu();
            }
        });
        this.mTitleBar.setCenterView(rootCenterView);
        if (this.messageHistoryPresenter.showRightTitlBtn()) {
            this.mTitleBar.setRightText(this.getString(R.string.str_msg_ignore), new View.OnClickListener(){

                public void onClick(View v) {
                    InteractiveMessageActivity.this.showIgnoreNoReadMsg();
                }
            });
        }
    }

    protected void onRestart() {
        super.onRestart();
        MLog.info((String)TAG, (String)"onRestart");
        this.messageHistoryPresenter.handleRestart();
    }

    private void initListView() {
        PullToRefreshListView listView = (PullToRefreshListView)this.findViewById(R.id.lv_message_history);
        listView.setHeaderBackgroundColor(this.getResources().getColor(R.color.common_f1_color));
        EndlessListScrollListener endlessListScrollListener = new EndlessListScrollListener((StatusLayout)this.findViewById(R.id.message_status_layout));
        this.messageHistoryPresenter.initListView(listView, endlessListScrollListener);
    }

    private void showIgnoreNoReadMsg() {
        this.getDialogLinkManager().showDialog((IBaseDialog)new OkCancelDialog((CharSequence)this.getString(R.string.str_msg_ignore_content), true, new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                if (null != InteractiveMessageActivity.this.messageHistoryPresenter) {
                    InteractiveMessageActivity.this.messageHistoryPresenter.updateAllMsgReaded();
                }
            }
        }));
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.messageHistoryPresenter.onSaveInstanceState(outState);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        this.messageHistoryPresenter.onBackPress();
        return super.onKeyDown(keyCode, event);
    }

    public void onResume() {
        super.onResume();
        this.checkAutoLoginState();
    }

    protected void onDestroy() {
        this.messageHistoryPresenter.dispose();
        super.onDestroy();
    }

    @Override
    public void showToast(int msgId) {
        if (!this.checkActivityValid()) {
            return;
        }
        Toast.makeText((Context)this.getContext(), (CharSequence)this.getString(msgId), (int)0).show();
    }

    @Override
    public void showClearNotifyDailog(OkCancelDialogListener dialogListener) {
    }

    @Override
    public void showNoDataView() {
        this.showNoData(R.drawable.no_message_bg, R.string.str_msg_no);
    }

    public View.OnClickListener getLoadListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                InteractiveMessageActivity.this.messageHistoryPresenter.reLoad();
            }
        };
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 12: {
                if (resultCode != -1 || !data.getExtras().getBoolean(LOGIN_ON_BACK)) break;
                this.finish();
                break;
            }
        }
    }

    private void showMessageMenu() {
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.menu_down_btn_down);
        drawable2.setBounds(0, 0, drawable2.getMinimumWidth(), drawable2.getMinimumHeight());
        this.mCenterTitle.setCompoundDrawables(null, null, drawable2, null);
        int[] location = new int[2];
        this.mCenterTitle.getLocationOnScreen(location);
        MenuPopupWindow menuPopupWindow = new MenuPopupWindow((Context)this, this.mCenterTitle.getText().toString(), this.messageHistoryPresenter.getTitle());
        menuPopupWindow.showAtLocation((View)this.mTitleBar, 49, 0, this.mCenterTitle.getHeight() + location[1]);
        menuPopupWindow.setOnMenuItemSelectChanged(new MenuPopupWindow.OnMenuItemChanged(){

            @Override
            public void onItemChanged(String itemText, int classifyId) {
                InteractiveStatistic.clickMenu(classifyId);
                InteractiveMessageActivity.this.mCenterTitle.setText((CharSequence)itemText);
                InteractiveMessageActivity.this.messageHistoryPresenter.reLoad(classifyId);
            }
        });
        if (null != this.messageHistoryPresenter) {
            menuPopupWindow.updateMenu(this.messageHistoryPresenter.getMsgTypes());
        }
    }

    private void checkAutoLoginState() {
        if (!LoginUtil.isLogined()) {
            if (((ILoginCore)CoreFactory.getCore(ILoginCore.class)).isTryAutoLogin() && (LoginUtil.getLoginState() == LoginStateType.NotLogin || LoginUtil.getLoginState() == LoginStateType.Disconnect || LoginUtil.getLoginState() == LoginStateType.Failed)) {
                this.showLoginDialog();
            } else {
                this.showLoginDialog();
            }
        }
    }
}

