/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.messagenotifycenter;

import android.text.TextUtils;
import android.widget.BaseAdapter;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.event.ui.OnNotifyMsgUpdate;
import com.yy.mobile.plugin.main.events.IMessageNotifyCenterClient_onCreateOrUpdateMessageNotifyCenterComplete_EventArgs;
import com.yy.mobile.plugin.main.events.IMessageNotifyCenterClient_onDeleteMessageNotifyCenterByClassifyId_EventArgs;
import com.yy.mobile.plugin.main.events.IMessageNotifyCenterClient_onQueryMessageNotifyCenterAll_EventArgs;
import com.yy.mobile.plugin.main.events.IMessageNotifyCenterClient_onQueryMessageNotifyCenterByClassifyId_EventArgs;
import com.yy.mobile.plugin.main.events.IMessageNotifyCenterClient_updateMessageNotifyCenterStatusByClassifyId_EventArgs;
import com.yy.mobile.plugin.main.events.IMessageNotifyCenterClient_updateMessageNotifyCenterStatusByMsgClassifyId_EventArgs;
import com.yy.mobile.ui.messagecenter.IMessagePresenter;
import com.yy.mobile.ui.messagenotifycenter.HostMessagePresenter$$EventBinder;
import com.yy.mobile.ui.messagenotifycenter.MessageHistoryAdapter;
import com.yy.mobile.ui.messagenotifycenter.MessageHistoryPresenter;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.CoreError;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.messagenotifycenter.IMessageNotifyCenterCore;
import com.yymobile.core.messagenotifycenter.templetmessage.BaseTemplateMessage;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HostMessagePresenter
extends EmptyEventCompat
implements IMessagePresenter {
    private static final String LOG_TAG = "HostMessagePresenter";
    private static final String QUERY_FROM = "HostMessagePresenter";
    private static final Uint32 SHORT_VIDEO = new Uint32(6);
    private ObservableEmitter mLoadObserver;
    MessageHistoryAdapter mAdapter;
    private int mClassifyId;
    public boolean mShouldClear = false;
    private Map<Integer, String> mBusinessTypesMap;
    private EventBinder mEventBinder;

    public HostMessagePresenter(int classifyId) {
        this.mClassifyId = classifyId;
        ICoreManagerBase.addClient((Object)((Object)this));
        this.mBusinessTypesMap = new TreeMap<Integer, String>();
        this.mBusinessTypesMap.put(-1, "\u5168\u90e8");
    }

    public void setClassifyId(int classifyId) {
        this.mClassifyId = classifyId;
    }

    public BaseAdapter getAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = new MessageHistoryAdapter();
        }
        return this.mAdapter;
    }

    public Observable loadData(int startIndex) {
        MLog.info((Object)"HostMessagePresenter", (String)"loadData startIndex=%d , classifyId = %d", (Object[])new Object[]{startIndex, this.mClassifyId});
        this.mShouldClear = startIndex <= 0;
        return this.getLoadDataObservable(-1, startIndex);
    }

    public Observable loadData(int businessType, int startIndex) {
        MLog.info((Object)"HostMessagePresenter", (String)"loadData startIndex=%d , classifyId = %d", (Object[])new Object[]{startIndex, this.mClassifyId});
        this.mShouldClear = startIndex <= 0;
        return this.getLoadDataObservable(businessType, startIndex);
    }

    public Map<Integer, String> getBusinessMsgTypes() {
        return this.mBusinessTypesMap;
    }

    private Observable getLoadDataObservable(final int businessType, final int startIndex) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe(){

            public void subscribe(@NonNull ObservableEmitter observer) throws Exception {
                HostMessagePresenter.this.mLoadObserver = observer;
                if (businessType == -1) {
                    ((IMessageNotifyCenterCore)CoreFactory.getCore(IMessageNotifyCenterCore.class)).queryMessageNotifyCenterAllStartNumForHistory(startIndex, MessageHistoryPresenter.PAGE_SIZE, "HostMessagePresenter");
                } else {
                    ((IMessageNotifyCenterCore)CoreFactory.getCore(IMessageNotifyCenterCore.class)).queryMessageNotifyCenterByClassifyIdStartNumForHistory(businessType, startIndex, MessageHistoryPresenter.PAGE_SIZE, "HostMessagePresenter");
                }
            }
        });
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onQueryMessageNotifyCenterAll(IMessageNotifyCenterClient_onQueryMessageNotifyCenterAll_EventArgs busEventArgs) {
        MLog.info((String)"HostMessagePresenter", (String)"onQueryMessageNotifyCenterAll receiver");
        List messagesList = busEventArgs.getMessagesList();
        CoreError error = busEventArgs.getError();
        String from = busEventArgs.getFrom();
        if (!"HostMessagePresenter".equals(from)) {
            return;
        }
        if (FP.empty((Collection)messagesList)) {
            if (this.mLoadObserver != null) {
                this.mLoadObserver.onNext(new ArrayList());
            }
            return;
        }
        MLog.info((Object)"HostMessagePresenter", (String)"onQueryMessageNotifyCenterByClassifyId messagesList.size()=%d , error=%s", (Object[])new Object[]{messagesList.size(), error == null ? "" : error.message});
        List showMessageList = messagesList;
        if (this.mLoadObserver != null) {
            if (error != null) {
                this.mLoadObserver.onError((Throwable)new Exception(error.message));
            } else {
                this.mLoadObserver.onNext((Object)FP.size((Collection)messagesList));
                this.mLoadObserver.onNext((Object)showMessageList);
                this.mLoadObserver.onComplete();
            }
            this.mLoadObserver = null;
        }
        Collections.sort(showMessageList, new Comparator<BaseTemplateMessage>(){

            @Override
            public int compare(BaseTemplateMessage lhs, BaseTemplateMessage rhs) {
                if (lhs.messageStatus != rhs.messageStatus) {
                    return lhs.messageStatus - rhs.messageStatus;
                }
                return (int)(rhs.messageTime - lhs.messageTime);
            }
        });
        this.setData(showMessageList, this.mShouldClear);
    }

    private List<BaseTemplateMessage> filterAllMessageList(List<BaseTemplateMessage> messagesList) {
        if (FP.size(messagesList) <= 0) {
            return messagesList;
        }
        ArrayList<BaseTemplateMessage> result = new ArrayList<BaseTemplateMessage>();
        String parentClassify = String.valueOf(this.mClassifyId);
        for (int i = 0; i < messagesList.size(); ++i) {
            BaseTemplateMessage item = messagesList.get(i);
            if (!TextUtils.equals((CharSequence)parentClassify, (CharSequence)item.msgClassify)) continue;
            result.add(item);
            if (this.mBusinessTypesMap.containsKey((int)item.classifyId)) continue;
            if (TextUtils.isEmpty((CharSequence)item.messageName)) {
                String name = ((IMessageNotifyCenterCore)ICoreManagerBase.getCore(IMessageNotifyCenterCore.class)).getClassifyNameByClassifyId((int)item.classifyId, true);
                this.mBusinessTypesMap.put((int)item.classifyId, name);
                continue;
            }
            this.mBusinessTypesMap.put((int)item.classifyId, item.messageName);
        }
        return result;
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onQueryMessageNotifyCenterByClassifyId(IMessageNotifyCenterClient_onQueryMessageNotifyCenterByClassifyId_EventArgs busEventArgs) {
        List messagesList = busEventArgs.getMessagesList();
        CoreError error = busEventArgs.getError();
        String from = busEventArgs.getFrom();
        if (!"HostMessagePresenter".equals(from)) {
            return;
        }
        MLog.info((Object)"HostMessagePresenter", (String)"onQueryMessageNotifyCenterByClassifyId messagesList.size()=%d , error=%s", (Object[])new Object[]{messagesList.size(), error == null ? "" : error.message});
        List<BaseTemplateMessage> showMessagesList = this.filterMessageList(messagesList);
        if (this.mLoadObserver != null) {
            if (error != null) {
                this.mLoadObserver.onError((Throwable)new Exception(error.message));
            } else {
                this.mLoadObserver.onNext((Object)FP.size((Collection)messagesList));
                this.mLoadObserver.onNext(showMessagesList);
                this.mLoadObserver.onComplete();
            }
            this.mLoadObserver = null;
        }
        Collections.sort(showMessagesList, new Comparator<BaseTemplateMessage>(){

            @Override
            public int compare(BaseTemplateMessage lhs, BaseTemplateMessage rhs) {
                if (lhs.messageStatus != rhs.messageStatus) {
                    return lhs.messageStatus - rhs.messageStatus;
                }
                return (int)(rhs.messageTime - lhs.messageTime);
            }
        });
        this.setData(showMessagesList, this.mShouldClear);
    }

    private List<BaseTemplateMessage> filterMessageList(List<BaseTemplateMessage> messagesList) {
        if (FP.size(messagesList) <= 0) {
            return messagesList;
        }
        ArrayList<BaseTemplateMessage> result = new ArrayList<BaseTemplateMessage>();
        String parentClassify = String.valueOf(this.mClassifyId);
        for (int i = 0; i < messagesList.size(); ++i) {
            BaseTemplateMessage item = messagesList.get(i);
            if (!TextUtils.equals((CharSequence)parentClassify, (CharSequence)item.msgClassify)) continue;
            result.add(item);
        }
        return result;
    }

    public void refresh(long userId) {
        MLog.info((Object)"HostMessagePresenter", (String)"refresh userId = %d", (Object[])new Object[]{userId});
        ((IMessageNotifyCenterCore)ICoreManagerBase.getCore(IMessageNotifyCenterCore.class)).requestMessageList(userId);
    }

    public void removeAllBusinessMessage(int businessType) {
        MLog.info((String)"HostMessagePresenter", (String)("removeAllBusinessMessage->" + businessType));
        ((IMessageNotifyCenterCore)ICoreManagerBase.getCore(IMessageNotifyCenterCore.class)).deleteMessageNotifyCenterByClassifyId(businessType);
    }

    public void removeAllClassifyMessage(int classifyId) {
        MLog.info((String)"HostMessagePresenter", (String)("removeAllClassifyMessage->" + classifyId));
        ((IMessageNotifyCenterCore)ICoreManagerBase.getCore(IMessageNotifyCenterCore.class)).deleteMessageNotifyCenterByMsgClassifyId(classifyId);
    }

    public void updateAllBusinessMessageReaded(int businessType) {
        MLog.info((String)"HostMessagePresenter", (String)("updateAllBusinessMessageReaded->" + businessType));
        if (-1 == businessType) {
            this.updateAllClassifyMessageReaded(this.mClassifyId);
        } else {
            ((IMessageNotifyCenterCore)CoreFactory.getCore(IMessageNotifyCenterCore.class)).updateMessageNotifyCenterStatusByClassifyId(this.mClassifyId, businessType);
        }
    }

    public void updateAllClassifyMessageReaded(int classify) {
        MLog.info((String)"HostMessagePresenter", (String)("updateAllClassifyMessageReaded->" + classify));
        ((IMessageNotifyCenterCore)CoreFactory.getCore(IMessageNotifyCenterCore.class)).updateMessageNotifyCenterStatusByMsgClassifyId(classify);
    }

    public void onDestroy() {
        if (this.mAdapter != null) {
            this.mAdapter.onDestroy();
        }
    }

    private void setData(List<BaseTemplateMessage> list, boolean shouldClear) {
        MLog.info((Object)"HostMessagePresenter", (String)"setData list.size=%d , shouldClear=%b", (Object[])new Object[]{list.size(), shouldClear});
        if (this.mAdapter != null) {
            if (shouldClear) {
                this.mAdapter.getData().clear();
            }
            this.mAdapter.getData().addAll(list);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onCreateOrUpdateMessageNotifyCenterComplete(IMessageNotifyCenterClient_onCreateOrUpdateMessageNotifyCenterComplete_EventArgs busEventArgs) {
        CoreError error = busEventArgs.getError();
        MLog.info((Object)"HostMessagePresenter", (String)"onCreateOrUpdateMessageNotifyCenterComplete error=%s", (Object[])new Object[]{error == null ? "" : error.message});
        this.mShouldClear = true;
        RxBus.getDefault().post((Object)new OnNotifyMsgUpdate(error));
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onDeleteMessageNotifyCenterByClassifyId(IMessageNotifyCenterClient_onDeleteMessageNotifyCenterByClassifyId_EventArgs busEventArgs) {
        long classifyId = busEventArgs.getClassifyId();
        int result = busEventArgs.getResult();
        CoreError error = busEventArgs.getError();
        MLog.info((Object)"HostMessagePresenter", (String)"onDeleteMessageNotifyCenterByClassifyId classifyId=%d, result=%d", (Object[])new Object[]{classifyId, result});
        if (error != null) {
            MLog.info((String)"HostMessagePresenter", (String)("[MessageCenter].[Error] error=" + error.code));
        }
        this.loadData(0);
        RxBus.getDefault().post((Object)new OnNotifyMsgUpdate(error));
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void updateMessageNotifyCenterStatusByClassifyId(IMessageNotifyCenterClient_updateMessageNotifyCenterStatusByClassifyId_EventArgs busEventArgs) {
        int classifyId = busEventArgs.getClassifyId();
        int result = busEventArgs.getResult();
        CoreError error = busEventArgs.getError();
        this.updateMessageNotifyCenterStatusByClassifyId(classifyId, result, error);
    }

    public void updateMessageNotifyCenterStatusByClassifyId(int classifyId, int result, CoreError error) {
        MLog.info((Object)"HostMessagePresenter", (String)"updateMessageNotifyCenterStatusByClassifyId error=%s", (Object[])new Object[]{error == null ? "" : error.message});
        this.loadData(0);
        RxBus.getDefault().post((Object)new OnNotifyMsgUpdate(error));
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void updateMessageNotifyCenterStatusByMsgClassifyId(IMessageNotifyCenterClient_updateMessageNotifyCenterStatusByMsgClassifyId_EventArgs busEventArgs) {
        int msgClassifyId = busEventArgs.getMsgClassifyId();
        int result = busEventArgs.getResult();
        CoreError error = busEventArgs.getError();
        this.updateMessageNotifyCenterStatusByMsgClassifyId(msgClassifyId, result, error);
    }

    public void updateMessageNotifyCenterStatusByMsgClassifyId(int msgClassifyId, int result, CoreError error) {
        MLog.info((String)"HostMessagePresenter", (String)"updateMessageNotifyCenterStatusByMsgClassifyId");
        RxBus.getDefault().post((Object)new OnNotifyMsgUpdate(error));
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new HostMessagePresenter$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

