/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.messagenotifycenter;

import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.event.ui.IMessageNotifyControl;
import com.yy.mobile.event.ui.OnNotifyMsgUpdate;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IMessageNotifyCenterClient_onCreateOrUpdateMessageNotifyCenterComplete_EventArgs;
import com.yy.mobile.plugin.main.events.IMessageNotifyCenterClient_onDeleteMessageNotifyCenterByMessageId_EventArgs;
import com.yy.mobile.plugin.main.events.IMessageNotifyCenterClient_onQueryMessageNotifyCenterClassifyAndThreeMessage_EventArgs;
import com.yy.mobile.plugin.main.events.IMessageNotifyCenterClient_onQueryMessageNotifyCenterStatus_EventArgs;
import com.yy.mobile.plugin.main.events.IMessageNotifyCenterClient_onUpdateMessageNotifyCenterAllStatus_EventArgs;
import com.yy.mobile.ui.messagecenter.IMessagePresenter;
import com.yy.mobile.ui.messagecenter.MessageClassifyInfo;
import com.yy.mobile.ui.messagenotifycenter.HostMessageNotifyControl$$EventBinder;
import com.yy.mobile.ui.messagenotifycenter.HostMessagePresenter;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreError;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.messagenotifycenter.IMessageNotifyCenterCore;
import com.yymobile.core.messagenotifycenter.IMessageNotifyCenterDbCore;
import com.yymobile.core.messagenotifycenter.templetmessage.ClassifyTemplateMessage;
import com.yymobile.core.messagenotifycenter.templetmessage.TemplateMessage;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;

public class HostMessageNotifyControl
extends EmptyEventCompat
implements IMessageNotifyControl {
    private static final String TAG = "HostMessageNotifyControl";
    private List<MessageClassifyInfo> mMessageTypeInfoList;
    private ObservableEmitter<Integer> mQueryRedDotObserver;
    private ObservableEmitter<List<MessageClassifyInfo>> mLoadDataObserver;
    private EventBinder mEventBinder;

    public HostMessageNotifyControl() {
        this.onEventBind();
        this.mMessageTypeInfoList = new ArrayList<MessageClassifyInfo>();
    }

    public List<MessageClassifyInfo> getClassifyInfos() {
        return this.mMessageTypeInfoList;
    }

    public IMessagePresenter getPresenter(int classifyId) {
        return new HostMessagePresenter(classifyId);
    }

    public void refresh() {
        MLog.info((String)TAG, (String)"refresh");
        ((IMessageNotifyCenterCore)CoreFactory.getCore(IMessageNotifyCenterCore.class)).requestMessageList(LoginUtil.getUid());
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onCreateOrUpdateMessageNotifyCenterComplete(IMessageNotifyCenterClient_onCreateOrUpdateMessageNotifyCenterComplete_EventArgs busEventArgs) {
        CoreError error = busEventArgs.getError();
        RxBus.getDefault().post((Object)new OnNotifyMsgUpdate(error));
        MLog.info((String)TAG, (String)("onCreateOrUpdateMessageNotifyCenterComplete error = " + (error == null ? "" : error.message)));
    }

    public void updateAllMessageReadStatus() {
        MLog.info((String)TAG, (String)"updateAllMessageReadStatus");
        ((IMessageNotifyCenterCore)CoreFactory.getCore(IMessageNotifyCenterCore.class)).updateAllMessageNotifyCenterStatus();
    }

    public Observable<List<MessageClassifyInfo>> loadData() {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)"loadData");
        }
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<List<MessageClassifyInfo>>(){

            public void subscribe(@NonNull ObservableEmitter<List<MessageClassifyInfo>> observer) throws Exception {
                HostMessageNotifyControl.this.mLoadDataObserver = observer;
                ((IMessageNotifyCenterCore)CoreFactory.getCore(IMessageNotifyCenterCore.class)).queryMessageNotifyCenterClassifyAndThreeMessage();
            }
        });
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onQueryMessageNotifyCenterClassifyAndThreeMessage(IMessageNotifyCenterClient_onQueryMessageNotifyCenterClassifyAndThreeMessage_EventArgs busEventArgs) {
        List templateMessages = busEventArgs.getTemplateMessages();
        CoreError error = busEventArgs.getError();
        MLog.info((String)TAG, (String)"onQueryMessageNotifyCenterClassifyAndThreeMessage");
        this.mMessageTypeInfoList = this.toMessageClassifyInfo(templateMessages);
        if (this.mLoadDataObserver != null) {
            if (error != null) {
                this.mLoadDataObserver.onError((Throwable)new Exception(error.message));
            } else {
                this.mLoadDataObserver.onNext(this.mMessageTypeInfoList);
                this.mLoadDataObserver.onComplete();
            }
            this.mLoadDataObserver = null;
        }
    }

    public Observable<Integer> queryUnReadMsgNumber() {
        MLog.info((String)TAG, (String)"queryUnReadMsgNumber");
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Integer>(){

            public void subscribe(@NonNull ObservableEmitter<Integer> observer) throws Exception {
                HostMessageNotifyControl.this.mQueryRedDotObserver = observer;
                ((IMessageNotifyCenterDbCore)ICoreManagerBase.getCore(IMessageNotifyCenterDbCore.class)).queryAllMessageNotifyCenterStatusNum();
            }
        }).observeOn(AndroidSchedulers.mainThread());
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onQueryMessageNotifyCenterStatus(IMessageNotifyCenterClient_onQueryMessageNotifyCenterStatus_EventArgs busEventArgs) {
        int num = busEventArgs.getNum();
        CoreError error = busEventArgs.getError();
        MLog.info((Object)TAG, (String)"onQueryMessageNotifyCenterStatus num = %d , error = %s", (Object[])new Object[]{num, error == null ? "" : error.message});
        if (this.mQueryRedDotObserver != null) {
            if (error != null) {
                this.mQueryRedDotObserver.onError((Throwable)new Exception(error.message));
            } else {
                this.mQueryRedDotObserver.onNext((Object)num);
                this.mQueryRedDotObserver.onComplete();
            }
            this.mQueryRedDotObserver = null;
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onDeleteMessageNotifyCenterByMessageId(IMessageNotifyCenterClient_onDeleteMessageNotifyCenterByMessageId_EventArgs busEventArgs) {
        long messageId = busEventArgs.getMessageId();
        int result = busEventArgs.getResult();
        CoreError error = busEventArgs.getError();
        MLog.info((Object)TAG, (String)"onDeleteMessageNotifyCenterByMessageId messageId=%d , result=%d , error=%s", (Object[])new Object[]{messageId, result, error == null ? "" : error.message});
        RxBus.getDefault().post((Object)new OnNotifyMsgUpdate(error));
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onUpdateMessageNotifyCenterAllStatus(IMessageNotifyCenterClient_onUpdateMessageNotifyCenterAllStatus_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        CoreError error = busEventArgs.getError();
        MLog.info((Object)TAG, (String)"onUpdateMessageNotifyCenterAllStatus result = %d , error = %s", (Object[])new Object[]{result, error == null ? "" : error.message});
        if (error != null) {
            MLog.info((String)TAG, (String)("onUpdateMessageNotifyCenterAllStatus error code = " + error.code));
        }
        RxBus.getDefault().post((Object)new OnNotifyMsgUpdate(error));
    }

    private List<MessageClassifyInfo> toMessageClassifyInfo(List<TemplateMessage> templateMessages) {
        ArrayList<MessageClassifyInfo> infoList = new ArrayList<MessageClassifyInfo>();
        if (!FP.empty(templateMessages)) {
            for (TemplateMessage msg : templateMessages) {
                if (!(msg instanceof ClassifyTemplateMessage)) continue;
                ClassifyTemplateMessage classifyMsg = (ClassifyTemplateMessage)msg;
                MessageClassifyInfo info = new MessageClassifyInfo(classifyMsg.classifyName, this.getIcon(classifyMsg.classifyImage));
                info.setUnReadCount(classifyMsg.noReadNum);
                info.setClassifyId(classifyMsg.classifyId);
                infoList.add(info);
            }
        }
        return infoList;
    }

    public int getIcon(int iconId) {
        int resId;
        switch (iconId) {
            case 1: {
                resId = R.drawable.icon_msg_center_system;
                break;
            }
            case 2: {
                resId = R.drawable.me_shenqu;
                break;
            }
            case 3: {
                resId = R.drawable.me_gallery;
                break;
            }
            case 7: {
                resId = R.drawable.me_live;
                break;
            }
            case 8: {
                resId = R.drawable.icon_moment_userinfo;
                break;
            }
            case 4: {
                resId = R.drawable.icon_msg_center_houyuan;
                break;
            }
            case 6: {
                resId = R.drawable.me_duanpai;
                break;
            }
            case 9: {
                resId = R.drawable.icon_msg_center_anchor;
                break;
            }
            case 10: {
                resId = R.drawable.icon_msg_center_qianbao;
                break;
            }
            case 11: {
                resId = R.drawable.pei_tongzhi;
                break;
            }
            case 12: {
                resId = R.drawable.icon_msg_center_onepiece;
                break;
            }
            default: {
                resId = R.drawable.message_item_default_icon;
            }
        }
        return resId;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new HostMessageNotifyControl$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

