/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.interact.adapter;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.ViewGroup;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.yy.mobile.plugin.homeapi.tab.HomeTabInfo;
import com.yy.mobile.ui.widget.BaseFragment;
import com.yy.mobile.ui.widget.pager.FixedPageFragmentAdapter;
import com.yy.mobile.ui.widget.pager.PagerFragment;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

public class InteractSubPageAdapter
extends FixedPageFragmentAdapter {
    private static final String TAG = "InteractSubPageAdapter";
    private List<HomeTabInfo> navItems = new ArrayList<HomeTabInfo>();
    private List<Class<? extends Fragment>> unChangeList = new ArrayList<Class<? extends Fragment>>();
    private BaseFragment mCurrenFragment;
    private Bundle mBundle;
    private Context mContext;

    public InteractSubPageAdapter(Context context, FragmentManager fm, Bundle bundle) {
        super(fm);
        this.mContext = context;
        this.mBundle = bundle;
    }

    public void setData(List<HomeTabInfo> navs) {
        this.diffChange(navs, this.navItems);
        this.navItems.clear();
        this.navItems.addAll(navs);
        this.notifyDataSetChanged();
    }

    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        super.setPrimaryItem(container, position, object);
        if (object instanceof BaseFragment) {
            this.mCurrenFragment = (BaseFragment)object;
        }
    }

    public BaseFragment getCurrenFragment() {
        return this.mCurrenFragment;
    }

    public BaseFragment getItem(int position) {
        HomeTabInfo navItem = this.navItems.get(position);
        if (navItem != null) {
            Bundle itemBundle = new Bundle();
            itemBundle.putAll(this.mBundle);
            itemBundle.putAll(navItem.getBundle());
            MLog.info((String)TAG, (String)("[getItem] itemBundle = " + itemBundle.toString()));
            if (TextUtils.isEmpty((CharSequence)navItem.getFragmentName())) {
                return new PagerFragment();
            }
            return (BaseFragment)Fragment.instantiate((Context)this.mContext, (String)navItem.getFragmentName(), (Bundle)itemBundle);
        }
        MLog.warn((String)TAG, (String)("[getItem] bug:" + this.navItems.size()));
        return new PagerFragment();
    }

    public int getCount() {
        MLog.debug((String)TAG, (String)("[getCount]" + this.navItems.size()));
        return this.navItems.size();
    }

    public CharSequence getPageTitle(int position) {
        return this.navItems.get(position).getTitle();
    }

    public int getItemPosition(Object object) {
        Boolean ret = this.unChangeList.contains(object.getClass());
        MLog.info((String)TAG, (String)("fragment position is no change:" + ret + " obj is:" + object.getClass().getSimpleName()));
        if (ret.booleanValue()) {
            return -1;
        }
        return -2;
    }

    private void diffChange(List<HomeTabInfo> news, List<HomeTabInfo> olds) {
        this.unChangeList.clear();
        for (int i = 0; i < olds.size() && i < news.size(); ++i) {
            HomeTabInfo newInfo;
            HomeTabInfo oldInfo = olds.get(i);
            if (!oldInfo.equals((Object)(newInfo = news.get(i)))) continue;
            this.unChangeList.add(newInfo.getTabId().getFragment());
        }
    }

    public int getTabPosition(String alias) {
        if (FP.empty((CharSequence)alias)) {
            return -1;
        }
        for (int t = 0; t < this.navItems.size(); ++t) {
            HomeTabInfo info = this.navItems.get(t);
            if (!alias.equals(info.getAlias())) continue;
            return t;
        }
        return -1;
    }

    public HomeTabInfo getItemData(int pos) {
        if (this.navItems != null) {
            return this.navItems.get(pos);
        }
        return null;
    }
}

