/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.interact;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProviders;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.AutowiredDoc;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.annotation.RouteDoc;
import com.alibaba.android.arouter.launcher.ARouter;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.youth.banner.Banner;
import com.youth.banner.listener.OnBannerListener;
import com.youth.banner.loader.ImageLoader;
import com.youth.banner.loader.ImageLoaderInterface;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.RxBus;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.imageloader.RoundPressImageView;
import com.yy.mobile.main.init.IDelayShowCore;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.plugin.homeapi.InteractFragmentSubTabAction;
import com.yy.mobile.plugin.homeapi.arouter.ARouterUtil;
import com.yy.mobile.plugin.homeapi.tab.HomeTabInfo;
import com.yy.mobile.plugin.homeapi.tab.SubTabId;
import com.yy.mobile.plugin.homepage.ui.home.HomeTabId;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IAuthClient_onLogout_EventArgs;
import com.yy.mobile.plugin.main.events.IDiscoverPageClient_onDiscoverPageVisibleChanged_EventArgs;
import com.yy.mobile.plugin.main.events.IDiscoveryRedDotClient_notifyShowRedDot_EventArgs;
import com.yy.mobile.plugin.main.events.IDiscoveryRedDotClient_notifyTabRedDot_EventArgs;
import com.yy.mobile.ui.community.DiscoveryRedDotUtil;
import com.yy.mobile.ui.home.ITabAction;
import com.yy.mobile.ui.home.ITabId;
import com.yy.mobile.ui.interact.InteractFragment$$EventBinder;
import com.yy.mobile.ui.interact.adapter.InteractSubPageAdapter;
import com.yy.mobile.ui.interact.bean.InteractBanner;
import com.yy.mobile.ui.interact.bean.InteractBannerInfo;
import com.yy.mobile.ui.interact.model.InteractModel;
import com.yy.mobile.ui.refreshutil.IRefreshToHead;
import com.yy.mobile.ui.utils.DimensUtils;
import com.yy.mobile.ui.widget.BaseFragment;
import com.yy.mobile.ui.widget.PagerSlidingTabStrip;
import com.yy.mobile.ui.widget.pager.PagerFragment;
import com.yy.mobile.ui.widget.pager.SelectedViewPager;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.live.cache.HpImageLoader;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import io.reactivex.functions.Consumer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@Route(path="/Discovery/Home", name="\u53d1\u73b0")
@RouteDoc(desc="\u53d1\u73b0tab", minVer="7.16.0", eg=" yymobile://Discovery/Home")
public class InteractFragment
extends PagerFragment
implements ITabAction {
    public static final String ACTION_INTERACTFRAGMENT_CREATE = "ACTION_INTERACTFRAGMENT_CREATE";
    public static final String TAB_PLAY_TOGETHER = "playTogether";
    public static final String TAB_WORLD_CUP = "worldcup";
    public static final String IS_WORLD_CUP_RED_CLICKED = "IS_WORLD_CUP_RED_CLICKED";
    private static final String TAG = "InteractFragment";
    @Autowired(name="tag_2")
    @AutowiredDoc(desc="\u8df3\u8f6c\u5230\u53d1\u73b0tab\u4e0b\u7684\u54ea\u4e2a\u9875\u9762", minVer="7.16", eg="/Discovery/PvpSquare")
    public String jumpToTag;
    ITabId[] mTabIds = new ITabId[]{SubTabId.MORE};
    List<HomeTabInfo> mTabInfos = new ArrayList<HomeTabInfo>();
    private View mRootView;
    private InteractSubPageAdapter mInteractAdapter;
    private SelectedViewPager mInteractPager;
    private PagerSlidingTabStrip mInteractPagerTabs;
    private Banner mDiscoverBanner;
    private LinearLayout mDiscoverBannerll;
    private InteractModel interactModel;
    private List<String> bannerImages = new CopyOnWriteArrayList<String>();
    private List<InteractBanner> mInteractBannerList = new CopyOnWriteArrayList<InteractBanner>();
    private static final String MOVIE_CHANNEL_TOP_BANNER_CLICK = "0005";
    private static final String MOVIE_CHANNEL_TOP_BANNER_EXPOSURE = "0004";
    private static final String MOVIE_CHANNEL_EVENT_ID = "52908";
    private static final int MIN_DELAY_TIME = 1000;
    private static long lastClickTime;
    private EventBinder mEventBinder;

    public static InteractFragment newInstance() {
        InteractFragment interactFragment = new InteractFragment();
        Bundle bundle = new Bundle();
        interactFragment.setArguments(bundle);
        return interactFragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getSubTabInfos();
    }

    @SuppressLint(value={"CheckResult"})
    private void getSubTabInfos() {
        YYStore.INSTANCE.dispatch((ReqAction)new InteractFragmentSubTabAction(this.getContext(), this.mTabIds, HomeTabId.DISCOVER)).subscribe((Consumer)new Consumer<List<HomeTabInfo>>(){

            public void accept(List<HomeTabInfo> homeTabInfo) {
                MLog.info((Object)InteractFragment.TAG, (String)"getSubTabInfos:%s", (Object[])new Object[]{InteractFragment.this.mTabInfos});
                InteractFragment.this.mTabInfos = homeTabInfo;
            }
        }, RxUtils.errorConsumer((String)TAG));
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        MLog.info((String)TAG, (String)("[onCreateView] " + ((Object)((Object)this)).getClass().getName()));
        this.mRootView = inflater.inflate(R.layout.fragment_interact_newstyle, container, false);
        this.mDiscoverBanner = (Banner)this.mRootView.findViewById(R.id.discoverBanner);
        this.mDiscoverBannerll = (LinearLayout)this.mRootView.findViewById(R.id.discoverBannerll);
        this.mInteractPagerTabs = (PagerSlidingTabStrip)this.mRootView.findViewById(R.id.tabs_interact);
        this.mInteractPagerTabs.setIndicatorHeight(ScreenUtil.getInstance().dip2px(3));
        this.mInteractPagerTabs.setTypeface(null, 0);
        this.mInteractPagerTabs.setTabBackground(R.drawable.nav_white_bg);
        this.mInteractPagerTabs.setUseFadeEffect(true);
        this.mInteractPagerTabs.setFadeEnabled(true);
        this.mInteractPagerTabs.setZoomMax(0.1f);
        this.setInteractFragmentStyle(this.mInteractPagerTabs, this.mRootView.findViewById(R.id.top_tabs_divider));
        this.mInteractPager = (SelectedViewPager)this.mRootView.findViewById(R.id.sp_interact);
        this.mInteractAdapter = new InteractSubPageAdapter(this.getContext(), this.getChildFragmentManager(), this.getArguments());
        this.mInteractPager.setAdapter((PagerAdapter)this.mInteractAdapter);
        this.mInteractPagerTabs.setViewPager((ViewPager)this.mInteractPager);
        this.mInteractPagerTabs.setOnPageChangeListener(new PagerSlidingTabStrip.SlidingTabListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int oldPosition, int position) {
                HomeTabInfo naviInfo = InteractFragment.this.mTabInfos.get(position);
                String tabId = naviInfo.getTabId().getId();
                Property property = new Property();
                property.putString("key1", String.valueOf(position));
                property.putString("key2", String.valueOf(naviInfo.getAlias()));
                property.putString("key3", "discover");
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("50001", InteractFragment.MOVIE_CHANNEL_TOP_BANNER_EXPOSURE, (Serializable)property);
                if (InteractFragment.TAB_WORLD_CUP.equals(naviInfo.getAlias())) {
                    InteractFragment.this.onWorldCupTabClicked();
                }
                switch (tabId) {
                    case "/Discovery/More": {
                        InteractFragment.this.mInteractPagerTabs.showOrHideRed(position, false);
                        DiscoveryRedDotUtil.getInstance().setRefAppCounts(0);
                        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("52901", "0003");
                        break;
                    }
                    case "/Nearby/Home": {
                        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("52901", "0001");
                        break;
                    }
                    case "/WolfGame/Home": {
                        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("52901", "0002");
                        break;
                    }
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.refreshTab(this.mTabInfos);
        int redDotCount = DiscoveryRedDotUtil.getInstance().getRefAppCounts();
        this.notifyShowRedDot(redDotCount > 0);
        boolean isShowPlayTogetherRedDot = false;
        if (CoreFactory.getCore(IDelayShowCore.class) != null) {
            isShowPlayTogetherRedDot = ((IDelayShowCore)CoreFactory.getCore(IDelayShowCore.class)).isShowPlayTogetherRedDot();
        }
        this.notifyTabRedDot(TAB_PLAY_TOGETHER, isShowPlayTogetherRedDot);
        this.showWorldCupTabRedDot();
        return this.mRootView;
    }

    private void setInteractFragmentStyle(PagerSlidingTabStrip tabHost, View tabBottomDividerLine) {
        tabBottomDividerLine.setVisibility(0);
        ViewGroup.LayoutParams layoutParams = tabHost.getLayoutParams();
        layoutParams.width = -2;
        tabHost.setLayoutParams(layoutParams);
        tabHost.setNewStyle(true);
        tabHost.setIndicatorHeight(0);
        tabHost.setTextSize(20);
        tabHost.setTabPaddingLeftRight(DimensUtils.dip2pixel((Context)tabHost.getContext(), (float)12.0f));
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.interactModel = (InteractModel)ViewModelProviders.of((Fragment)this).get(InteractModel.class);
        this.interactModel.discoverBannerRepo().observe(this.getViewLifecycleOwner(), (Observer)new Observer<InteractBannerInfo>(){

            public void onChanged(@Nullable InteractBannerInfo interactBannerInfo) {
                InteractFragment.this.bannerImages.clear();
                if (interactBannerInfo != null) {
                    InteractFragment.this.mInteractBannerList = interactBannerInfo.getBanners();
                    MLog.info((String)InteractFragment.TAG, (String)("[discoverBannerRepo] observe: " + interactBannerInfo.toString()));
                }
                if (InteractFragment.this.mInteractBannerList.size() != 0) {
                    InteractFragment.this.mDiscoverBannerll.setVisibility(0);
                    for (InteractBanner item : InteractFragment.this.mInteractBannerList) {
                        InteractFragment.this.bannerImages.add(item.getPicUrl());
                        Property property = new Property();
                        property.putString("key1", String.valueOf(item.getId()));
                        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(InteractFragment.MOVIE_CHANNEL_EVENT_ID, InteractFragment.MOVIE_CHANNEL_TOP_BANNER_EXPOSURE, (Serializable)property);
                    }
                    InteractFragment.this.mDiscoverBanner.setOnBannerListener(new OnBannerListener(){

                        public void OnBannerClick(int position) {
                            if (!InteractFragment.isLastClick() && InteractFragment.this.mInteractBannerList != null) {
                                MLog.info((String)InteractFragment.TAG, (String)("bannerurl:" + InteractFragment.this.mInteractBannerList.get(position)));
                                ARouter.getInstance().build(Uri.parse((String)((InteractBanner)InteractFragment.this.mInteractBannerList.get(position)).getActionUrl())).navigation(InteractFragment.this.getContext());
                                Property property = new Property();
                                property.putString("key1", String.valueOf(((InteractBanner)InteractFragment.this.mInteractBannerList.get(position)).getId()));
                                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(InteractFragment.MOVIE_CHANNEL_EVENT_ID, InteractFragment.MOVIE_CHANNEL_TOP_BANNER_CLICK, (Serializable)property);
                            }
                        }
                    });
                    InteractFragment.this.mDiscoverBanner.setIndicatorGravity(5);
                    InteractFragment.this.mDiscoverBanner.setImages(InteractFragment.this.bannerImages).isAutoPlay(true).setImageLoader((ImageLoaderInterface)new GlideImageLoader()).start();
                } else {
                    InteractFragment.this.mDiscoverBannerll.setVisibility(8);
                }
            }
        });
        this.interactModel.fetchBannerData();
    }

    private void refreshTab(List<HomeTabInfo> infos) {
        MLog.info((Object)TAG, (String)"refreshTab:%s", (Object[])new Object[]{infos});
        if (this.mInteractAdapter != null) {
            this.mInteractAdapter.setData(infos);
            int selectedIndex = this.getSelectedIndexForDiscovery(infos);
            this.mInteractPager.setCurrentItem(selectedIndex);
            if (this.mInteractPagerTabs != null) {
                this.mInteractPagerTabs.notifyDataSetChanged();
            }
        }
    }

    private int getSelectedIndexForDiscovery(List<HomeTabInfo> infoList) {
        int index = 0;
        for (int i = 0; i < infoList.size(); ++i) {
            if (!infoList.get(i).isSelected()) continue;
            index = i;
        }
        return index;
    }

    public void onResume() {
        super.onResume();
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            int index;
            String tag = ARouterUtil.INSTANCE.getRoutePathForBundle(bundle);
            MLog.debug((String)TAG, (String)("[onResume] tag = " + tag));
            if (tag != null && (index = this.findIndexByTAG(tag)) != -1) {
                this.mInteractPager.setCurrentItem(index);
                BaseFragment item = this.mInteractAdapter.getCurrenFragment();
                if (item != null && item.getArguments() != null) {
                    MLog.debug((String)TAG, (String)("[onResume] object = " + item + ", bundle = " + bundle.toString()));
                    item.getArguments().putAll(bundle);
                }
            }
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    private int findIndexByTAG(String tag) {
        if (!FP.empty((CharSequence)tag)) {
            for (int i = 0; i < this.mTabInfos.size(); ++i) {
                HomeTabInfo info = this.mTabInfos.get(i);
                if (!tag.equals(info.getTabId().getId())) continue;
                return i;
            }
        }
        return -1;
    }

    public void onDestroy() {
        super.onDestroy();
    }

    private void showWorldCupTabRedDot() {
        boolean isWorldTabClicked = CommonPref.instance().getBoolean(IS_WORLD_CUP_RED_CLICKED, false);
        this.notifyTabRedDot(TAB_WORLD_CUP, !isWorldTabClicked);
    }

    private void onWorldCupTabClicked() {
        CommonPref.instance().putBoolean(IS_WORLD_CUP_RED_CLICKED, true);
        this.notifyTabRedDot(TAB_WORLD_CUP, false);
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void notifyShowRedDot(IDiscoveryRedDotClient_notifyShowRedDot_EventArgs busEventArgs) {
        boolean showRed = busEventArgs.getShowRed();
        this.notifyShowRedDot(showRed);
    }

    public void notifyShowRedDot(boolean showRed) {
        int idx = -1;
        for (int i = 0; i < this.mTabInfos.size(); ++i) {
            HomeTabInfo info = this.mTabInfos.get(i);
            if (!"/Discovery/More".equals(info.getTabId().getId())) continue;
            idx = i;
            break;
        }
        if (this.mInteractPager.getCurrentItem() == idx) {
            DiscoveryRedDotUtil.getInstance().setRefAppCounts(0);
            showRed = false;
        }
        this.mInteractPagerTabs.showOrHideRed(idx, showRed);
    }

    @BusEvent
    public void onLogout(IAuthClient_onLogout_EventArgs busEventArgs) {
        this.notifyTabRedDot(TAB_PLAY_TOGETHER, false);
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void notifyTabRedDot(IDiscoveryRedDotClient_notifyTabRedDot_EventArgs busEventArgs) {
        String tabAlias = busEventArgs.getTabAlias();
        boolean isShow = busEventArgs.getIsShow();
        this.notifyTabRedDot(tabAlias, isShow);
    }

    public void notifyTabRedDot(String tabAlias, boolean isShow) {
        if (tabAlias != null && this.mInteractAdapter != null) {
            int index = this.mInteractAdapter.getTabPosition(tabAlias);
            if (this.mInteractPager != null && index != -1) {
                this.mInteractPagerTabs.showOrHideRed(index, isShow);
            }
        }
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        RxBus.getDefault().post((Object)new IDiscoverPageClient_onDiscoverPageVisibleChanged_EventArgs(!hidden));
        if (!hidden && this.interactModel != null) {
            this.interactModel.fetchBannerData();
        }
    }

    public void onTabChange() {
        MLog.info((String)TAG, (String)"onTabChange");
    }

    public void onTabDoubleClick() {
        MLog.info((String)TAG, (String)"onTabDoubleClick");
        if (this.mInteractAdapter != null) {
            BaseFragment f = this.mInteractAdapter.getPosFragment(this.mInteractPager.getCurrentItem());
            if (f instanceof IRefreshToHead) {
                ((IRefreshToHead)f).refreshData();
            } else if (f instanceof ITabAction) {
                ((ITabAction)f).onTabDoubleClick();
            }
        }
        if (this.interactModel != null) {
            this.interactModel.fetchBannerData();
        }
    }

    private static boolean isLastClick() {
        boolean flag = true;
        long currentClickTime = System.currentTimeMillis();
        MLog.info((String)TAG, (String)("jiangeTime is " + (currentClickTime - lastClickTime)));
        if (currentClickTime - lastClickTime >= 1000L) {
            flag = false;
        }
        lastClickTime = currentClickTime;
        return flag;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new InteractFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    class GlideImageLoader
    extends ImageLoader {
        GlideImageLoader() {
        }

        public void displayImage(Context context, Object path, ImageView imageView) {
            RequestOptions options = new RequestOptions().diskCacheStrategy(DiskCacheStrategy.ALL).placeholder(R.drawable.default_live_drawable).dontAnimate();
            HpImageLoader.INSTANCE.loadImage(imageView, String.valueOf(path), options);
        }

        public ImageView createImageView(Context context) {
            RoundPressImageView roundPressImageView = new RoundPressImageView(context);
            roundPressImageView.setDetachResetDrawableFlag(false);
            return roundPressImageView;
        }
    }
}

