/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.interact;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.Nullable;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.annotation.RouteDoc;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.perf.PerfSDK;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IDiscoveryClient_onGetDiscoveryInfo_EventArgs;
import com.yy.mobile.small.SmallProxy;
import com.yy.mobile.statistic.StatisticService;
import com.yy.mobile.ui.community.DiscoveryAdapter;
import com.yy.mobile.ui.interact.InteractAppFragment$$EventBinder;
import com.yy.mobile.ui.interact.InteractAppPresenter;
import com.yy.mobile.ui.interact.InteractAppPresenterImpl;
import com.yy.mobile.ui.widget.pager.PagerFragment;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.community.DiscoveryCoreImpl;
import com.yymobile.core.community.entity.Modules;
import com.yymobile.core.interact.IInteractCore;
import com.yymobile.core.plugincenter.CommunityItemInfo;
import com.yymobile.core.statistic.CommunityPageLoadCostSampling;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.List;

@Route(path="/Discovery/More", name="\u53d1\u73b0\u66f4\u591a")
@RouteDoc(desc="\u53d1\u73b0tab\u91cc\u9762\u6bcf\u4e2aitem\u7684>", minVer="7.16.0", eg="yymobile://Discovery/More")
public class InteractAppFragment
extends PagerFragment
implements DiscoveryAdapter.OnClickItemListener {
    private static final String TAG = "InteractAppFragment";
    private final boolean refresh = true;
    private View mRootView;
    private ListView mLvApp;
    private DiscoveryAdapter mAdapter;
    private boolean mHasData;
    private List<Disposable> mDisposableList;
    private InteractAppPresenter mInteractAppPresenter;
    private EventBinder mEventBinder;

    public void onDestroy() {
        super.onDestroy();
        if (this.mDisposableList != null) {
            for (Disposable d2 : this.mDisposableList) {
                d2.dispose();
            }
        }
        if (this.mInteractAppPresenter != null) {
            this.mInteractAppPresenter.onDisponse();
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.fragment_interact_app, container, false);
        this.mLvApp = (ListView)this.mRootView.findViewById(R.id.lv_app);
        this.mAdapter = new DiscoveryAdapter((Context)this.getActivity());
        this.mLvApp.setAdapter((ListAdapter)this.mAdapter);
        return this.mRootView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.init();
        this.requestDisvoveryData();
        Disposable disposable2 = RxBus.getDefault().register(CommunityItemInfo.class).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<CommunityItemInfo>(){

            public void accept(@NonNull CommunityItemInfo communityItemInfo) throws Exception {
                if (InteractAppFragment.this.mAdapter != null) {
                    InteractAppFragment.this.mAdapter.addData(new Modules(communityItemInfo), communityItemInfo.getPosition(), false);
                }
            }
        }, RxUtils.errorConsumer((String)TAG));
        this.mDisposableList.add(disposable2);
    }

    private void init() {
        this.mAdapter.setOnClickListener(this);
        this.mDisposableList = new ArrayList<Disposable>();
        this.mInteractAppPresenter = new InteractAppPresenterImpl((Activity)this.getActivity());
    }

    private void requestDisvoveryData() {
        MLog.info((String)TAG, (String)"dexian requestDisvoveryData start");
        DiscoveryCoreImpl.get().getDiscoveryInfo(true);
        this.showLoading();
    }

    public View.OnClickListener getLoadListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                InteractAppFragment.this.requestDisvoveryData();
            }
        };
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onGetDiscoveryInfo(IDiscoveryClient_onGetDiscoveryInfo_EventArgs busEventArgs) {
        int code = busEventArgs.getCode();
        List data = busEventArgs.getData();
        boolean refresh = busEventArgs.getRefresh();
        ((CommunityPageLoadCostSampling)StatisticService.instance().get(CommunityPageLoadCostSampling.class)).end();
        PerfSDK.instance().end(50021, "community_page_load_timecost");
        if (this.checkActivityValid() && code == 0 && data != null) {
            if (data != null && data.size() > 0 && this.mAdapter != null) {
                MLog.info((String)TAG, (String)("dexian, onGetDiscoveryInfo code = " + code + " data.size = " + (data != null ? Integer.valueOf(data.size()) : "0")));
                this.mAdapter.setDataSource(data, refresh);
                this.mAdapter.addData(((IInteractCore)CoreFactory.getCore(IInteractCore.class)).makeNoDataModule(), 0, false);
                SmallProxy.startAction((Intent)new Intent("COMMUNITY_MENU_ADD"), (Activity)this.getActivity(), (ViewGroup)((ViewGroup)this.mRootView));
            }
            if (!this.mHasData) {
                this.mHasData = true;
            }
            this.hideStatus();
        } else if (!this.mHasData) {
            if (!NetworkUtils.isNetworkStrictlyAvailable((Context)this.getContext())) {
                this.showNetworkErr();
            } else {
                this.showNoData(R.drawable.no_message_bg, R.string.str_no_data_mesaage);
            }
        } else if (!NetworkUtils.isNetworkStrictlyAvailable((Context)this.getContext())) {
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getResources().getString(R.string.nonetwork), (int)0).show();
        }
    }

    @Override
    public void onClickItem(int position, Modules modules) {
        if (modules.getActionUrl().contains("/VoiceRoom/Home") && this.checkNetToast()) {
            this.mInteractAppPresenter.checkVoiceRoomPlugin(modules.getActionUrl());
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new InteractAppFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

