/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home.navto;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.ILiveCoreClient_onTopicListInfo_EventArgs;
import com.yy.mobile.ui.home.navto.TopicListFragment$$EventBinder;
import com.yy.mobile.ui.refreshutil.IRefreshToHead;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.ui.widget.pager.PagerFragment;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.live.livecore.ILiveCore;
import com.yymobile.core.live.livecore.SpeItemInfo;
import java.util.ArrayList;
import java.util.List;

public class TopicListFragment
extends PagerFragment
implements IRefreshToHead {
    private PullToRefreshListView mListView;
    private EndlessListScrollListener mEndlessListScrollListener;
    private TopicListAdapter mAdapter;
    private int mPageNo = 1;
    private final int startPageNo = 1;
    private int index = -1;
    private boolean isClear;
    private boolean isLastPage = false;
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();
    private Runnable checkRequestTimeoutTask = new Runnable(){

        @Override
        public void run() {
            TopicListFragment.this.finishLoadData();
            if (TopicListFragment.this.mAdapter != null && TopicListFragment.this.mAdapter.getCount() > 0) {
                TopicListFragment.this.checkNetToast();
            } else {
                TopicListFragment.this.showNetworkErr();
            }
        }
    };
    View.OnClickListener mOnclick = new View.OnClickListener(){

        public void onClick(View v) {
            if (TopicListFragment.this.mTimeSlotTool.isProcessing()) {
                return;
            }
            TopicListFragment.this.showLoading();
            TopicListFragment.this.reLoadData();
        }
    };
    private boolean mHasRequest;
    private EventBinder mEventBinder;

    public static TopicListFragment newInstance() {
        TopicListFragment fragment = new TopicListFragment();
        Bundle bundle = new Bundle();
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle arguMent = this.getArguments();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_living_topic_list, container, false);
        this.mListView = (PullToRefreshListView)view.findViewById(R.id.living_topic_list_view);
        this.mListView.setOnRefreshListener((PullToRefreshBase.OnRefreshListener)new PullToRefreshBase.OnRefreshListener<ListView>(){

            public void onRefresh(PullToRefreshBase<ListView> refreshView) {
                TopicListFragment.this.reLoadData();
            }
        });
        this.mAdapter = new TopicListAdapter((Context)this.getActivity());
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        ((ListView)this.mListView.getRefreshableView()).setSelector(R.drawable.transparent);
        this.mEndlessListScrollListener = new EndlessListScrollListener((StatusLayout)view.findViewById(R.id.living_topic_container));
        this.mEndlessListScrollListener.setVisibleThreshold(3);
        this.mEndlessListScrollListener.setListener(new EndlessListScrollListener.EndlessListener(){

            public void onLoadData() {
                if (TopicListFragment.this.checkNetToast()) {
                    TopicListFragment.this.loadMoreData();
                } else {
                    TopicListFragment.this.mEndlessListScrollListener.onLoadComplete();
                    TopicListFragment.this.mListView.onRefreshComplete();
                }
            }

            public boolean shouldLoadData() {
                return TopicListFragment.this.checkNetToast() && !TopicListFragment.this.isLastPage;
            }
        });
        this.mListView.setOnScrollListener((AbsListView.OnScrollListener)this.mEndlessListScrollListener);
        this.showLoading(view);
        this.reLoadData();
        return view;
    }

    public void onPageScrollComplete(int position) {
        super.onPageScrollComplete(position);
        if (this.mAdapter != null && this.mAdapter.getCount() == 0 && this.isNetworkAvailable()) {
            this.reLoadData();
        }
    }

    private void loadData() {
        this.getHandler().postDelayed(this.checkRequestTimeoutTask, 10000L);
        ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).requestTopicListPage(this.mPageNo);
    }

    private void reLoadData() {
        this.isClear = true;
        this.mPageNo = 1;
        this.loadData();
    }

    private void loadMoreData() {
        this.isClear = false;
        ++this.mPageNo;
        this.loadData();
    }

    private void finishLoadData() {
        if (this.mListView != null) {
            this.mListView.onRefreshComplete();
        }
        if (this.mEndlessListScrollListener != null) {
            this.mEndlessListScrollListener.onLoadComplete();
        }
    }

    public View.OnClickListener getLoadListener() {
        return this.mOnclick;
    }

    public View.OnClickListener getNoMobileLiveDataListener() {
        return this.mOnclick;
    }

    @BusEvent
    public void onTopicListInfo(ILiveCoreClient_onTopicListInfo_EventArgs busEventArgs) {
        int code = busEventArgs.getCode();
        ArrayList data = busEventArgs.getData();
        int page = busEventArgs.getPage();
        int isLast = busEventArgs.getIsLast();
        this.mHasRequest = false;
        this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        this.mEndlessListScrollListener.onLoadComplete();
        this.mListView.onRefreshComplete();
        this.hideStatus();
        if (data != null && code != -1) {
            boolean bl = this.isLastPage = isLast == 1;
            if (data != null && data.size() != 0) {
                this.mAdapter.setData(data, this.isClear, this.isLastPage);
            } else if (page == 1) {
                this.mAdapter.clearData();
                this.showNoData(R.drawable.mobile_live_personal_replay_no_data, "\u6682\u65e0\u4e13\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u6765");
            }
        } else if (this.mAdapter != null && this.mAdapter.getCount() > 0) {
            this.checkNetToast();
        } else {
            this.showNetworkErr();
        }
    }

    private void loadPage(boolean isShow, View view) {
        boolean isNetWork;
        if (isShow) {
            this.showLoading(view, 0, 0);
        }
        if (isNetWork = this.isNetworkAvailable()) {
            this.getHandler().postDelayed(this.checkRequestTimeoutTask, 10000L);
            long uid = LoginUtil.getUid();
            this.mPageNo = 1;
            ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).requestTopicListPage(this.mPageNo);
        } else if (!isNetWork) {
            this.showReload(view, 0, 0);
        }
    }

    public void refreshData() {
        if (this.mListView != null) {
            this.getHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    ((ListView)TopicListFragment.this.mListView.getRefreshableView()).setSelection(0);
                }
            }, 10L);
            this.reLoadData();
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new TopicListFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    private static class ViewHolder {
        View container;
        RecycleImageView pic;
        TextView topicName;
        TextView topicDesc;

        private ViewHolder() {
        }
    }

    private class TopicListAdapter
    extends BaseAdapter {
        private Context mContext;
        private static final int ITEM_TYPE_TOPIC = 0;
        private static final int ITEM_TYPE_FOOTER = 1;
        private static final int TYPE_COUNT = 3;
        private List<SpeItemInfo> mData = new ArrayList<SpeItemInfo>();
        private ViewHolder holder;

        TopicListAdapter(Context context) {
            this.mContext = context;
        }

        public int getCount() {
            return this.mData.size();
        }

        public SpeItemInfo getItem(int position) {
            return this.mData.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public int getItemViewType(int position) {
            if (this.getItem((int)position).viewType == 0) {
                return 0;
            }
            if (this.getItem((int)position).viewType == 1) {
                return 1;
            }
            return -1;
        }

        public int getViewTypeCount() {
            return 3;
        }

        private void doOnClick(SpeItemInfo item) {
            if (!TextUtils.isEmpty((CharSequence)item.url)) {
                ARouter.getInstance().build(Uri.parse((String)item.url)).navigation(this.mContext);
            }
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            final SpeItemInfo item = this.getItem(position);
            if (item.viewType == 0) {
                if (convertView == null) {
                    convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_mobile_lvbc_feature_list, parent, false);
                    this.holder = new ViewHolder();
                    this.holder.container = convertView.findViewById(R.id.mob_lvbc_container_l);
                    this.holder.pic = (RecycleImageView)convertView.findViewById(R.id.mob_lvbc_thumb_l);
                    this.holder.topicName = (TextView)convertView.findViewById(R.id.mob_lvbc_topicname);
                    this.holder.topicDesc = (TextView)convertView.findViewById(R.id.mob_lvbc_topicdesc);
                    DisplayMetrics dm = TopicListFragment.this.getResources().getDisplayMetrics();
                    int wScreen = dm.widthPixels;
                    RelativeLayout.LayoutParams para = (RelativeLayout.LayoutParams)this.holder.pic.getLayoutParams();
                    para.width = dm.widthPixels;
                    para.height = wScreen * 9 / 16;
                    this.holder.pic.setLayoutParams((ViewGroup.LayoutParams)para);
                    convertView.setTag((Object)this.holder);
                } else {
                    this.holder = (ViewHolder)convertView.getTag();
                }
                if (item != null) {
                    ImageLoader.loadImage((String)item.pic, (RecycleImageView)this.holder.pic, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.mobile_live_default_background);
                    this.holder.topicName.setText((CharSequence)item.name);
                    this.holder.topicDesc.setText((CharSequence)item.desc);
                    this.holder.container.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (TopicListFragment.this.mTimeSlotTool.isProcessing()) {
                                return;
                            }
                            TopicListAdapter.this.doOnClick(item);
                        }
                    });
                }
            } else if (item.viewType == 1) {
                convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_mobile_broadcast_footer, parent, false);
            }
            return convertView;
        }

        public void setData(List<SpeItemInfo> liveList, boolean clear, boolean isLastPage) {
            if (liveList == null) {
                return;
            }
            if (clear) {
                this.mData.clear();
            }
            this.mData.addAll(liveList);
            if (isLastPage) {
                SpeItemInfo item = new SpeItemInfo();
                item.viewType = 1;
                this.mData.add(item);
            }
            this.notifyDataSetChanged();
        }

        public void clearData() {
            this.mData.clear();
            this.notifyDataSetChanged();
        }

        public int getItemIndex(SpeItemInfo itemInfo) {
            return this.mData.indexOf(itemInfo);
        }
    }
}

